<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<!--English revision 1.7 -->
<HTML>
<HEAD>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<TITLE>Configuration globale du serveur</TITLE>
</HEAD>

<!-- Background white, links blue (unvisited), navy (visited), red (active) -->
<BODY
 BGCOLOR="#FFFFFF"
 TEXT="#000000"
 LINK="#0000FF"
 VLINK="#000080"
 ALINK="#FF0000"
>
<!--#include virtual="header.html" -->
<h1 align="center">Configuration globale du serveur</h1>

<p>Ce document dcrit certaines directives traites par le
<a href="mod/core.html">noyau</A> du serveur qui sont utilises pour
configurer les oprations de base du serveur.</p>

<ul>
<li><a href="#identification">Identification du serveur</a></li>
<li><a href="#locations">Emplacement des fichiers</a></li>
<li><a href="#process">Cration des processus</a></li>
<li><a href="#network">Configuration rseau</a></li>
<li><a href="#resource">Limitation de l'utilisation des ressources</a></li>
</ul>

<hr>

<h2><a name="identification">Identification du serveur</a></h2>

<table border="1">
<tr><td valign="top">
<strong>Directives associes</strong><br><br>

<A HREF="mod/core.html#servername">ServerName</A><br>
<A HREF="mod/core.html#serveradmin">ServerAdmin</A><br>
<A HREF="mod/core.html#serversignature">ServerSignature</A><br>
<A HREF="mod/core.html#servertokens">ServerTokens</A><br>
<A HREF="mod/core.html#usecanonicalname">UseCanonicalName</A><br>
</td></tr></table>

<p>Les directives <code>ServerAdmin</code> and <code>ServerTokens</code>
contrlent quelles informations du serveur seront prsentes
dans les pages gnres par le serveur telles que les messages
d'erreur. La directive <code>ServerTokens</code> assigne la valeur du champ serveur 
dans les en-ttes de rponse HTTP.</p>

<p>Les directives <code>ServerName</code> and <code>UseCanonicalName</code>
sont utilises pour dterminer comment former les URLs s'auto
rfrenant. Par exemple, quand un client requiert un
rpertoire, mais n'inclut pas de barre oblique finale dans le nom du 
rpertoire, Apache doit rediriger le client vers le nom complet, incluant
la barre oblique finale permettant ainsi au client de rsoudre correctement
les rfrences relatives contenues dans le document.</p>

<hr>

<h2><a name="locations">Emplacement des fichiers</a></h2>

<table border="1">
<tr><td valign="top">
<strong>Directives associes</strong><br><br>

<a href="mod/core.html#coredumpdirectory">CoreDumpDirectory</a><br>
<a href="mod/core.html#documentroot">DocumentRoot</a><br>
<a href="mod/core.html#errorlog">ErrorLog</a><br>
<a href="mod/core.html#lockfile">Lockfile</a><br>
<a href="mod/core.html#pidfile">PidFile</a><br>
<a href="mod/core.html#scoreboardfile">ScoreBoardFile</a><br>
<a href="mod/core.html#serverroot">ServerRoot</a><br>
</td></tr></table>

<p>Ces directives contrlent les emplacements des diffrents 
fichiers qu'Apache a besoin pour ses propres besoins. Quand le chemin employ
ne commence pas par une barre oblique, les fichiers sont localiss 
relativement  <code>ServerRoot</code>. Soyez attentifs  placer
ces fichiers dans des chemins qui sont autoriss en criture aux
utilisateurs autres que root. Voir les 
<a href="misc/security_tips.html">trucs sur la scurit</a> pour 
plus de dtails.</p>

<hr>

<h2><a name="process">Cration des processus</a></h2>

<table border="1">
<tr><td valign="top">
<strong>Directives associes</strong><br><br>

<a href="mod/core.html#bs2000account">BS2000Account</a><br>
<a href="mod/core.html#group">Group</a><br>
<a href="mod/core.html#maxclients">MaxClients</a><br>
<a href="mod/core.html#maxrequestsperchild">MaxRequestsPerChild</a><br>
<a href="mod/core.html#maxspareservers">MaxSpareServers</a><br>
<a href="mod/core.html#minspareservers">MinSpareServers</a><br>
<a href="mod/core.html#servertype">ServerType</a><br>
<a href="mod/core.html#startservers">StartServers</a><br>
<a href="mod/core.html#threadsperchild">ThreadsPerChild</a><br>
<a href="mod/core.html#user">User</a><br>
</td></tr></table>

<p>Si la directive <code>ServerType</code> est dfinie avec la 
valeur recommande de <code>Standalone</code>, 
Apache 1.3 sur Unix est bas sur modle de prlancement
des processus. Un unique processus de contrle est responsable de lancer
des processus fils qui coutent les connexions et les traitent  
leur arrive. Apache essaye de maintenir un certain nombre processus
en rserve ou inactifs, qui restent toujours prts  traiter
les requtes arrivantes. De cette manire, les clients n'ont pas 
 attendre que de nouveaux processus fils soient lancs avant que 
leurs requtes soient traites.</p>

<p>Les directives <code>StartServers</code>, <code>MinSpareServers</code>,
<code>MaxSpareServers</code>, and <code>MaxServers</code> rgissent
comment le processus pre cre les processus fils pour traiter les
requtes. En gnral Apache se rgit seul correctement,
et la plupart des sites n'ont pas besoin d'ajuster la valeur de ces directives.
Les sites qui veulent servir plus de 256 requtes simultanes 
doivent augmenter la valeur de <code>MaxClients</code>, tandis que les sites
tournant sur des machines limites en mmoire doivent rduire
la valeur de  <code>MaxClients</code> afin d'viter d'utiliser le fichier
d'change. Plus d'informations sur le paramtrage de la 
cration des processus se trouvent dans la documentation 
<a href="misc/perf-tuning.html">Aide sur les performances gnrales</a>.</p>

<p>Tandis que le processus pre est gnralement lanc
en tant que root sous Unix pour se connecter sur le port 80, les processus fils
sont lancs sous un utilisateur moins privilgi.
Les directives <code>User</code> et <code>Group</code> servent  dfinir
les privilges des processus fils. Les processus fils doivent tre
capable de lire le contenu devant tre servi, mais doivent avoir le minimum
de privilges possibles. De plus,  moins que 
<a href="suexec.html">suexec</a> soit utilis, ces directives dfinissent 
galement les droits qui seront hrits par les scripts CGI.</p>

<p><code>MaxRequestsPerChild</code> contrle la frquence de 
rnovation des processus, en supprimant les anciens et en lanant de 
nouveaux.</p>

<p>Sous Windows, Apache lance un processus pre et un processus fils.
Le processus fils cre un ensemble de threads pour traiter les requtes.
Le nombre de threads est contrl par la directive
<code>ThreadsPerChild</code>.</p>

<hr>

<h2><a name="network">Configuration rseau</a></h2>

<table border="1">
<tr><td valign="top">
<strong>Directives associes</strong><br><br>

<a href="mod/core.html#bindaddress">BindAddress</a><br>
<a href="mod/core.html#keepalive">KeepAlive</a><br>
<a href="mod/core.html#keepalivetimeout">KeepAliveTimeout</a><br>
<a href="mod/core.html#listen">Listen</a><br>
<a href="mod/core.html#listenbacklog">ListenBackLog</a><br>
<a href="mod/core.html#maxkeepaliverequests">MaxKeepAliveRequests</a><br>
<a href="mod/core.html#port">Port</a><br>
<a href="mod/core.html#sendbuffersize">SendBufferSize</a><br>
<a href="mod/core.html#timeout">TimeOut</a><br>
</td></tr></table>

<p>Au dmarrage d'Apache, celui ci se connecte  un port et une 
adresse donns sur la machine locale et attend l'arrive de 
requtes. Par dfaut, il coute sur toutes les adresses,
et sur le port dfini par la directive <code>Port</code>. Toutefois,
on peut lui indiquer d'couter sur plus d'un port, de n'couter
qu' partir d'une seule adresse, ou une combinaison des deux. Ceci est
gnralement combin avec la fonction d'
<a href="vhosts/">hte virtuel</a> qui dtermine comment 
Apache rpond de diffrentes adresses IP, de noms d'htes et
de ports.</p>

<p>Il y a deux directives qui permettent de restreindre ou de spcifier
quelles adresses et quels ports Apache doit couter.
La directive <code>BindAddress</code> restreint le serveur  
n'couter qu'une seule adresse IP. La directive <code>Listen</code> peut
tre utilise pour spcifier un ensemble d'adresses et de 
ports qu'Apache doit couter.</p>

<p>Les directives <code>ListenBackLog</code>, <code>SendBufferSize</code>, and
<code>TimeOut</code> permettent d'adjuster comment Apache interagit avec
le rseau.</p>

<p>Les directives <code>KeepAlive</code>, <code>KeepAliveTimeout</code>, 
and <code>MaxKeepAliveRequests</code> dfinissent comment
Apache gre les connexions persistantes.</p>

<hr>
<h2><a name="resource">Limitation de l'utilisation des Ressources</a></h2>
<table border="1">
<tr><td valign="top">
<strong>Directives associes</strong><br><br>

<a href="mod/core.html#limitrequestbody">LimitRequestBody</a><br>
<a href="mod/core.html#limitrequestfields">LimitRequestFields</a><br>
<a href="mod/core.html#limitrequestfieldsize">LimitRequestFieldsize</a><br>
<a href="mod/core.html#limitrequestline">LimitRequestLine</a><br>
<a href="mod/core.html#rlimitcpu">RLimitCPU</a><br>
<a href="mod/core.html#rlimitmem">RLimitMEM</a><br>
<a href="mod/core.html#rlimitnproc">RLimitNPROC</a><br>
<a href="mod/core.html#threadstacksize">ThreadStackSize</a><br>
</td></tr></table>

<p>Les directives commenant par <code>LimitRequest</code>
sont employes pour fixer des limites sur la quantit de 
ressources qui seront utilises pendant la lecture des requtes clientes. En 
limitant ces valeurs, certains types de dni de service peuvent 
tre attnus.</p>

<p>Les directives commenant par <code>RLimit</code> sont employes
pour fixer des limites sur la quantit de ressources qu'utiliseront les processus
lancs par les processus enfants Apache.
En particulier, elles contrle les ressources utilises par les 
scripts CGI et les commandes exec SSI.</p>

<p>La directive <code>ThreadStackSize</code> est utilise seulement sur
Netware pour contrler la taille de la pile.</p>

<!--#include virtual="footer.html" -->
</BODY>
</HTML>
