<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<!-- Traduction anglais 1.18 -->
<title>Arrt et redmarrage d'Apache</title>
</head>
<!-- Background white, links blue (unvisited), navy (visited), red (active) -->
<body bgcolor="#FFFFFF" text="#000000" link="#0000FF" vlink=
"#000080" alink="#FF0000">
<!--#include virtual="header.html" -->
<h1 align="CENTER">Arrt et redmarrage
d'Apache</h1>

<p>Ce document dcrit l'arrt et le
redmarrage d'Apache sur Unix seulement. Les utilisateurs
de Windows sont invits  lire le paragraphe <a
href="windows.html#signal">signaler  Apache en cours
d'excution</a>.</p>

<p>Lorsque qu'Apache s'excute, vous pouvez noter que
plusieurs processus <code>httpd</code> s'excutent en
mme temps sur votre machine, mais vous ne devez envoyer de
signaux qu' celui dont l'identifiant de processus est
celui contenu dans le fichier <a href=
"mod/core.html#pidfile">PidFile</a>. Autrement dit, vous ne devez
jamais envoyer de signaux aux processus <code>httpd</code> autres
que le processus pre. Il existe trois signaux que vous
pouvez envoyer au processus pre : <code>TERM</code>,
<code>HUP</code>, et <code>USR1</code>, dont la signification est
dcrite ci dessous.</p>

<p>Pour envoyer un signal au pre vous pouvez utiliser une
commande comme</p>

<blockquote>
<pre>
    kill -TERM `cat /usr/local/apache/logs/httpd.pid`
</pre>
</blockquote>

Vous pouvez lire l'effet de la commande prcdente
en effectuant la commande 

<blockquote>
<pre>
    tail -f /usr/local/apache/logs/error_log
</pre>
</blockquote>

Ces exemples devront tre modifis en fonction des
valeurs des directives <a href=
"mod/core.html#serverroot">ServerRoot</a> et <a href=
"mod/core.html#pidfile">PidFile</a>. 

<p>Avec Apache 1.3 est fourni un script <a href=
"programs/apachectl.html">apachectl</a> qui peut tre
employ pour dmarrer, arrter et relancer
Apache. Il peut ncessiter un peu d'adaptation pour votre
systme, pour cela lisez les commentaires situs au
dbut de ce script.</p>

<h3>Signal TERM : arrt immdiat</h3>

<p>L'envoi du signal <code>TERM</code> demande au processus
pre d'essayer de tuer tous ses processus fils. Il peut
s'couler quelques secondes avant que tous les processus
fils ne soient tus. Le processus pre se termine
ensuite. Les requtes en cours sont termines et
plus aucune requte n'est traite.</p>

<h3>Signal HUP : redmarrage immdiat</h3>

<p>L'envoi du signal <code>HUP</code> demande au processus
pre de tuer tous ses processus fils, comme le signal
<code>TERM</code>, mais le processus pre ne se termine
pas. Il relit ses fichiers de configuration, et rouvre les
fichiers de trace. Il lance ensuite un nouvel ensemble de
processus fils et continue de traiter les requtes.</p>

<p>Les utilisateurs du module <a href=
"mod/mod_status.html">status</a> noteront que les statistiques du
serveur sont rinitialises  zro
aprs l'envoi du signal <code>HUP</code>.</p>

<p><strong>Note:</strong> si votre fichier de configuration
contient des erreurs lorsque vous demandez un redmarrage,
le processus pre ne se relancera pas mais se terminera
avec une erreur. Voir plus bas pour une mthode permettant
d'viter ce problme.</p>

<h3>Signal USR1 : redmarrage en douceur</h3>

<p><strong>Note:</strong> pour les versions infrieures
 1.2b9 cette fonction est instable et ne doit pas tre
utilise.</p>

<p>Le signal <code>USR1</code> demande au processus pre
de prier les processus de se terminer aprs avoir
trait leurs requtes en cours (ou de se terminer
immdiatement s'ils n'ont pas de traitement en cours).
Le processus pre relit les fichiers de configuration et
rouvre les fichiers de trace. Au fur et  mesure que les
fils meurent, ils sont remplacs par un processus fils
prenant en compte la nouvelle <em>gnration</em>
de la configuration, qui commence aussitt  traiter les
nouvelles requtes.</p>

<p>Cette fonction est conue pour toujours respecter les
valeurs de <a href="mod/core.html#maxclients">MaxClients</a>, <a
href="mod/core.html#minspareservers">MinSpareServers</a>, et <a
href="mod/core.html#maxspareservers">MaxSpareServers</a>. De
plus, elle respecte la valeur de <a href=
"mod/core.html#startservers">StartServers</a> de la
manire suivante : si aprs une seconde, au moins
StartServers nouveaux processus fils n'ont pas t
crs, alors elle en cre suffisament pour
combler le manque. Autrement dit, la fonction essaie de maintenir
 la fois le nombre de processus fils appropri
pour traiter la charge actuelle du serveur, et respecter vos
souhaits concernant le paramtre StartServers.</p>

<p>Les utilisateurs du module <a href=
"mod/mod_status.html">status</a> noteront que les statistiques du
serveur <strong>ne sont pas</strong> rinitialises
 zro aprs l'envoi du signal
<code>USR1</code>. La fonction est crite afin de
minimiser le temps durant lequel le serveur est incapable de
traiter de nouvelles requtes (elle sont mises en attente
par le systme d'exploitation et donc ne sont pas perdues)
tout en respectant vos rglages. Pour cela, Apache doit
maintenir la <em>table de comunication interprocessus</em> pour
les diffrents processus fils et leur
gnration.</p>

<p>Le module <a href="mod/mod_status.html">status</a> utilise
galement un <code>G</code> pour marquer les fils traitant
les requtes dmarres avant le
redmarrage en douceur.</p>

<p>Actuellement, il n'y a aucun moyen pour un script de rotation
des fichiers de trace qui utiliserait le signal <code>USR1</code>
de savoir de manire absolue que tous les processus fils
crivant dans l'ancien fichier de trace sont
termins. Nous suggrons d'utiliser un dlai
d'attente raisonnable aprs l'envoi du signal avant de
faire quoi que ce soit avec l'ancien fichier de trace. Si par
exemple la majorit de vos accs sont
traits en moins de dix minutes pour des utilisateurs
utilisant des liaisons  bas dbit, alors vous
devrez attendre quinze minutes avant de faire quelque chose avec
l'ancien fichier de trace.</p>

<p><strong>Note:</strong> Si votre fichier de configuration
contient des erreurs au moment de rinitialiser le
processus pre, ce dernier ne redmarrera pas et se
terminera avec une erreur. Dans le cas d'un redmarrage en
douceur, le processus pre laisse les fils continuer quand
il se termine. Ce sont les processus fils qui sont
"termins en douceur" en traitant leurs requtes en
cours. Ceci peut poser des problmes si vous essayez de
redmarrer le serveur -- il ne sera pas capable de se
connecter sur son port d'coute. Afin d'effectuer un
redmarrage, vous pouvez vrifier la syntaxe du
fichier de configuration en utilisant le paramtre
<code>-t</code> (cf. <a href="programs/httpd.html">httpd</a>).
Ceci n'est pas suffisant pour garantir que le serveur
redmarrera correctement. Afin de vrifier la
smantique des fichiers de configuration ainsi que leur
syntaxe, vous pouvez essayer de lancer <code>httpd</code> sous un
compte utilisateur autre que root. S'il n'y a pas d'erreur, il
essaiera d'ouvrir ses ports rseau, mais chouera,
soit parce qu'il n'est pas root, soit parce que le serveur existant
est dj connect sur ces ports. S'il
choue pour une autre raison, c'est qu'il existe une
erreur dans les fichiers de configuration et cette erreur doit
tre corrigavant de dclencher une relance
en douceur.</p>

<h3>Annexe : signaux et conditions temporelles</h3>

<p>Avant la version 1.2b9 d'Apache il existait un certain nombre
de <em>conditions temporelles</em> concernant les signaux de
redmarrage et d'arrt. Une description simple d'une
condition temporelle est un problme li 
l'ordre des traitements dans le temps, comme quand quelque chose
arrive au mauvais moment et ne se comporte pas comme
prvu). Pour les architectures possdant les
"bonnes" fonctionnalits, nous les avons
limines autant que possible. Mais il doit
tre not qu'il existe toujours des problmes
sur certaines architectures.</p>

<p>Les architectures utilisant un fichier sur disque <a href=
"mod/core.html#scoreboardfile">ScoreBoardFile</a> pour la
communication interprocessus peuvent ventuellement
corrompre ce fichier. Il en rsulte le message d'erreur
"bind: Address already in use" (aprs le signal
<code>HUP</code>) ou "long lost child came home!" (aprs
le signal <code>USR1</code>). Le premier est une erreur fatale,
tandis que le deuxime a juste pour effet de perdre une
entre dans la table de communication interprocessus. Il
est donc envisageable d'utiliser le redmarrage en
douceur, avec d'occasionnels redmarrages immdiats.
Ces problmes sont trs difficiles 
viter, mais heureusement de nombreuses architectures n'ont
pas besoin d'utiliser un fichier pour la communication interprocessus.
Consulter la documentation sur <a href=
"mod/core.html#scoreboardfile">ScoreBoardFile</a> pour savoir si
votre architecture l'utilise.</p>

<p><code>NEXT</code> et <code>MACHTEN</code> (68k seulement)
prsentent quelques conditions temporelles qui peuvent
provoquer la perte d'un signal d'arrt ou de
redmarrage, mais ne devraient pas crer de
problmes majeurs.</p>

<p>Sur toutes les architectures, les processus fils
prsentent des conditions temporelles dans le cas du
traitement de la deuxime requte, et des suivantes,
pour des connexions HTTP persistantes (KeepAlive). Le processus
peut se terminer aprs avoir lu la requte mais
avant d'avoir lu l'en-tte. Il existe un correctif, mais
celui ci a t ralis trop tard pour
tre intgr dans la version 1.2. En
thorie, ceci ne doit pas tre un problme
car le client utilisant la persistance des connexions doit
tre capable de traiter ce genre de cas, qui peut se
produire soit  cause des temps de latence du rseau,
soit  cause des dlais de rponse trop longs des
serveurs. En pratique, cela ne semble pas non plus affecter le
systme. Dans un test, le serveur tait
redmarr vingt fois par seconde et les clients ont
pu consulter le site sans obtenir de documents vides ou
d'images invalides. 
</p>
<!--#include virtual="footer.html" -->
</body>
</html>
