#ifdef __BEOS__

#include <kernel/image.h>
#include <Path.h>

// The BeOS port of libltdl uses load_add_on to do runtime loading
// of shared libraries. it's effective, but requires all paths to
// be relative to ADDON_PATH. This is a simple enough workaround
// to resolve to a fully-qualified path relative to the current
// directory, and if that doesn't work, regress to the previous
// method

extern "C"
{
image_id sys_bedl_loadimage(const char *filename);
}

image_id sys_bedl_loadimage(const char *filename)
{
	image_id image=0;

	// first get the path of the current application
	image_info info;
    int32 cookie = 0;
    if (get_next_image_info (0, &cookie, &info) == B_OK)
    {
    	BPath bq(info.name);
    	bq.GetParent(&bq);
    	if(B_OK==bq.Append(filename,true))
    	{
    		image=load_add_on(bq.Path());
    	}
    }

	// now try relative to the current directory    
    if(image<=0)
    {	
		BPath bp(filename,NULL,true);
		if(B_OK==bp.InitCheck())
		{
			image=load_add_on(bp.Path());
		}
	}
	
	// finally try the default ADDON_PATH behavior
	if(image<=0)
	{
		image = load_add_on (filename);
	}
	return image;
}
#endif
