/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1998 Hubert Figuiere

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _PDFVIEW_H_
#define _PDFVIEW_H_

#include <interface/Bitmap.h>
#include <interface/View.h>

#include <GString.h>
#include "Page.h"
#include "XRef.h"
#include "Catalog.h"

#include "PDFDoc.h"
#include "BeOutputDev.h"


#define MIN_ZOOM	-5
#define MAX_ZOOM	5


class PDFView
	: public BView
{
public:
	PDFView (entry_ref * ref, BRect frame,
								const char *name,
								uint32 resizeMask,
								uint32 flags);
virtual ~PDFView();

virtual	void Draw (BRect updateRect);
virtual void FrameResized (float width, float height);
virtual void AttachedToWindow ();
virtual void KeyDown (const char * bytes, int32 numBytes);

	bool IsOk();

	void SetPage ( int page );
	int Page()
		{ return mCurrentPage; } ;
	void SetZoom ( int zoom );
	void SetRotation ( float rot );
	void Redraw();

	void FixScrollbars ();

	void EncodingKludge (uint8 encoding);
	int GetNumPages()
		{ return mDoc->getNumPages(); };
	int GetPageWidth(int page)
		{ return mDoc->getPageWidth (page); };
	int GetPageHeight(int page)
		{ return mDoc->getPageHeight (page); };

	status_t PageSetup();
	void Print();

private:
	PDFDoc * mDoc;
	bool mOk;
	int mZoom;
	BBitmap * mBitmap;
	BView * mOffscreenView;
	BeOutputDev * mOutputDev;
	int mCurrentPage;
	float mRotation;
	GString * mTitle;
	float mWidth, mHeight;		//document width and height

	BMessage * mPrintSettings;

	void RecreateBitmap ();	
};


//////////////////////////////////////////////////////////////////
inline bool PDFView::IsOk()
{
	return mOk;
}


//////////////////////////////////////////////////////////////////
inline void PDFView::SetRotation ( float rot )
{
	mRotation = rot;
	Redraw();
}


//////////////////////////////////////////////////////////////////
inline void PDFView::EncodingKludge (uint8 encoding)
{
	mOutputDev->ForceEncodingKludge (encoding);
}


//////////////////////////////////////////////////////////////////

#endif
