/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1998 Hubert Figuiere

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
//
// BepdfApplication.cpp
//
// (c)1998 Hubert Figuiere
//
// 


#include <stdlib.h>

#include <app/Application.h>
#include <storage/FilePanel.h>

#include <gtypes.h>
#include <parseargs.h>

#include "config.h"
#include "Params.h"
#include "Error.h"

#include "PDFWindow.h"
#include "BepdfApplication.h"

static const char * cvsid = "$Id: BepdfApplication.cpp,v 1.3 1999/02/03 21:48:29 hub Exp $";


static const char * bePDFVersion = "0.5.2";
static const char * bePDFCopyright = "BeOS code (c) 1999 Hubert Figuiere\n"
    "\n"
    "This program is free software; you can redistribute it and/or modify\n"
    "it under the terms of the GNU General Public License as published by\n"
    "the Free Software Foundation; either version 2 of the License, or\n"
    "(at your option) any later version.\n"
	"\n"
    "This program is distributed in the hope that it will be useful,\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "GNU General Public License for more details.\n"
	"\n"
    "You should have received a copy of the GNU General Public License\n"
    "along with this program; if not, write to the Free Software\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.";
    
static const char * PAGE_NUM_MSG = "bepdf:page_num";

GBool printCommands = gFalse;
static GBool printHelp = gFalse;

static ArgDesc argDesc[] = {
	{"-z", argIntDummy, NULL, 0,
	 "initial zoom level (-5..5)"},
	{"-ps", argStringDummy, NULL, 0,
	 "default PostScript file/command name"},
	{"-cmd", argFlag, &printCommands, 0,
	 "print commands as they're executed"},
	{"-h", argFlag, &printHelp, 0,
	 "print usage information"},
	{NULL}
};


///////////////////////////////////////////////////////////
int main()
{
	new BepdfApplication ( );
	
	be_app->Run();
	
	delete be_app;
	
	return 0;
}



///////////////////////////////////////////////////////////
BepdfApplication::BepdfApplication()
		: BApplication ( "application/x-vnd.hub-xpdf" )
{
	mOpenFilePanel = NULL;
	mGotSomething = false;
	
	errorInit ();
	initParams (xpdfConfigFile);
}


///////////////////////////////////////////////////////////
BepdfApplication::~BepdfApplication()
{
	freeParams();

	// check for memory leaks
	Object::memCheck(errFile);
	gMemReport(errFile);

	// print coverage info
	//coverDump(errFile);
}


///////////////////////////////////////////////////////////
void BepdfApplication::ReadyToRun()
{
	if (! mGotSomething) {
		OpenFilePanel();
	}
}



/*
	open a file panel and ask for a PDF file 
	the file panel will tell by itself if openning have been cancelled 
	or not.
*/
void BepdfApplication::OpenFilePanel ()
{
	if (mOpenFilePanel == NULL) {
		mOpenFilePanel = new BFilePanel (B_OPEN_PANEL,
						NULL, NULL, B_FILE_NODE, true, NULL, NULL);
	}
	
	mOpenFilePanel->Show();
}


		

///////////////////////////////////////////////////////////
/*
	Opens everything.
*/
void BepdfApplication::RefsReceived ( BMessage * msg )
{
	uint32 type;
	int32 count;
	int32 i;
	entry_ref ref;
	
	msg->GetInfo ( "refs", &type, &count );
	if ( type != B_REF_TYPE ) {
		return;
	}
	for ( i = --count ; i >= 0; i-- ) {
		if ( msg->FindRef("refs", i, &ref ) == B_OK ) {
			/*
				Open the document...
			*/
		 	PDFWindow * win = new PDFWindow(&ref, BRect(100,100,200,250));
		 	if (! win->IsOk()) {
#ifdef DEBUG
		 		fprintf (stderr, "Window not created");
#endif
		 		delete win;
		 	}
		 	else {
		 		win->Show();
		 		mGotSomething = true;
		 	}
		} 
	}
}



///////////////////////////////////////////////////////////
void
BepdfApplication::MessageReceived (BMessage * msg)
{
	if (msg == NULL) {
		fprintf (stderr, "xpdf: message NULL received\n");
		return;
	}
	switch (msg->what) {
	case B_CANCEL:
		if (PDFWindow::GetWindowCount() == 0) {
			PostMessage (B_QUIT_REQUESTED);
		}
		break;
	}
}





///////////////////////////////////////////////////////////
void
BepdfApplication::ArgvReceived (int32 argc, char **argv)
{
	GString * name;
	GBool ok;
	int pg;
	BMessage * msg;
	entry_ref fileToOpen;
	
	ok = parseArgs (argDesc, (int *)&argc, argv);
	
	// check command line
	if (!(argc == 2 || argc == 3) || printHelp) {
		printUsage(argv[0], "[<PDF-file> [<page>]]", argDesc);
		exit(1);
	}
	if (argc >= 2) {
		name = new GString(argv[1]);
	}
	else {
		name = NULL;
	}
	if (argc == 3) {
		pg = atoi(argv[2]);
	}
	else {
		pg = 1;
	}

	// print banner
	fprintf(errFile, "BePDF version %s\n", bePDFVersion);
	fprintf(errFile, "based on xpdf %s\n", xpdfCopyright);
	fprintf(errFile, "%s\n", bePDFCopyright);

	msg = new BMessage (B_REFS_RECEIVED);
	msg->AddInt32 (PAGE_NUM_MSG, pg);
	get_ref_for_path (name->getCString(), &fileToOpen);
	msg->AddRef ("refs", &fileToOpen);
	PostMessage (msg);
	delete msg;
	mGotSomething = true;
}


///////////////////////////////////////////////////////////
