%define name    glaxium
%define version 0.5
%define release mdk90

Summary: OpenGL-based space-ship "shoot-em-up"
Name: %{name}
Version: %{version}
Release: %{release}
Source: %{name}_%{version}.tar.bz2
URL: http://xhosxe.free.fr/glaxium
License: GPL
Group: Games/Arcade
BuildRoot: %{_tmppath}/%{name}-buildroot

%description
Glaxium is an OpenGL-based space-ship "shoot-em-up" styled game. 
It is designed to provide the same feel as the old 2D   games of that 
type, but with 3D for the special effects. 

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}_%{version}

%build
# (gc) workaround g++ exception bug when -fomit-frame-pointer is set
export CFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer" CXXFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer"
%configure
make

%install
export GLAXIUM_INSTALLDIR=$RPM_BUILD_ROOT%_bindir
export GLAXIUM_HOME=$RPM_BUILD_ROOT%{_datadir}/games/glaxium

mkdir -p $RPM_BUILD_ROOT%_bindir
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man6
mkdir -p $RPM_BUILD_ROOT%{_datadir}/games/glaxium/{textures,samples}

install -m 755 glaxium $RPM_BUILD_ROOT%{_bindir}/%{name}
chmod a+x $RPM_BUILD_ROOT/%{_bindir}/%{name}
install -m 644 glaxium.6 $RPM_BUILD_ROOT%{_mandir}/man6/
install -m 644 textures/* $RPM_BUILD_ROOT%{_datadir}/games/glaxium/textures/
install -m 644 samples/* $RPM_BUILD_ROOT%{_datadir}/games/glaxium/samples/

 
%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc LICENSE README.txt CHANGES.txt
%{_bindir}/%{name}
%{_datadir}/games/*
%{_mandir}/man6/*

%changelog
* Wed Oct 09 2002 Xavier Hosxe <xhosxe@free.fr> 0.5-*
- Heavily inspired by glaxium.spec from mandrakesoft (Lenny Cartier and Guillaume Cottenceau).
