/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __FIRE__
#define __FIRE__

#include "sprite.hpp"
#include "myship.hpp"


/* === Class Myfire : when 'x' is pressed */

class MyFire1 : public Sprite {
public:
    MyFire1(MyShip *myShip);
    MyFire1(MyShip *myShip, float dx, float dz=1.2);
    void draw();
    void drawShadowable();
    void collision(Sprite*contact);
    void move();
    void score(int score); 
       
    
protected:
    int power;
    enum_state state_;
    MyShip* myship_;
};

/* === Class Myfire : when 'w' is pressed */


class MyFire2 : public Sprite {
public:
    MyFire2(MyShip *myShip);
    void draw();
    void drawShadowable();
    void collision(Sprite*contact);
    void move();
    void score(int score); 
    
protected:
    float rotate_;
    int power;
    enum_state state_;
    MyShip* myship_;
};

/* === Class Myfire3 : when 'x' is pressed and powerUP just get*/

class MyFire3 : public Sprite {
public:
    MyFire3(MyShip *myShip, float offetX);
    void draw();
    void drawShadowable();
    void collision(Sprite*contact);
    void move();    
    void receiveEvent(Sprite*sprite);
    void iJustDied();
    static void initList();
    void score(int score); 
    
protected:
    float maxz_, maxx_;
    int power;
    enum_state state_;
    Sprite* toShot_;
    static int m_nCubeList;
    MyShip* myship_;
};


class MyFire4 : public Sprite {
public:
    MyFire4(MyShip *myShip, float dx, float dz);
    void draw();
    void drawShadowable();
    void collision(Sprite*contact);
    void move();
    void score(int score);       
    
protected:
    int power;
    enum_state state_;
    MyShip* myship_;
};

class MyFire4Smoke : public Sprite {
public:
    MyFire4Smoke(MyFire4 *fire4);
    ~MyFire4Smoke();
    void draw();
    void drawShadowable();
	void move();
    void collision(Sprite*contact);
    void receiveEvent(Sprite*sprite);
	void iJustDied();
    
protected:
    int state_;
	float *xPoint_;
	float *zPoint_;
	float *dxPoint_;
	float fBegin_;
	int nBegin_;
	int nEnd_;
	int nLastPoint_;
    MyFire4* fire4_;
};

#endif 
