/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __MYSHIP__
#define __MYSHIP__


#include "sprite.hpp"
#include "list.hpp"


class MyShip : public Sprite {
public:
    MyShip(List *list, int shieldMax) ;
    void draw();
    void drawShadowable();
    void collision(Sprite *contact);
    void move();
    void explode();
    
    int getShield() { return shield_;}
    void setShield(int toSet) { shield_ = toSet;}
    int getShieldMax() { return shieldMax_;}
    int getScore() { return score_; }
    int getBomb() { return bomb_ ; }
    void score(int toAdd); 
    static void initList();
    static int list_;
    enum enum_state {
        NOT_STARTED=1,
            NORMAL,
            UNTOUCHABLE,
            ROTATING,
            DEAD
    } ;
    int powerUp_;
    
protected:
    int shield_;
    int shieldMax_;
    enum_state state_;
    float ddx_,ddz_;
    int score_;
    float rotate_;
    int bomb_  ;
    int cptFire_;
	float delay_;
	float *fThX, *fThY, *fThS;
	long invulBegin;
	long invulEnd;
};


#endif
