/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <math.h>
#include <GL/glut.h>



#include "piege.hpp"
#include "myship.hpp"


Piege::Piege(List *list, int speed, float x)
: Sprite(list,TYPE_PIEGE ,((float)(random()%1024)/1024)*20-10,3,70)
{
    Sprite* poto;
    state_=NORMAL;
    dz_ = -.1;
    sizex_ = 2;
    sizey_ = 1;
    sizez_ = 2;
    spotX_=0;
    spotY_=0;
    spotZ_=0;
    tetay_=0;
    tuching_=0;
	period_=0;
    toFollow_=NULL;
    lightelse_=0;
    ringing_=0;
    poto = new Poto(this);
    list->Add(poto);
}

void Piege::drawShadowable()
{
    glPushMatrix();
    double t1;
    
    t1= atan(spotZ_/spotX_)/6.2831852*360;
    if (spotX_ < 0)
    {
        t1 = 180-t1;
    }
    if (spotZ_ < 0)
    {
        t1 = -t1;
    }
       
    glTranslatef(x_,y_,z_);  
    
    glRotatef(t1,0,1,0);
    
	glDisable(GL_CULL_FACE);
    glBegin(GL_QUADS);
// Do not have time to do it properly so :    


    glTexCoord2f(.3, .3);
    glVertex3f(.15,.15,.15);
    glTexCoord2f(.3, .7);
    glVertex3f(.15,.15,-.15);
    glTexCoord2f(.7,.7);
    glVertex3f(-.15,.15,-.15);
    glTexCoord2f(.7,.3);
    glVertex3f(-.15,.15,.15);
    
   
    glTexCoord2f(.3, .3);
    glVertex3f(.15,-.15,.15);
    glTexCoord2f(.3, .7);
    glVertex3f(.15,-.15,-.15);
    glTexCoord2f(.7,.7);
    glVertex3f(-.15,-.15,-.15);
    glTexCoord2f(.7,.3);
    glVertex3f(-.15,-.15,.15);
    
    glTexCoord2f(0, 0);
    glVertex3f(.15,.15,.15);
    glTexCoord2f(0, 1);
    glVertex3f(.15,-.15,.15);
    glTexCoord2f(1,1);
    glVertex3f(-.15,-.15,.15);
    glTexCoord2f(1,0);
    glVertex3f(-.15,.15,.15);
    
    glTexCoord2f(0, 0);
    glVertex3f(.15,.15,-.15);
    glTexCoord2f(0, 1);
    glVertex3f(.15,-.15,-.15);
    glTexCoord2f(1,1);
    glVertex3f(-.15,-.15,-.15);
    glTexCoord2f(1,0);
    glVertex3f(-.15,.15,-.15);
    
    glTexCoord2f(0, 0);
    glVertex3f(.15,.15,.15);
    glTexCoord2f(1, 0);
    glVertex3f(.15,.15,-.15);
    glTexCoord2f(1,1);
    glVertex3f(.15,-.15,-.15);
    glTexCoord2f(0,1);
    glVertex3f(.15,-.15,.15);
    
    glTexCoord2f(0, 0);
    glVertex3f(-.15,.15,.15);
    glTexCoord2f(1, 0);
    glVertex3f(-.15,.15,-.15);
    glTexCoord2f(1,1);
    glVertex3f(-.15,-.15,-.15);
    glTexCoord2f(0,1);
    glVertex3f(-.15,-.15,.15);

    
    glEnd();
	glEnable(GL_CULL_FACE);
    glPopMatrix();
    
}

void Piege::draw()
{
    float light=0;
    glPushMatrix();
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA , GL_ONE);
    
    glDepthMask(0);
    
    glBegin(GL_QUADS);
    if (tuching_)
        glColor4f(1,light,0,.2);
    else
        glColor4f(1,1,0,.2);
    
    glVertex3f(-1.0+spotX_+x_,0.02,-1.0+spotZ_+z_);
    glVertex3f( 1.0+spotX_+x_,0.02,-1.0+spotZ_+z_);
    glVertex3f( 1.0+spotX_+x_,0.02, 1.0+spotZ_+z_);
    glVertex3f(-1.0+spotX_+x_,0.02, 1.0+spotZ_+z_);
    
    glEnd();
    
    glBegin(GL_TRIANGLE_FAN);  
    if (tuching_)
        glColor4f(1,(light=(lightelse_>16)?(lightelse_-16)/16:-(lightelse_-16)/16),0,0);
    else
        glColor4f(1,1,0,0.0);
    
    glVertex3f(x_,y_-.10,z_);
    
    if (tuching_)
        glColor4f(1,light,0,.3);
    else
        glColor4f(1,1,0,.1);
    
    glVertex3f( 1.0+spotX_+x_,0.02, 1.0+spotZ_+z_);
    glVertex3f( 1.0+spotX_+x_,0.02,-1.0+spotZ_+z_);
    glVertex3f(-1.0+spotX_+x_,0.02,-1.0+spotZ_+z_);
    glVertex3f(-1.0+spotX_+x_,0.02, 1.0+spotZ_+z_); 
    glVertex3f( 1.0+spotX_+x_,0.02, 1.0+spotZ_+z_);
    glEnd();
    
    
    glDepthMask(1);
    
    glDisable(GL_BLEND);
    
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,GLvar->texture_piege);


    if (tuching_)
        glColor4f(1,light,light,1);
    else
        glColor4f(1,1,1,1);
      
    glPopMatrix();
    drawShadowable();
    glDisable(GL_TEXTURE_2D);
}



void Piege::move()
{
    if (GLvar->mySpaceShip==NULL && state_==TOUCHING)
    {
        state_=NORMAL;
        toFollow_=NULL;
        tuching_=0;
    }
    
    Sprite::move();
    
    tetay_+= GLvar->global_timeadjustment;
    
    if (tetay_>360)
        tetay_ = tetay_-360;
    
    if (z_<-3) {
        dead_=1;
        return;
    }
    
    
    if (ringing_)
        if ((glutGet((GLenum)(GLUT_ELAPSED_TIME))-elapsedTime_)> 2000) {
            ringing_=0;
        }
        
        
        
        
        
        switch(state_)
        {
        case NORMAL:
            if (GLvar->myRandom(30))
            {
                spotdX_ = (float)(random()%2 -1)/8;
                spotdZ_ = (float)(random()%2 -1)/8;
                
                if ((spotdX_!=0) || (spotdZ_!=0))
                {
                    state_=MOVING;
                }
            }
            break;
        case MOVING:
            //    printf("%d = spotdZ = %f\n",cpt_,spotdZ_);
            
            spotX_+=spotdX_*GLvar->global_timeadjustment;
            spotZ_+=spotdZ_*GLvar->global_timeadjustment;
            
            if (spotX_<-3)
            {
                spotdX_=-spotdX_;
            }
            if (spotX_>3)
            {
                spotdX_=-spotdX_;
            }
            if (spotZ_<-3)
            {
                spotdZ_=-spotdZ_;
            }
            if (spotZ_>+3)
            {
                spotdZ_=-spotdZ_;
            }
            if (GLvar->myRandom(40))
            {
                state_=NORMAL;
            }
            break;
        case TOUCHING:
            lightelse_+=GLvar->global_timeadjustment*2;
            if (lightelse_>32.0)
            {
                lightelse_=lightelse_-32.0;
            }
            tuching_+= GLvar->global_timeadjustment;
            
            spotX_=toFollow_->getX()-x_;
            spotZ_=toFollow_->getZ()-z_;
            
            if (spotX_<-3)
            {
                spotX_=-3;
            }
            if (spotX_>3)
            {   
                spotX_=3;
            }
            if (spotZ_<-3)
            {
                spotZ_=-3;
            }
            if (spotZ_>+3)
            {
                spotZ_=3;
            }

			if (period_>2)
			{
                Spirale *newOne = new Spirale(mlist,
                    2,
                    (random()%140)/10.0f-7.0f,
                    toFollow_);
                mlist->Add(newOne);
	            period_-=2;
			}
			else
			{
				period_+=GLvar->global_timeadjustment;
			}

            
            spotX_+=spotdX_*GLvar->global_timeadjustment;
            spotZ_+=spotdZ_*GLvar->global_timeadjustment;
            
            if (tuching_>20)
            {
                state_=NORMAL;
                tuching_=0;
            }
            break;
        }
        
}


void Piege::collision(Sprite*contact)
{
    switch(contact->getType())
    {
    case TYPE_MY_SPACE_SHIP:
		period_=0;
        state_=TOUCHING;
        tuching_=1;
        toFollow_=contact;
        if (!ringing_) {
            SpritePlaySample(SAMPLE_DETECTION);
            elapsedTime_=glutGet((GLenum)(GLUT_ELAPSED_TIME));
            ringing_=1;
        }
        break;
    }
}


// ==================== POTO ==================


Poto::Poto(Sprite*lamp)
: Sprite(lamp->getList(),TYPE_POTO ,lamp->getX(),1.5, lamp->getZ())
{
    dx_=0;
    dy_=0;
    dz_ = -.1;
    sizex_ = .05;
    sizey_ = 3;
    sizez_ = .05;
}

void Poto::drawShadowable()
{
    glPushMatrix();
    glTranslatef(x_,y_,z_);
    glBegin(GL_TRIANGLE_STRIP);
    
    glVertex3f(.025, -1.5, .025);
    glVertex3f(.025, +1.35, .025);
    
    glVertex3f(-.025, -1.5, .025);
    glVertex3f(-.025, +1.35, .025);
    
    glVertex3f(-.025, -1.5, -.025);
    glVertex3f(-.025, +1.35, -.025);
    
    glVertex3f(.025, -1.5, -.025);
    glVertex3f(.025, +1.35, -.025);
    
    glVertex3f(.025, -1.5, .025);
    glVertex3f(.025, +1.35, .025);
    
    glEnd();
    glPopMatrix();
}
void Poto::draw()
{
    //  printf("0x%x : dx=%f, dy=%f, dz=%f\n",this,dx_,dy_,dz_);
    //printf("0x%x : x=%f, y=%f, z=%f\n\n",this,x_,y_,z_);
    
    
    //  glColor4f(1,1,1,1);
    
  
    glDisable(GL_TEXTURE_2D);
	glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->bleu_diffuse);  
	drawShadowable();    
	glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->blanc_diffuse);  
    glEnable(GL_TEXTURE_2D);
}



void Poto::move()
{
    Sprite::move();
    
    if (z_<-3)
    {
        dead_=1;
    }
}


void Poto::collision(Sprite*contact)
{
}
