/*
  Copyright (C) 2000/2002 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
    
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <string.h>

#include "SDL.h"

#include "scene.hpp"
#include "variables.hpp"
#include "listsprite.hpp"

#include "myship.hpp"
#include "cube.hpp"
#include "diamond.hpp"
#include "ship1.hpp"
#include "bandit2.hpp"
#include "fighter2.hpp"
#include "spirale.hpp"
#include "piege.hpp"
#include "tank.hpp"
#include "tache.hpp"


#ifdef WIN32
#else
// #define GLX_GLXEXT_LEGACY
#define GLX_GLXEXT_PROTOTYPES 1
#include <GL/glx.h>
// #include <GL/glxext.h>
#endif



// To know if a key has just be pressed
extern bool bKeyDown;    


PFNGLCOMBINERPARAMETERINVPROC glCombinerParameteriNV;
PFNGLCOMBINERINPUTNVPROC glCombinerInputNV;
PFNGLCOMBINEROUTPUTNVPROC glCombinerOutputNV;
PFNGLFINALCOMBINERINPUTNVPROC glFinalCombinerInputNV;
PFNGLCOMBINERPARAMETERFVNVPROC glCombinerParameterfvNV;


PFNGLBINDPROGRAMNVPROC glBindProgramNV;
PFNGLLOADPROGRAMNVPROC glLoadProgramNV;
PFNGLTRACKMATRIXNVPROC glTrackMatrixNV;
PFNGLPROGRAMPARAMETER4FNVPROC glProgramParameter4fNV;

#ifdef WIN32
PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB; 
#endif

GLenum glError;



/*
GLfloat light_pos[] = { 10,  20, 10, 0 };


GLfloat shadowMatrix[] = {  light_pos[1],0,0,0, -light_pos[0],0,
-light_pos[2],-1,0,0,light_pos[1],0,0,
0,0,light_pos[1]};
*/
float camX, camY, camZ;


void drawText(float x, float y, float z,char *text, float size, float r, float g, float b) {
	int strLenth = strlen(text);
	char letter;
	glPushMatrix();
	glBindTexture(GL_TEXTURE_2D,GLvar->texture_letters);

	glTranslatef(x,y,z);
	for (int i=0; i<strLenth; i++) {
		letter = text[i];

		if (letter==32) {
			glTranslatef(size/700,0,0) ;
		} else 
		if (letter>=65 && letter<=90) {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*(letter-65), .0625);
				glVertex3f(0,0,0);
				glTexCoord2f(.03125*(letter-64),  .0625);
				glVertex3f(size/700,0,0);
				glColor4f(1,1,1,1);
				glTexCoord2f(.03125*(letter-64), 0);
				glVertex3f(size/700,size/300,0);
				glTexCoord2f(.03125*(letter-65), 0);
				glVertex3f(0,size/300,0);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		} else 
		if (letter>=97 && letter<=122) {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*(letter-97), .125);
				glVertex3f(0,0,0);
				glTexCoord2f(.03125*(letter-96),  .125);
				glVertex3f(size/700,0,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*(letter-96), 0.0625);
				
				glVertex3f(size/700,size/300,0);
				glTexCoord2f(.03125*(letter-97), 0.0625);
				glVertex3f(0,size/300,0);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		} else 
		if (letter>=48 && letter<=57) {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*(letter-48), .1875);
				glVertex3f(0,0,0);
				glTexCoord2f(.03125*(letter-47),  .1875);
				glVertex3f(size/700,0,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*(letter-47), 0.125);
				
				glVertex3f(size/700,size/300,0);
				glTexCoord2f(.03125*(letter-48), 0.125);
				glVertex3f(0,size/300,0);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		} else
		if (letter==':') {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*13, .1875);
				glVertex2f(0,0);
				glTexCoord2f(.03125*12,  .1875);
				glVertex2f(size/700,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*12, 0.125);
				
				glVertex2f(size/700,size/300);
				glTexCoord2f(.03125*13, 0.125);
				glVertex2f(0,size/300);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		}else
		if (letter=='!') {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*14, .1875);
				glVertex2f(0,0);
				glTexCoord2f(.03125*13,  .1875);
				glVertex2f(size/700,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*13, 0.125);
				
				glVertex2f(size/700,size/300);
				glTexCoord2f(.03125*14, 0.125);
				glVertex2f(0,size/300);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		}else
		if (letter=='.') {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*16, .1875);
				glVertex2f(0,0);
				glTexCoord2f(.03125*15,  .1875);
				glVertex2f(size/700,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*15, 0.125);
				
				glVertex2f(size/700,size/300);
				glTexCoord2f(.03125*16, 0.125);
				glVertex2f(0,size/300);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		}else
		if (letter=='/') {
			glBegin(GL_QUADS) ;
			{
				glColor4f(r,g,b,1);
				glTexCoord2f(.03125*17, .1875);
				glVertex2f(0,0);
				glTexCoord2f(.03125*16,  .1875);
				glVertex2f(size/700,0);
				glColor4f(.9,.9,1,1);
				glTexCoord2f(.03125*16, 0.125);
				
				glVertex2f(size/700,size/300);
				glTexCoord2f(.03125*17, 0.125);
				glVertex2f(0,size/300);
			}
			glEnd();
			glTranslatef(size/700,0,0) ;
		} else {
			printf("letter To add '%c' : %d\n", letter, (int)letter);
		}

	}
	glPopMatrix();
}

void drawText(float x, float y, float z,char *text, float size) {
	drawText( x,  y, z, text,  size, .3,.3,1) ;
}

/*
* getScene()
*
* get the singleton
*/


Scene*  Scene::getScene() {
	if (scene==NULL) {
		scene = new Scene();
	}
	return scene;
}

Scene::Scene() {
	initVariables();
}


void Scene::initVariables() {
	int i,j,k;    
	nStars = STARS;
	for (i=0;i<nStars;i++)
	{
		stars[i][3] = (float)(random()%1400)/10.0-70;
		stars[i][4] = (float)(random()%600)/4.0-100;
		stars[i][5] = 90.0;
		stars[i][0] =   stars[i][1] = stars[i][2] = (float)(random()%750)/1000.0 +.25;      
	}   
	globalScore=-1;
	lasttime = glutGet((GLenum)GLUT_ELAPSED_TIME);  
	displayFPS=0;
	globalList = new ListSprite();
	floorOffset =0;
	floorScrollOffset =0;
	
	aFloor = new int[6*16];
	aFloorMap = new int[6*16];
	for (i=0; i<6*15;i++) {
		aFloor[i]=random()%5;
		aFloorMap[i]=random()%5;
	}
	
	
}

/*
* static void drawSky
*
* Draw the Pictures & the stars
*/

void Scene::drawSky()
{
	
	glDisable(GL_FOG);
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);

	int tmpStars = nStars / (3-GLvar->details);
	int st = random()%tmpStars;
	stars[st][0] =  stars[st][1] = stars[st][2] = (float)(random()%750)/1000.0 +.25;
	glInterleavedArrays(GL_C3F_V3F,0,stars);
	glDrawArrays(GL_POINTS, 0, tmpStars);
	
	if (GLvar->details!=0) {
		//    glMaterialfv(GL_FRONT,GL_DIFFUSE,blanc_diffuse);
		glColor4fv(GLvar->blanc_diffuse);
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		
		for (int i=0; i<SPACE; i++) {
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_space[i]);
			glBegin(GL_QUADS);
			glTexCoord2f(0,0);
			glVertex3f(GLvar->pos_space[0+i*5],GLvar->pos_space[1+i*5],GLvar->pos_space[4+i*5]);
			glTexCoord2f(0,1);
			glVertex3f(GLvar->pos_space[0+i*5],GLvar->pos_space[3+i*5],GLvar->pos_space[4+i*5]);
			glTexCoord2f(1,1);
			glVertex3f(GLvar->pos_space[2+i*5],GLvar->pos_space[3+i*5],GLvar->pos_space[4+i*5]);
			glTexCoord2f(1,0);
			glVertex3f(GLvar->pos_space[2+i*5],GLvar->pos_space[1+i*5],GLvar->pos_space[4+i*5]);
			glEnd();
		}
	}
	
	glEnable(GL_FOG);
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
}

/*
* static void drawFloor
*
* Draw and scroll the floor
*/


float* getDirection(float x, float y, float z) {
  static float *fReturn = NULL;

  if (fReturn==NULL) fReturn = new float[3];

  float py = 2;
  float px, pz;
  if ( GLvar->mySpaceShip!=NULL) {
	   px =  GLvar->mySpaceShip->getX();
	   pz =  GLvar->mySpaceShip->getZ();
  } else {
	  px = 0;
	  pz = 23;
  }

  fReturn[0] = x-px;
  fReturn[2] = py-y;
  fReturn[1] = pz-z;

  float size = sqrt(fReturn[0]*fReturn[0] +fReturn[1]*fReturn[1] +fReturn[2]*fReturn[2]) ;
  //  printf("Size = %f\n", size);

  fReturn[0] /= size;
  fReturn[1] /= size;
  fReturn[2] /= size;
  //  printf("%f, %f, %f ====> %f, %f, %f\n",x,y,z, fReturn[0],fReturn[1],fReturn[2]);

  fReturn[0] /= 2;
  fReturn[1] /= 2;
  fReturn[2] /= 2;
  fReturn[0] +=.5;
  fReturn[1] +=.5;
  fReturn[2] +=.5;


  return fReturn;
}


void Scene::drawSolidFloor() {
	
}

void Scene::drawFloor()
{
  static float dot3LightX = 0;
	static float cpt=0;
	static float halfMul[] = {.5, .5 , .5,0};
	static float halfAdd[] = {.5,.5,.5,0};
	int texture ;
	int textureMap;
	int i;

	glLightfv(GL_LIGHT0, GL_SPECULAR,  GLvar->nothing);
		
	floorScrollOffset +=.1* GLvar->global_timeadjustment;
	if (floorScrollOffset>=5) {
		int lineToChange = floorOffset;
		floorScrollOffset=(floorScrollOffset-5);
		floorOffset = (floorOffset+1)%15;
		for (i=0; i<6;i++) {
			aFloor[lineToChange*6+i]=random()%5;
			aFloorMap[lineToChange*6+i]=(random()%5);
		}
	}
		
	
	glMaterialfv(GL_FRONT,GL_DIFFUSE,GLvar->blanc_diffuse);
	glColor4fv(GLvar->blanc_diffuse);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glNormal3f(0,1,0);
	/*	
	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GREATER, .15);
	*/
	float vertexX,vertexZ, vertexY;
#if defined( GL_REGISTER_COMBINERS_NV) && defined(GL_VERTEX_PROGRAM_NV)
	if (GLvar->bNVExtension && GLvar->details!=0) {
		glEnable(GL_LIGHTING);
		glActiveTextureARB(GL_TEXTURE1_ARB); 
		glEnable(GL_TEXTURE_2D); 
		glActiveTextureARB(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		glCombinerParameterfvNV(GL_CONSTANT_COLOR0_NV,halfMul);
		glCombinerParameterfvNV(GL_CONSTANT_COLOR1_NV,halfAdd);
		
		
		if (GLvar->m_nRegisterCombiners>2) {
			glCombinerParameteriNV(GL_NUM_GENERAL_COMBINERS_NV,3);
			glCombinerInputNV(GL_COMBINER2_NV, GL_RGB, GL_VARIABLE_A_NV, GL_SPARE0_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerInputNV(GL_COMBINER2_NV, GL_RGB, GL_VARIABLE_B_NV, GL_SECONDARY_COLOR_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
			glCombinerOutputNV(GL_COMBINER2_NV, GL_RGB, GL_SECONDARY_COLOR_NV, GL_DISCARD_NV, GL_DISCARD_NV, GL_NONE, GL_NONE, GL_FALSE, GL_FALSE, GL_FALSE);
		} else {
			glCombinerParameteriNV(GL_NUM_GENERAL_COMBINERS_NV,2);
		}
		
		glCombinerInputNV(GL_COMBINER0_NV, GL_RGB, GL_VARIABLE_A_NV, GL_PRIMARY_COLOR_NV, GL_EXPAND_NORMAL_NV, GL_RGB);
		glCombinerInputNV(GL_COMBINER0_NV, GL_RGB, GL_VARIABLE_B_NV, GL_TEXTURE1_ARB, GL_EXPAND_NORMAL_NV, GL_RGB);
		glCombinerOutputNV(GL_COMBINER0_NV, GL_RGB, GL_SPARE0_NV, GL_DISCARD_NV, GL_DISCARD_NV, GL_NONE, GL_NONE , GL_TRUE, GL_FALSE, GL_FALSE);
		
		
		glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_A_NV, GL_SPARE0_NV, GL_SIGNED_IDENTITY_NV, GL_RGB);
		glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_B_NV, GL_CONSTANT_COLOR0_NV, GL_SIGNED_IDENTITY_NV, GL_RGB);
		glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_C_NV, GL_ZERO, GL_UNSIGNED_INVERT_NV, GL_RGB);
		glCombinerInputNV(GL_COMBINER1_NV, GL_RGB, GL_VARIABLE_D_NV, GL_CONSTANT_COLOR1_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
		glCombinerOutputNV(GL_COMBINER1_NV, GL_RGB, GL_DISCARD_NV, GL_DISCARD_NV, GL_SPARE0_NV, GL_NONE, GL_NONE, GL_FALSE, GL_FALSE, GL_FALSE);
		
		glFinalCombinerInputNV(GL_VARIABLE_A_NV, GL_FOG, GL_UNSIGNED_IDENTITY_NV, GL_ALPHA);
		glFinalCombinerInputNV(GL_VARIABLE_B_NV, GL_E_TIMES_F_NV,  GL_UNSIGNED_IDENTITY_NV, GL_RGB);
		glFinalCombinerInputNV(GL_VARIABLE_C_NV, GL_ZERO, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
		
		glFinalCombinerInputNV(GL_VARIABLE_D_NV, GL_SECONDARY_COLOR_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);  
		
		glFinalCombinerInputNV(GL_VARIABLE_E_NV, GL_SPARE0_NV, GL_UNSIGNED_IDENTITY_NV, GL_RGB);
		glFinalCombinerInputNV(GL_VARIABLE_F_NV, GL_TEXTURE0_ARB,  GL_UNSIGNED_IDENTITY_NV, GL_RGB);
		
		glFinalCombinerInputNV(GL_VARIABLE_G_NV, GL_TEXTURE0_ARB, GL_UNSIGNED_IDENTITY_NV, GL_ALPHA);
		
		
		glEnable(GL_REGISTER_COMBINERS_NV);
		
		glEnable(GL_VERTEX_PROGRAM_NV);
		glBindProgramNV(GL_VERTEX_PROGRAM_NV, 1);



		for (i=0; i<15; i++) {
			for (int j=-3;j<3;j++) {
			
				texture = aFloor[((i+floorOffset)%15)*6+j+3];
				textureMap = aFloorMap[((i+floorOffset)%15)*6+j+3];
			
				glActiveTextureARB(GL_TEXTURE1_ARB); 
				glBindTexture(GL_TEXTURE_2D, GLvar->texture_floorMap[textureMap]);
				glActiveTextureARB(GL_TEXTURE0_ARB); 
				glBindTexture(GL_TEXTURE_2D, GLvar->texture_floor[texture]);
			
				glBegin(GL_QUADS);
			
				vertexX = j*3.5;
				vertexZ = (i+1)*5-floorScrollOffset;
				vertexY = 0;
				glTexCoord2f(1,1);
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5+3.5;
				vertexZ = (i+1)*5-floorScrollOffset;
				glTexCoord2f(0,1);
				vertexY = 0;
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5+3.5;
				vertexZ = i*5-floorScrollOffset;
				vertexY = 0;
				glTexCoord2f(0,0);
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5;
				vertexZ = i*5-floorScrollOffset;
				vertexY = 0;
				glTexCoord2f(1,0);
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				glEnd();
			
			}       		
		}


		glActiveTextureARB(GL_TEXTURE1_ARB);
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_floorMap[1]);
		glActiveTextureARB(GL_TEXTURE0_ARB); 

	
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_border);
		glBegin(GL_QUADS);
		for (i=0; i<15; i++) {
			int j=-4;
			vertexX = j*3.5+2;
			vertexZ = (i+1)*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(.5,1);
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+3.5;
			vertexZ = (i+1)*5-floorScrollOffset;
			glTexCoord2f(.99,1);
			vertexY = 0;
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+3.5;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(.99,0);
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(0.5,0);
			glVertex3f(vertexX,  vertexY ,      vertexZ);            
				
		
			j=3 ;
			vertexX = j*3.5;
			vertexZ = (i+1)*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(.99,1);
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = (i+1)*5-floorScrollOffset;
			glTexCoord2f(0.5,1);
			vertexY = 0;
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(0.5,0);
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glTexCoord2f(.99,0);
			glVertex3f(vertexX,  vertexY ,      vertexZ);            
		
		
		}
		glEnd();



		glActiveTextureARB(GL_TEXTURE1_ARB); 
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_VERTEX_PROGRAM_NV);
		glDisable(GL_REGISTER_COMBINERS_NV);
		glActiveTextureARB(GL_TEXTURE0_ARB); 

	} else 
#endif
	if (GLvar->bEXTEnvDot3  && GLvar->details!=0) {
		static float interpolateCoef[] = { .55,.55,.55,.55 };
		int oldFloor = 0;
		int oldFloorMap = 0;

		glDisable(GL_LIGHTING);
		glActiveTextureARB(GL_TEXTURE0_ARB); 
		glEnable(GL_TEXTURE_2D);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_DOT3_RGB_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE0_RGB_EXT, GL_TEXTURE);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE1_RGB_EXT, GL_PRIMARY_COLOR_EXT);

		glActiveTextureARB(GL_TEXTURE1_ARB);
		glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, interpolateCoef);
		glEnable(GL_TEXTURE_2D); 
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_INTERPOLATE_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE0_RGB_EXT, GL_TEXTURE);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE1_RGB_EXT, GL_PREVIOUS_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE2_RGB_EXT, GL_CONSTANT_EXT);
		glTexEnvf(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_REPLACE);
		glTexEnvf(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA_EXT, GL_TEXTURE);


		for (i=0; i<15; i++) {
			for (int j=-3;j<3;j++) {
			
				texture = aFloor[((i+floorOffset)%15)*6+j+3];
				textureMap = aFloorMap[((i+floorOffset)%15)*6+j+3];

				if (GLvar->texture_floorMap[textureMap]!=oldFloorMap) {
					oldFloorMap = GLvar->texture_floorMap[textureMap];
					glActiveTextureARB(GL_TEXTURE0_ARB); 
					glBindTexture(GL_TEXTURE_2D, oldFloorMap);
				}

				if (GLvar->texture_floorMap[texture]!=oldFloor) {
					oldFloor = GLvar->texture_floor[texture];
					glActiveTextureARB(GL_TEXTURE1_ARB); 
					glBindTexture(GL_TEXTURE_2D, oldFloor);
				}

		
				glBegin(GL_QUADS);
			
				vertexX = j*3.5;
				vertexZ = (i+1)*5-floorScrollOffset;
				vertexY = 0;
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1,1);
				glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1,1);
				glColor3fv(getDirection(vertexX, vertexY, vertexZ));
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5+3.5;
				vertexZ = (i+1)*5-floorScrollOffset;
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0,1);
				glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0,1);
				vertexY = 0;
				glColor3fv(getDirection(vertexX, vertexY, vertexZ));
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5+3.5;
				vertexZ = i*5-floorScrollOffset;
				vertexY = 0;
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0,0);
				glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0,0);
				glColor3fv(getDirection(vertexX, vertexY, vertexZ));
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				vertexX = j*3.5;
				vertexZ = i*5-floorScrollOffset;
				vertexY = 0;
				glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1,0);
				glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1,0);
				glColor3fv(getDirection(vertexX, vertexY, vertexZ));
				glVertex3f(vertexX,  vertexY ,      vertexZ);
			
				glEnd();	
			}
		}
	  
		glActiveTextureARB(GL_TEXTURE0_ARB);
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_floorMap[1]);
		glActiveTextureARB(GL_TEXTURE1_ARB); 
	  	glBindTexture(GL_TEXTURE_2D, GLvar->texture_border);

		glBegin(GL_QUADS);
		for (i=0; i<15; i++) {
			int j=-4;
			vertexX = j*3.5+2;
			vertexZ = (i+1)*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,.5,1);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,.5,1);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+3.5;
			vertexZ = (i+1)*5-floorScrollOffset;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.99,1);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.99,1);
			vertexY = 0;
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+3.5;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.99,0);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.99,0);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,.5,0);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,.5,0);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);            
		
		
			j=3 ;
			vertexX = j*3.5;
			vertexZ = (i+1)*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.99,1);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.99,1);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = (i+1)*5-floorScrollOffset;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,.5,1);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,.5,1);
			vertexY = 0;
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5+2;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,.5,0);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,.5,0);
			glTexCoord2f(0.5,0);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);
		
			vertexX = j*3.5;
			vertexZ = i*5-floorScrollOffset;
			vertexY = 0;
			glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.99,0);
			glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.99,0);
			glColor3fv(getDirection(vertexX, vertexY, vertexZ));
			glVertex3f(vertexX,  vertexY ,      vertexZ);            	
		}
		glEnd();


		glActiveTextureARB(GL_TEXTURE1_ARB); 
		glDisable(GL_TEXTURE_2D); 
		glActiveTextureARB(GL_TEXTURE0_ARB); 
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	} else {

	  // BASIC OPENGL RENDERING

		glEnable(GL_LIGHTING);
 	 glEnable(GL_TEXTURE_2D);

	  for (i=0; i<15; i++) {
		for (int j=-3;j<3;j++) {
			
		  texture = aFloor[((i+floorOffset)%15)*6+j+3];
		  textureMap = aFloorMap[((i+floorOffset)%15)*6+j+3];
			
		  glBindTexture(GL_TEXTURE_2D, GLvar->texture_floor[texture]);
			
		  glBegin(GL_QUADS);
			
		  vertexX = j*3.5;
		  vertexZ = (i+1)*5-floorScrollOffset;
		  vertexY = 0;
		  glTexCoord2f(1,1);
		  glVertex3f(vertexX,  vertexY ,      vertexZ);
			
		  vertexX = j*3.5+3.5;
		  vertexZ = (i+1)*5-floorScrollOffset;
		  glTexCoord2f(0,1);
		  vertexY = 0;
		  glVertex3f(vertexX,  vertexY ,      vertexZ);
			
		  vertexX = j*3.5+3.5;
		  vertexZ = i*5-floorScrollOffset;
		  vertexY = 0;
		  glTexCoord2f(0,0);
		  glVertex3f(vertexX,  vertexY ,      vertexZ);
			
		  vertexX = j*3.5;
		  vertexZ = i*5-floorScrollOffset;
		  vertexY = 0;
		  glTexCoord2f(1,0);
		  glVertex3f(vertexX,  vertexY ,      vertexZ);
			
		  glEnd();
			
		}       
		
	  }
	
	  glBindTexture(GL_TEXTURE_2D, GLvar->texture_border);
	  glBegin(GL_QUADS);
	  for (i=0; i<15; i++) {
		int j=-4;
		vertexX = j*3.5+2;
		vertexZ = (i+1)*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(.5,1);
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5+3.5;
		vertexZ = (i+1)*5-floorScrollOffset;
		glTexCoord2f(.99,1);
		vertexY = 0;
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5+3.5;
		vertexZ = i*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(.99,0);
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5+2;
		vertexZ = i*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(0.5,0);
		glVertex3f(vertexX,  vertexY ,      vertexZ);            
				
		
		j=3 ;
		vertexX = j*3.5;
		vertexZ = (i+1)*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(.99,1);
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5+2;
		vertexZ = (i+1)*5-floorScrollOffset;
		glTexCoord2f(0.5,1);
		vertexY = 0;
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5+2;
		vertexZ = i*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(0.5,0);
		glVertex3f(vertexX,  vertexY ,      vertexZ);
		
		vertexX = j*3.5;
		vertexZ = i*5-floorScrollOffset;
		vertexY = 0;
		glTexCoord2f(.99,0);
		glVertex3f(vertexX,  vertexY ,      vertexZ);            
		
		
	  }
	  glEnd();

	 glDisable(GL_TEXTURE_2D);

	}

	glDisable(GL_ALPHA_TEST);

	glDisable(GL_TEXTURE_2D);
	glLightfv(GL_LIGHT0, GL_SPECULAR,  GLvar->blanc_diffuse);
	glDisable(GL_BLEND); 
}

/*
* static void drawPlayers
*
* Draw everything concerning the player
*/


void Scene::drawPlayers()
{
	static int oldPower=-1;
	static int oldPowerMax=-1;
	static int oldBomb=-1;
	int i;
	static char stBomb[] ="x 5          ";
	static char stScore[]= "00000000";
#ifdef GLAX_VERSION
	static char stVersion[] = "Glaxium "GLAX_VERSION;
#endif
	static float powerRatio;
	
	
	glDepthMask(GL_FALSE);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0f, (GLfloat) GLvar->width, 0.0f, (GLfloat) GLvar->height, -1.0f, 1.0f);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	//   glMaterialfv(GL_FRONT,GL_AMBIENT, GLvar->blanc_diffuse);
	//   glMaterialfv(GL_FRONT,GL_DIFFUSE,GLvar->blanc_diffuse);

		// ====== POWER ===========
	
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 

	if (GLvar->mySpaceShip!=NULL)
	{
		if (oldPower!=((MyShip*)GLvar->mySpaceShip)->getShield())
		{
			oldPower=((MyShip*)GLvar->mySpaceShip)->getShield();
		}
		if (oldPowerMax!=((MyShip*)GLvar->mySpaceShip)->getShieldMax())
		{
			oldPowerMax=((MyShip*)GLvar->mySpaceShip)->getShieldMax();
		}
	} else {
		oldPower=0;
	}
	powerRatio  =((float)oldPower/oldPowerMax);
	
	glBegin(GL_QUADS);
	
	glColor4f(.7,.3,.3,0.8);
	glVertex2f(GLvar->width*.822,GLvar->height*.845);
	glVertex2f(GLvar->width*.822,GLvar->height*.815);
	glColor4f(.7-.4*powerRatio,.3,.3+.4*powerRatio,0.8);
	glVertex2f(GLvar->width*.822 + GLvar->width * .134*powerRatio,GLvar->height*.815);
	glVertex2f(GLvar->width*.822 + GLvar->width * .134*powerRatio,GLvar->height*.845);
//	glColor4f(.5,.5,1,0.6);
	
	glEnd();




	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D,GLvar->texture_board);
	glColor4f(1,1,1,1);
	
	glBegin(GL_QUADS);
	glTexCoord2f(0,0);
	glVertex2f(GLvar->width*.8,GLvar->height*.98);
	glTexCoord2f(0,1);
	glVertex2f(GLvar->width*.8,GLvar->height*.8);
	glTexCoord2f(1,1);
	glVertex2f(GLvar->width*.98,GLvar->height*.8);
	glTexCoord2f(1,0);
	glVertex2f(GLvar->width*.98,GLvar->height*.98);
	glEnd();
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	
	
	
	
	
	
	// ============= bomb ==============
	
	glColor4f(1,1,0,0.6);
	
	glBegin(GL_TRIANGLES);
	glVertex2f(GLvar->width*.89-22,GLvar->height*.90);
	glVertex2f(GLvar->width*.89-26,GLvar->height*.885);
	glVertex2f(GLvar->width*.89-18,GLvar->height*.885);
	glEnd();


	
	// ============ New Partie =============
	
	
	
	if (GLvar->mySpaceShip==NULL)
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,GLvar->texture_gameover);               
		//glEnable(GL_LIGHTING);
		glMaterialfv(GL_FRONT,GL_DIFFUSE,GLvar->blanc_diffuse);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GEQUAL, 0.3);    
		
	    glColor4f(1,1,2,1);
		glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex2f(GLvar->width/4,3*GLvar->height/4);
		glTexCoord2f(0,1);
		glVertex2f(GLvar->width/4,GLvar->height/1.7);
		glTexCoord2f(1,1);
		glVertex2f(3*GLvar->width/4,GLvar->height/1.7);
		glTexCoord2f(1,0);
		glVertex2f(3*GLvar->width/4,3*GLvar->height/4);
		glEnd();
		
		glDisable(GL_ALPHA_TEST);
		// glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
		
	}
	
	// TEXT
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f);

	glDepthFunc(GL_ALWAYS);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	// ========= Score ============
	
	//    glColor4f(1,0,0,0.4);
	
	if (GLvar->mySpaceShip!=NULL) {
		if  (globalScore!=((MyShip*)GLvar->mySpaceShip)->getScore())
		{
			globalScore=((MyShip*)GLvar->mySpaceShip)->getScore();
			sprintf(stScore,"%8.8d",globalScore);
		}

		if  (oldBomb!=((MyShip*)GLvar->mySpaceShip)->getBomb())
		{
			oldBomb=((MyShip*)GLvar->mySpaceShip)->getBomb();
			sprintf(stBomb, "X %d", oldBomb);
		}
	}
	
	drawText(.832,.91, 0, stScore,10);
	
	drawText(.885,.875, 0, stBomb, 8, 1,1,0);
	
/*
	for(i = 0; stScore[i] != 0; i++){
//		glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, stScore[i]);
		glBitmap(8,15, 0.0 ,0.0 ,10.0 ,0.0 ,numbers[stScore[i]-48]);
	}
*/


	if (displayFPS) {
	  drawFPS();
	}

	glDepthMask(GL_TRUE);
	glDepthFunc(GL_LEQUAL);
	glDisable(GL_BLEND);
	glEnable(GL_LIGHTING);
}


/*
* void drawFPS
*
* Draws FPS in upper left corner of Display d
*
*/

void Scene::drawFPS() 
{
	static char tmp[20]="FPS: 0";
	int i;
	int diff;
	static int fps = 0;
	static int cpt =0;  
	

	diff = (dt > 0) ? dt : 1;
	cpt++;
	if (cpt==30)
	{
		cpt=0;
		timediff();
		fps = 30000 / dt;
		
		sprintf(tmp, "FPS: %d", fps);
	}

	drawText(.01,.95, 0,tmp, 10);
}



void Scene::timediff() 
{
	int t;
	
	t = glutGet((GLenum)GLUT_ELAPSED_TIME);
	dt = t - lasttime;
	lasttime = t;
}

void Scene::toggleDisplayFPS() {
	if (displayFPS)
	{
		displayFPS=0;
	}
	else
	{
		displayFPS=1;
	}
}

void Scene::toggleSpecular() {
	if (bSpecular)
	{
		bSpecular=false;
		glMaterialfv(GL_FRONT, GL_SPECULAR, GLvar->nothing);
		glLightfv(GL_LIGHT0, GL_SPECULAR,  GLvar->nothing);
	}
	else
	{
		bSpecular=true;
		glMaterialfv(GL_FRONT, GL_SPECULAR, GLvar->blanc_diffuse);
		glLightfv(GL_LIGHT0, GL_SPECULAR,  GLvar->blanc_diffuse);

	}
}


void Scene::toggleFog() {
	if (nFog==1) {
		nFog=0;
		glFogf(GL_FOG_MODE,GL_EXP2);
		glFogf(GL_FOG_DENSITY, .022);
		glFogfv(GL_FOG_COLOR,GLvar->nothing);
	} else {
		nFog=1;
		glFogf(GL_FOG_MODE,GL_LINEAR);
		glFogf(GL_FOG_START, 35);
		glFogf(GL_FOG_END, 65);
		glFogfv(GL_FOG_COLOR,GLvar->nothing);
	}
}

/*
* void drawPresentation
*
* Draws the first page with the spaceship turning
*
*/



void Scene::drawPresentation() {
	int i,j;
	
	glColor4f(0,0,0,1);
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glViewport(0,0,GLvar->width ,GLvar->height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0, 1.0 , 0.0, 1.0 , -10.0, 10.0);
	glMatrixMode(GL_MODELVIEW);
	
	glLoadIdentity();
	
	glDisable(GL_DEPTH_TEST);   
	glDisable(GL_BLEND);    
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
	
	for (j=0; j<2; j++) {
		for (i=0; i<3; i++) {
			glBindTexture(GL_TEXTURE_2D, GLvar->texture_title[j*3+i]);
			
			glBegin(GL_QUADS) ;
			{
				glNormal3f(0,1,0);

				glTexCoord2f(0,0);
				glVertex3f(0.4*i,1.0-0.5333333*j,5);
				glTexCoord2f(0,1);
				glVertex3f(0.4*i,1.0-0.5333333*(j+1),5);
				glTexCoord2f(1,1);
				glVertex3f(0.4*(i+1),1.0-0.5333333*(j+1),5);
				
				glTexCoord2f(1,0);
				glVertex3f(0.4*(i+1),1.0-0.5333333*j,5);
				
				
			}
			glEnd();
		}
	}
	
	
	
	glEnable(GL_DEPTH_TEST);    
	glMatrixMode(GL_PROJECTION);
	
	glLoadIdentity();
	
	gluPerspective(50, 1.333333 , 0.5, 10);  
	glMatrixMode(GL_MODELVIEW);
	
	glLoadIdentity();
	gluLookAt(	0,2.0,-3.6,
				0,1.0,0,
				0,1.0,0);
	glTranslatef(0,.2,0);
	
	glRotatef(GLvar->rotateMyShip,0,1,0);
	
	glBindTexture(GL_TEXTURE_2D, GLvar->texture_myship);
	glEnable(GL_TEXTURE_2D);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, GLvar->blanc_diffuse);
	
 
	if (GLvar->bNVExtension) 
	  glCallList(MyShip::list_);
	else {
#ifdef GL_SINGLE_COLOR
		if (GLvar->bSeparateSpecularColor) {
		  glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SINGLE_COLOR);
		}
#endif
	  glCallList(MyShip::list_+3);
#ifdef GL_SEPARATE_SPECULAR_COLOR
	if (GLvar->bSeparateSpecularColor) {
	  glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SEPARATE_SPECULAR_COLOR);
	}
#endif
	}
	
	
	
	SDL_GL_SwapBuffers();
	
	if ((glError=glGetError())!=GL_NO_ERROR) {
		printf("OpenGL error : %s\n", gluErrorString(glError));
	}
}



/*
* void drawGame
*
* Draws all the spaceships.. test the collision etc...
*
*/


void Scene::drawGame()
{
	static float posX,posZ,dposX,dposZ;
	
	if (GLvar->bShadows==true) {    
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	} else {
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	}
	
	glViewport(0,0,GLvar->width ,GLvar->height);
	
	if (GLvar->mySpaceShip!=NULL)
	{
		if( posX != GLvar->mySpaceShip->getX())
		{
			posX = GLvar->mySpaceShip->getX();
		}
		if( posZ != GLvar->mySpaceShip->getZ())
		{
			posZ = GLvar->mySpaceShip->getZ();
		}
		if( dposX != GLvar->mySpaceShip->getDx())
		{
			dposX = GLvar->mySpaceShip->getDx();
		}
		if( dposZ != GLvar->mySpaceShip->getDz())
		{
			dposZ = GLvar->mySpaceShip->getDz();
		}
		
	}
	else
	{
		if (posX<-0.01)
		{
			posX+=.02;
		}
		else if (posX>0.01)
		{
			posX-=.02;
		}
		else
		{
			posX=0;
		}
		if (posZ<12)
		{
			posZ+=.02;
		}
	}
	
	switch (GLvar->camera) 
	{
	case 1:
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(50, 1.333333 , 2.0, 160);
		// Important part !    
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		
		camX = posX*.9;
		camY = 2.5+posZ/3 ;
		camZ = -2;
		gluLookAt(	posX*.9 , 3+posZ/3 ,-2,
					posX,  .4 , 7+posZ/2.5 ,
					dposX/4, 1-dposX/4, 0);
		//            glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11,  posX*.9, 2.5+posZ/3 ,-2, 1);	// Light direction
		break;
	case 2:
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(50, 0.8, 3, 100);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		camX = posX*.2;
		camY = 36 ;
		camZ = 21-(21-posZ)*.2;
		gluLookAt(posX*.2 , 36 ,21-(21-posZ)*.2,
			posX*.2 , 0,   21-(21-posZ)*.2,
			0, 0, 1);
		//          glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11, posX*.2 , 36 ,21-(21-posZ)*.2,1);	// Light direction
		break;
	}
	// c[8] : Spaceship position
#if defined( GL_REGISTER_COMBINERS_NV) && defined(GL_VERTEX_PROGRAM_NV)
	if (glProgramParameter4fNV!=NULL) {
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 8, -posX, 3.5 , posZ, 1);	
		// c[11] : camera position
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11, camX, camY, camZ,1);	
	}
#endif	
	
	glPushMatrix();
	
	glColor4f(1.0, 1.0, 1.0 , 1);


	drawSky();
	
	if (GLvar->bShadows==true) {
		
		//        glDepthMask(GL_FALSE);
		
		glEnable(GL_STENCIL_TEST);
		glStencilFunc(GL_ALWAYS, 1,1);
		glStencilOp(GL_REPLACE,GL_REPLACE,GL_REPLACE);
		
		drawFloor();
		
		glDisable(GL_STENCIL_TEST);    
		glEnable(GL_LIGHTING);
	} else {
		glEnable(GL_LIGHTING);
		drawFloor();
	}
	
	glPopMatrix();

	
	globalList->draw();
	
	if (GLvar->bShadows==true) {    
		glEnable(GL_STENCIL_TEST);    
		glStencilFunc(GL_EQUAL, 1, 1);
		glStencilOp(GL_ZERO,GL_ZERO,GL_ZERO);
		//        glDepthMask(GL_TRUE);
		
		glMultMatrixf(GLvar->shadowMatrix);
		
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		
		glEnable(GL_POLYGON_OFFSET_FILL);
		glPolygonOffset(-1.0,1.0);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);   
		glColor4f(0,0,0,.35);
		
		globalList->drawShadows();
		
		glDisable(GL_POLYGON_OFFSET_FILL);
		
		glDisable(GL_BLEND);
		glDisable(GL_STENCIL_TEST);    
		glEnable(GL_LIGHTING);
	}
	
	globalList->collision();
	
	if (GLvar->mySpaceShip!=NULL)  {
		if (GLvar->mySpaceShip->isDead())
		{
			GLvar->mySpaceShip=NULL;
			GLvar->delay=0;
		}
	} else {
		GLvar->delay+=GLvar->global_timeadjustment;
	}
	
	globalList->cleanList();
	
	drawPlayers();  
		
	SDL_GL_SwapBuffers();
	
	if ((glError=glGetError())!=GL_NO_ERROR) {
		printf("OpenGL error : %s\n", gluErrorString(glError));
	}
	
	
}






/*
* void init
*
* OpenGL initialisation
*/


void Scene::initOpenGl()
{
	// This is the actual vertex program. For more information on what these instructions do
	// refere to NVIDIA's website. There are numberous Docs on this specification.
	// R0 = NORMAL
	// R3 = light direction
	// R4 = R0.R3
	
	const unsigned char floorShader[]=
	{
	"!!VP1.0  MOV o[TEX0],v[TEX0]; MOV o[TEX1],v[TEX0]; DP4 o[HPOS].x,v[OPOS],c[0]; DP4 o[HPOS].y,v[OPOS],c[1]; DP4 o[HPOS].z,v[OPOS],c[2]; DP4 o[HPOS].w,v[OPOS],c[3]; MOV R0, v[OPOS]; ADD R7, c[11], -R0; MOV R0.x, -R0.x; ADD R3, c[8], -R0; DP3 R1, R3, R3; RSQ R1.x, R1.x; MUL R5.x, c[9].x, R1.x; MUL R3.xyz, R3, R1.x; MAD R4, R3, c[10], c[10]; MOV o[COL0], R4.xzyw; ADD R3.x, R5.x, c[12].x; MAX R2.x, R2.x, c[12].y; MUL o[COL1],R5.x, R3.x; DP3 R7, R7, R7; RSQ R7.x, R7.x; MUL o[FOGC], R7.x, R7.y; END"	
	};

	
	printf("OpenGL Info : %s\n              %s\n              %s\n", 
		glGetString(GL_VENDOR),
		glGetString(GL_RENDERER), 
		glGetString(GL_VERSION));
	
	// printf("%s\n", glGetString(GL_EXTENSIONS));
	
	glClearColor(0,0,0,1.0);
	
	glEnable(GL_FOG);
	
	nFog=1;
	glFogf(GL_FOG_MODE,GL_LINEAR);
	glFogf(GL_FOG_START, 35);
	glFogf(GL_FOG_END, 65);
	glFogfv(GL_FOG_COLOR,GLvar->nothing);
#if 0
	glFogf(GL_FOG_MODE,GL_EXP2);
	glFogf(GL_FOG_START, 50);
	glFogf(GL_FOG_DENSITY, .022);
	glFogfv(GL_FOG_COLOR,GLvar->nothing);
#endif
	
	glEnable(GL_NORMALIZE);

	bSpecular = true;
	glMaterialfv(GL_FRONT, GL_AMBIENT, GLvar->lm_ambient);
	glMaterialfv(GL_FRONT, GL_SPECULAR, GLvar->blanc_diffuse);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, GLvar->blanc_diffuse);
	glMaterialf(GL_FRONT, GL_SHININESS, 64.0f);
	
	glLightfv(GL_LIGHT0, GL_AMBIENT,  GLvar->lm_ambient); 
	glLightfv(GL_LIGHT0, GL_DIFFUSE,  GLvar->blanc_diffuse);
	glLightfv(GL_LIGHT0, GL_SPECULAR,  GLvar->blanc_diffuse);
	glLightfv(GL_LIGHT0, GL_POSITION, GLvar->light_position);
	
#ifdef GL_SEPARATE_SPECULAR_COLOR
	if (GlaxiumVariables::isExtensionSupported("GL_EXT_separate_specular_color")) {
		glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL, GL_SEPARATE_SPECULAR_COLOR);
	}
#endif


	// IF speedUP 
//		glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_FALSE);
//s	else 
	glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_DEPTH_TEST);
	
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);  

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);


#ifdef WIN32
	glActiveTextureARB=(PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB"); 
	glMultiTexCoord2fARB=(PFNGLMULTITEXCOORD2FARBPROC)wglGetProcAddress("glMultiTexCoord2fARB"); 
#endif

#if defined( GL_REGISTER_COMBINERS_NV) && defined(GL_VERTEX_PROGRAM_NV)
	if (GLvar->bNVExtension) {
#ifdef WIN32		
		glCombinerParameteriNV=(PFNGLCOMBINERPARAMETERINVPROC)wglGetProcAddress("glCombinerParameteriNV");
		glCombinerInputNV=(PFNGLCOMBINERINPUTNVPROC)wglGetProcAddress("glCombinerInputNV");
		glCombinerOutputNV=(PFNGLCOMBINEROUTPUTNVPROC)wglGetProcAddress("glCombinerOutputNV");
		glFinalCombinerInputNV=(PFNGLFINALCOMBINERINPUTNVPROC)wglGetProcAddress("glFinalCombinerInputNV");
		glCombinerParameterfvNV=(PFNGLCOMBINERPARAMETERFVNVPROC)wglGetProcAddress("glCombinerParameterfvNV"); 
		glLoadProgramNV=(PFNGLLOADPROGRAMNVPROC )wglGetProcAddress("glLoadProgramNV");
		glBindProgramNV=(PFNGLBINDPROGRAMNVPROC)wglGetProcAddress("glBindProgramNV");
		glTrackMatrixNV=(PFNGLTRACKMATRIXNVPROC)wglGetProcAddress("glTrackMatrixNV");
		glProgramParameter4fNV=(PFNGLPROGRAMPARAMETER4FNVPROC)wglGetProcAddress("glProgramParameter4fNV");
#else 
		glCombinerParameteriNV=(PFNGLCOMBINERPARAMETERINVPROC)glXGetProcAddressARB((const GLubyte *)"glCombinerParameteriNV");
		glCombinerInputNV=(PFNGLCOMBINERINPUTNVPROC)glXGetProcAddressARB((const GLubyte *)"glCombinerInputNV");
		glCombinerOutputNV=(PFNGLCOMBINEROUTPUTNVPROC)glXGetProcAddressARB((const GLubyte *)"glCombinerOutputNV");
		glFinalCombinerInputNV=(PFNGLFINALCOMBINERINPUTNVPROC)glXGetProcAddressARB((const GLubyte *)"glFinalCombinerInputNV");
		glCombinerParameterfvNV=(PFNGLCOMBINERPARAMETERFVNVPROC)glXGetProcAddressARB((const GLubyte *)"glCombinerParameterfvNV"); 
		glLoadProgramNV=(PFNGLLOADPROGRAMNVPROC )glXGetProcAddressARB((const GLubyte *)"glLoadProgramNV");
		glBindProgramNV=(PFNGLBINDPROGRAMNVPROC)glXGetProcAddressARB((const GLubyte *)"glBindProgramNV");
		glTrackMatrixNV=(PFNGLTRACKMATRIXNVPROC)glXGetProcAddressARB((const GLubyte *)"glTrackMatrixNV");
		glProgramParameter4fNV=(PFNGLPROGRAMPARAMETER4FNVPROC)glXGetProcAddressARB((const GLubyte *)"glProgramParameter4fNV");
#endif
		// enabled in when required
		glDisable(GL_VERTEX_PROGRAM_NV);
		//Now we enable VERTEX PROGRAMS. And Load it up.
		glBindProgramNV(GL_VERTEX_PROGRAM_NV, 1);
		glLoadProgramNV(GL_VERTEX_PROGRAM_NV, 1, strlen((char * ) floorShader), floorShader);
		
		//Load the Projection matrix into Vector Registers c[0]...
		glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, 0, GL_MODELVIEW_PROJECTION_NV, GL_IDENTITY_NV);
		glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, 4, GL_MODELVIEW, GL_INVERSE_TRANSPOSE_NV);
		//Load the Light position into Vector Register c[8].
		//     glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 8, posX, 2 , posZ, 1);	// Light direction
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 8, 0, 10 , 20, 1);	// Light direction
		// c[9].x : lumiere vaisseau
		// FOG = dist * c[9].z + / c[9].y
		// linear near = 40; far = 70;
		// c[9].y : -40
		// c[9].z : 1/(fog far- fog near)  = 1/30 = 
		// c[9].w : ambiant floor color (c[9].w,c[9].w,c[9].w);
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 9, 3, -40 , 0.0333333, .25);	// Constant
		// c[10]
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 10, .5, 0.5 , .5, 1);	// Constant for bump map...
		// c[11] : camera position
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11, 1,1,1,1);	
		// c[12] : fog for secondary color
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 12, -.2
			, 0, 0, 0);	
		
		
	}
#endif	
}

/*
* void gameIdle
*
* Main game loop
*
*/


void Scene::gameIdle() 
{
	static int oldTimer =  glutGet((GLenum)(GLUT_ELAPSED_TIME));
	
	int newTimer = glutGet((GLenum)(GLUT_ELAPSED_TIME));
	
	
//	  printf("%d : %f\n",newTimer, GLvar->global_timeadjustment);
	GLvar->global_timeadjustment = ((float)newTimer-oldTimer)/20;
	
	if (GLvar->global_timeadjustment > 10) 
	{
		GLvar->global_timeadjustment=10;
	}
	
	oldTimer = newTimer;
	
	if (GLvar->global_pause)
		GLvar->global_timeadjustment=0;
	
	globalList->move();
	
	
	
	
	
	
	int level = 0;
	if (GLvar->mySpaceShip!=NULL)  {
		level = scene->globalScore/8000;
	}
	/*
	if (GLvar->myRandom(300))
	{
				float newX = (float)(random()%140)/10-7;
				float speed = ((float)(random()%64) /128.0f)+.5f;
				Fighter2 *newOne = new Fighter2(globalList,
					newX,70,
					speed,
					3+level);
				globalList->Add(newOne);
	}*/
	if (GLvar->myRandom(1000))
	{
		Tache *newOne = new Tache(globalList,
			(random()%21)-10, 8+level);
		globalList->Add(newOne);
		
	}
	if (GLvar->myRandom(160+ (scene->globalScore>10000)*80))
	{
		// printf("NEW sprite...................\n");
		Cube *newOne = new Cube(globalList,
			2,
			(random()%21)-10);
		globalList->Add(newOne);
		
	}
	if (GLvar->mySpaceShip!=NULL)  {
		
		
		if (((scene->globalScore>1000) && (scene->globalScore<12000)) || (scene->globalScore>35000)) {
			if (GLvar->myRandom(160)) {
				float newX = (float)(random()%140)/10-7;
				float speed = ((float)(random()%64) /128.0f)+.5f;
				//          printf("speed : %f\n", speed);
				Bandit2 *newOne = new Bandit2(globalList,
					newX,70,
					speed,
					3+level);
				globalList->Add(newOne);
				
			} 
		}
		
		if (((scene->globalScore>12000) && (scene->globalScore<35000)) || (scene->globalScore>55000)) {
			if (GLvar->myRandom(200))  {
				float newX = (float)(random()%140)/10-7;
				float speed = ((float)(random()%64) /128.0f)+.5f;
				//          printf("speed : %f\n", speed);
				Ship1 *newOne = new Ship1(globalList,
					newX,70.0f,
					speed,
					(int)(3+level*1.5));
				globalList->Add(newOne);
			} 
		}
		
	}
	
	
	if (scene->globalScore> 4000)
	{
		if (GLvar->myRandom(150 + (scene->globalScore>10000)*100))
		{
			Piege *newOne = new Piege(globalList,
				2,
				(random()%21)-10);
			globalList->Add(newOne);
			
		}
	}
	
	
	if (scene->globalScore > 50000)
	{
		if (GLvar->mySpaceShip!=NULL)
		{
			if (GLvar->myRandom(350-100*(scene->globalScore>80000)))
			{
				if (scene->globalScore<100000 && Tank::numberOfTanks_<3) {
					Tank*newOne = new Tank(globalList,
						(random()%21)-10,
						7+level*2);
					globalList->Add(newOne);
				}
				if (scene->globalScore>100000 && Tank::numberOfTanks_<6) {
					Tank*newOne = new Tank(globalList,
						(random()%21)-10,
						7+level*2);
					globalList->Add(newOne);
				}
				
			}
		}
	}
	
	
	
	if (scene->globalScore > 100000)
	{
		if (GLvar->myRandom(300))
		{
			// printf("NEW sprite...................\n");
			Tache *newOne = new Tache(globalList,
				(random()%21)-10,
				8+level);
			globalList->Add(newOne);
		}
		
	}
}


void Scene::presentationIdle() {
	static int oldTimer =  glutGet((GLenum)(GLUT_ELAPSED_TIME));
	
	int newTimer = glutGet((GLenum)(GLUT_ELAPSED_TIME));
	

	GLvar->global_timeadjustment = ((float)newTimer-oldTimer)/20;
	
	if (GLvar->global_timeadjustment > 10) 
	{
		GLvar->global_timeadjustment=10;
	}
	
	oldTimer = newTimer;
	
	
	if ((GLvar->rotateMyShip+=0.3*GLvar->global_timeadjustment)>360) GLvar->rotateMyShip-=360;
}



int Scene::createCube(float size)
{
	int list = glGenLists(1);
	glNewList(list,GL_COMPILE);
	{
		glBegin(GL_QUADS);
		
		glTexCoord2f(0, 0);
		glVertex3f(size/2,size/2,size/2);
		glTexCoord2f(0, 1);
		glVertex3f(size/2,size/2,-size/2);
		glTexCoord2f(1,1);
		glVertex3f(-size/2,size/2,-size/2);
		glTexCoord2f(1,0);
		glVertex3f(-size/2,size/2,size/2);
		
		
		glTexCoord2f(0, 0);
		glVertex3f(size/2,-size/2,size/2);
		glTexCoord2f(0, 1);
		glVertex3f(size/2,-size/2,-size/2);
		glTexCoord2f(1,1);
		glVertex3f(-size/2,-size/2,-size/2);
		glTexCoord2f(1,0);
		glVertex3f(-size/2,-size/2,size/2);
		
		glTexCoord2f(0, 0);
		glVertex3f(size/2,size/2,size/2);
		glTexCoord2f(1,0);
		glVertex3f(-size/2,size/2,size/2);
		glTexCoord2f(1,1);
		glVertex3f(-size/2,-size/2,size/2);
		glTexCoord2f(0, 1);
		glVertex3f(size/2,-size/2,size/2);
		
		glTexCoord2f(0, 0);
		glVertex3f(size/2,size/2,-size/2);
		glTexCoord2f(0, 1);
		glVertex3f(size/2,-size/2,-size/2);
		glTexCoord2f(1,1);
		glVertex3f(-size/2,-size/2,-size/2);
		glTexCoord2f(1,0);
		glVertex3f(-size/2,size/2,-size/2);
		
		glTexCoord2f(0, 0);
		glVertex3f(size/2,size/2,size/2);
		glTexCoord2f(0, 1);
		glVertex3f(size/2,size/2,-size/2);
		glTexCoord2f(1,1);
		glVertex3f(size/2,-size/2,-size/2);
		glTexCoord2f(1,0);
		glVertex3f(size/2,-size/2,size/2);
		
		
		glTexCoord2f(0, 0);
		glVertex3f(-size/2,size/2,size/2);
		glTexCoord2f(0, 1);
		glVertex3f(-size/2,size/2,-size/2);
		glTexCoord2f(1,1);
		glVertex3f(-size/2,-size/2,-size/2);
		glTexCoord2f(1,0);
		glVertex3f(-size/2,-size/2,size/2);
		
		glEnd();
		
	}
	glEndList();
	return list;
}

void Scene::createCube(float sizex,float sizey,float sizez)
{
	glBegin(GL_QUADS);
		
	glTexCoord2f(0, 0);
	glVertex3f(sizex/2,sizey/2,sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(sizex/2,sizey/2,-sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(-sizex/2,sizey/2,-sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(-sizex/2,sizey/2,sizez/2);
		
		
	glTexCoord2f(0, 0);
	glVertex3f(sizex/2,-sizey/2,sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(-sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(-sizex/2,-sizey/2,sizez/2);
		
	glTexCoord2f(0, 0);
	glVertex3f(sizex/2,sizey/2,sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(-sizex/2,sizey/2,sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(-sizex/2,-sizey/2,sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(sizex/2,-sizey/2,sizez/2);
		
	glTexCoord2f(0, 0);
	glVertex3f(sizex/2,sizey/2,-sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(-sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(-sizex/2,sizey/2,-sizez/2);
		
	glTexCoord2f(0, 0);
	glVertex3f(sizex/2,sizey/2,sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(sizex/2,sizey/2,-sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(sizex/2,-sizey/2,sizez/2);
		
		
	glTexCoord2f(0, 0);
	glVertex3f(-sizex/2,sizey/2,sizez/2);
	glTexCoord2f(0, 1);
	glVertex3f(-sizex/2,sizey/2,-sizez/2);
	glTexCoord2f(1,1);
	glVertex3f(-sizex/2,-sizey/2,-sizez/2);
	glTexCoord2f(1,0);
	glVertex3f(-sizex/2,-sizey/2,sizez/2);
		
	glEnd();
		
}




/*******************************
 **                           ** 
 **     BENCHMARCK            ** 
 **     BENCHMARCK            ** 
 **     BENCHMARCK            ** 
 **     BENCHMARCK            ** 
 **     BENCHMARCK            ** 
 **                           ** 
 **                           ** 
 *******************************/

static char strFinalResult[128];		

void Scene::drawBench()
{
	if (GLvar->bShadows==true) {    
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	} else {
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	}
	
	glViewport(0,0,GLvar->width ,GLvar->height);

	glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(50, 1.333333 , 2.0, 160);
		// Important part !    
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	
	camX = 4;
	camY = 5;
	camZ = -2;
	gluLookAt(4*cos(benchPeriod), 6 +cos(benchPeriod/2)  , 6+ 9*sin(benchPeriod/2),
			0,  .4 , 20 +4*sin(benchPeriod/2),
			.3*cos(benchPeriod), 1, 0);
	// c[8] : Spaceship position
#if defined( GL_REGISTER_COMBINERS_NV) && defined(GL_VERTEX_PROGRAM_NV)
	if (glProgramParameter4fNV!=NULL) {
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 8, 0, 3.5 , 10, 1);	
		// c[11] : camera position
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11, camX, camY, camZ,1);	
	}
#endif	
	
	glPushMatrix();
	
	glColor4f(1.0, 1.0, 1.0 , 1);

	drawSky();
	
	if (GLvar->bShadows==true) {
		
		//        glDepthMask(GL_FALSE);
		
		glEnable(GL_STENCIL_TEST);
		glStencilFunc(GL_ALWAYS, 1,1);
		glStencilOp(GL_REPLACE,GL_REPLACE,GL_REPLACE);
		
		drawFloor();
		
		glDisable(GL_STENCIL_TEST);    
		glEnable(GL_LIGHTING);
	} else {
		glEnable(GL_LIGHTING);
		drawFloor();
	}
	
	glPopMatrix();
	
	globalList->draw();
	
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	if (GLvar->bShadows==true) {    
		glEnable(GL_STENCIL_TEST);    
		glStencilFunc(GL_EQUAL, 1, 1);
		glStencilOp(GL_ZERO,GL_ZERO,GL_ZERO);
		//        glDepthMask(GL_TRUE);
		
		glMultMatrixf(GLvar->shadowMatrix);
		
		
		glEnable(GL_POLYGON_OFFSET_FILL);
		glPolygonOffset(-1.0,1.0);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);   
		glColor4f(0,0,0,.35);
		
		globalList->drawShadows();
		
		glDisable(GL_POLYGON_OFFSET_FILL);
		
		glDisable(GL_BLEND);
		glDisable(GL_STENCIL_TEST);    
	}
	
//	globalList->collision();
	
	
	globalList->cleanList();

	// TEXT
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f);

	glDepthFunc(GL_ALWAYS);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	drawFPSBench();

	if (benchState==4) {
		drawText(.3,.8, 0,strFinalResult, 20, 1,0,0);
	}

	glDepthFunc(GL_LEQUAL);

	SDL_GL_SwapBuffers();
	
	if ((glError=glGetError())!=GL_NO_ERROR) {
		printf("OpenGL error : %s\n", gluErrorString(glError));
	}
}



void Scene::benchIdle() 
{
	static TacheBench *newOne;
	static int oldTimer =  glutGet((GLenum)(GLUT_ELAPSED_TIME));
	static int benchFrames;
	static int benchTime;

	int newTimer = glutGet((GLenum)(GLUT_ELAPSED_TIME));
	int i;
	
//	  printf("%d : %f\n",newTimer, GLvar->global_timeadjustment);
	GLvar->global_timeadjustment = ((float)newTimer-oldTimer)/20;
	
	if (GLvar->global_timeadjustment > 10) 
	{
		GLvar->global_timeadjustment=10;
	}
	
	oldTimer = newTimer;
	globalList->move()	;
#ifndef PI
#define PI=3.151592653589793
#endif
	benchFrames++;

	benchPeriod+=.01*GLvar->global_timeadjustment;
	if (benchPeriod>4*PI) {
		benchPeriod-=4*PI;
	}
//	printf("%d\n", benchPeriod);
	switch (benchState) {
		case 0:	
			benchFrames=0;
			benchTime=glutGet((GLenum)(GLUT_ELAPSED_TIME));
			for (i=-4;i<=4;i++) {

				newOne = new TacheBench(globalList, i*2.7, 100);
				globalList->Add(newOne);
			}
			benchState = 1;				
			break;
		case 1:	
			
			if (globalList->get_mfirst()==NULL ) {
				glEnable(GL_LIGHTING);
				benchState=4;
				benchTime=glutGet((GLenum)(GLUT_ELAPSED_TIME))-benchTime;
				printf("+---------------------------------+\n");
				printf("|  GLAXIUM BENCHMARK RESULT  (v1) |\n");
				printf("+---------------------------------+\n");
				if (GLvar->bNVExtension) {
					printf(">> NVidia extensions version\n");
				} else if (GLvar->bEXTEnvDot3) {
					printf(">> EXT combine & dot3 version\n");
				} else {
					printf(">> One texture unit version\n");
				}
				printf(">> %d frames in %f sec\n", benchFrames, (float)benchTime/1000.0);
				sprintf(strFinalResult, "Average FPS: %d",  (int)1000.0*benchFrames/benchTime);
				printf(">> average FPS : %f \n", (float)1000.0*benchFrames/benchTime);
				printf("+----------------------------+\n");
			
			}
			break;
		case 4:	
		{


			// SHOULD BE FINISHED BY MAIN
			break;
		}
				
	}

}

void Scene::drawFPSBench() 
{
	static char tmp[20]="FPS: 0";
	int i;
	int diff;
	static int fps = 0;
	static int cpt =0;  
	

	//   glMaterialfv(GL_FRONT,GL_AMBIENT, GLvar->blanc_diffuse);
	//   glMaterialfv(GL_FRONT,GL_DIFFUSE,GLvar->blanc_diffuse);
	

	diff = (dt > 0) ? dt : 1;
	
	cpt++;
	if (cpt==10)
	{
		cpt=0;
		timediff();
		fps = 10000 / dt;
		
		sprintf(tmp, "FPS: %d", fps);
	}
	drawText(.01,.95, 0,tmp, 10);
}


/*******************************
 **     MENU                  ** 
 *******************************/

static bool hideMenu = false;
static int menuSelected = 0;
static char infos[][128] = {"Texture filtering: Trilinear", "0", "Details level: High", "0"};

void Scene::drawMenu()
{
	static char optionsChars[] = "OPTIONS";
	static char hideChars[] = "H to hide / Esc to go back";
	int i, j;

	if (infos[1][0]=='0') {
		sprintf(infos[1],"Anisotropic texturing: %d", (int)GLvar->fMaxAnis);
	}
	if (infos[3][0]=='0') {
		sprintf(infos[3],"Shadows: %s", (GLvar->bShadows? "On":"Off"));
	}

	if (GLvar->bShadows==true) {    
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	} else {
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	}
	
	glViewport(0,0,GLvar->width ,GLvar->height);

	glMatrixMode(GL_PROJECTION);

	glLoadIdentity();
	gluPerspective(50, 1.333333 , 2.0, 160);
	// Important part !    
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	camX = 4;
	camY = 5;
	camZ = -2;
	gluLookAt(	10, 2, 6,
				10,  .4 , 20,
				0, 1, 0);
	// c[8] : Spaceship position
#if defined( GL_REGISTER_COMBINERS_NV) && defined(GL_VERTEX_PROGRAM_NV)
	if (glProgramParameter4fNV!=NULL) {
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 8, 0, 3.5 , 10, 1);	
		// c[11] : camera position
		glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV, 11, camX, camY, camZ,1);	
	}
#endif	
	
	glPushMatrix();
	
	glColor4f(1.0, 1.0, 1.0 , 1);


	drawSky();
	
	if (GLvar->bShadows==true) {
		
		
		glEnable(GL_STENCIL_TEST);
		glStencilFunc(GL_ALWAYS, 1,1);
		glStencilOp(GL_REPLACE,GL_REPLACE,GL_REPLACE);
		
		drawFloor();
		
		glDisable(GL_STENCIL_TEST);    
		glEnable(GL_LIGHTING);
	} else {
		glEnable(GL_LIGHTING);
		drawFloor();
	}
	
	glPopMatrix();
	
	globalList->draw();
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);   
	if (GLvar->bShadows==true) {    
		glEnable(GL_STENCIL_TEST);    
		glStencilFunc(GL_EQUAL, 1, 1);
		glStencilOp(GL_ZERO,GL_ZERO,GL_ZERO);
		//        glDepthMask(GL_TRUE);
		
		glMultMatrixf(GLvar->shadowMatrix);
		
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		
		glEnable(GL_POLYGON_OFFSET_FILL);
		glPolygonOffset(-1.0,1.0);
		glColor4f(0,0,0,.35);
		
		globalList->drawShadows();
		
		glDisable(GL_POLYGON_OFFSET_FILL);
		
		glDisable(GL_STENCIL_TEST);    
	}
	
//	globalList->collision();
	// INFORMATIONS
	glDisable(GL_LIGHTING);

	if( !hideMenu) {
		glMatrixMode(GL_PROJECTION);

		glLoadIdentity();
		glOrtho(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f);
		
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();

		glDepthFunc(GL_ALWAYS);
		glDisable(GL_TEXTURE_2D);
		glColor4f(.3,0,0, .8);
		glBegin(GL_QUADS) ;
		{
			glVertex3f(.3,.95,0);
			glVertex3f(.3,.6,0);
			glVertex3f(.7,.6,0);
			glVertex3f(.7,.95,0);
		}
		glEnd();

		glEnable(GL_TEXTURE_2D);

		drawText(.43, .9, 0,optionsChars, 12, 1,.3,.3);
		drawText(.38, .88,0, hideChars, 7, 1,.7,.3);
	
		for (j=0; j<4; j++) {
			drawText(.32, .8-.05*j,0, infos[j], 8);
		}
		glDisable(GL_TEXTURE_2D);
		glColor4f(1,1,0,1);
		glBegin(GL_TRIANGLES) ;
		{
			glVertex3f(.28,.8 - menuSelected*.05+.007,0);
			glVertex3f(.30,.8 - menuSelected*.05+.016,0);
			glVertex3f(.28,.8 - menuSelected*.05+.025,0);
		}
		glEnd();
		glDepthFunc(GL_LEQUAL);
	}	// else {
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
	
	// TEXT
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 1.0f);

	glDepthFunc(GL_ALWAYS);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);

	drawFPSBench();


	glDepthFunc(GL_LEQUAL);

		//	}

	globalList->cleanList();


	SDL_GL_SwapBuffers();
	
	if ((glError=glGetError())!=GL_NO_ERROR) {
		printf("OpenGL error : %s\n", gluErrorString(glError));
	}
}
void changeAllTexturesAnis(int anisValue) {
	int i;
    for (i=0; i<5; i++) {
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_floor[i]);
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  anisValue);
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_floorMap[i]);
		glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  anisValue);
	}
	glBindTexture(GL_TEXTURE_2D, GLvar->texture_border);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  anisValue);
}

void changeTexture(int tex, GLenum mag, GLenum min) {
	glBindTexture(GL_TEXTURE_2D, tex);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, mag);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, min); 
}
void changeAllTextures(GLenum mag, GLenum min) {
	int i;
	for (i=0; i<5; i++) {
		changeTexture( GLvar->texture_floor[i], mag, min);
		changeTexture( GLvar->texture_floorMap[i], mag, min);
	}
	changeTexture( GLvar->texture_border, mag, min);
	changeTexture( GLvar->texture_mark, mag, min);
	changeTexture( GLvar->texture_tache, mag, min);
	changeTexture( GLvar->texture_fumee[0], mag, min);
	changeTexture( GLvar->texture_fumee[1], mag, min);
	changeTexture( GLvar->texture_fumee[2], mag, min);       
    for (i=0; i< SPACE;i++) {
        changeTexture(GLvar->texture_space[i],mag, min);
    }

}

void Scene::menuIdle() 
{
	static TacheBench *newOne;
	static int oldTimer =  glutGet((GLenum)(GLUT_ELAPSED_TIME));
	static int benchFrames;
	static int benchTime;
	static Uint8 *keys;
	static int anisValue = (int)GLvar->fMaxAnis;
	static int filterValue = 2;
	static int detailValue = 2;
	static char filterChars[][64] = {"Basic Mipmap", "Bilinear", "Trilinear"};
	static char detailChars[][64] = {"Low", "Medium", "High"};
	static bool optionsLoaded = false;
	int newTimer = glutGet((GLenum)(GLUT_ELAPSED_TIME));
	int i;
	bool anisChanged = false;
	bool filterChanged = false;
	bool detailChanged = false;
	bool shadowChanged = false;
	

	if (!optionsLoaded) {
		optionsLoaded = true;
		FILE *fOptions = fopen(GLvar->getFullOptionsPath(), "r");
		if (fOptions != NULL) {
			int nshadows;
			fscanf(fOptions, "%d %d %d %d", &filterValue, &anisValue, &detailValue, &nshadows);
			GLvar->bShadows = (nshadows==1);
			fclose(fOptions);
		}
		sprintf(infos[3],"Shadows: %s", (GLvar->bShadows? "On":"Off"));
		sprintf(infos[0], "Texture filtering: %s", filterChars[filterValue]);
		sprintf(infos[1],"Anisotropic texturing: %d", anisValue);
		sprintf(infos[2],"Details level: %s", detailChars[detailValue]);
	}

//	  printf("%d : %f\n",newTimer, GLvar->global_timeadjustment);
	GLvar->global_timeadjustment = ((float)newTimer-oldTimer)/20;
	
	if (GLvar->global_timeadjustment > 10) 
	{
		GLvar->global_timeadjustment=10;
	}
	
	oldTimer = newTimer;
	globalList->move()	;
#ifndef PI
#define PI=3.151592653589793
#endif
	benchFrames++;

	benchPeriod+=.01*GLvar->global_timeadjustment;
	if (benchPeriod>4*PI) {
		benchPeriod-=4*PI;
	}
//	printf("%d\n", benchPeriod);
	switch (benchState) {
		case 0:	
			benchFrames=0;
			benchTime=glutGet((GLenum)(GLUT_ELAPSED_TIME));
			for (i=-2;i<=2;i++) {

				newOne = new TacheBench(globalList,	i*5.0, 200);
				globalList->Add(newOne);
			}
			benchState = 1;				
			break;
		case 1:
			{
				if (globalList->get_mfirst()==NULL) {
					benchState=0;
				}
				
				keys = SDL_GetKeyState(NULL);
				if (keys[SDLK_UP] && bKeyDown) {
					menuSelected = menuSelected-1;
					if( menuSelected<0) menuSelected=3;
				}
				if (keys[SDLK_DOWN] && bKeyDown) {
					menuSelected = menuSelected+1;
					if( menuSelected>3) menuSelected=0;
				}
				if (keys[SDLK_h] && bKeyDown) {
					hideMenu = (hideMenu? false:true);
				}

				if (keys[SDLK_RIGHT] && bKeyDown) {
					switch (menuSelected) {
					case 0:
						filterValue ++ ;
						if (filterValue>2) filterValue= 0;
						filterChanged = true;
						break;

					case 1:
						if (GLvar->fMaxAnis!=0) {
							anisValue *=2 ;
							if (anisValue>GLvar->fMaxAnis) anisValue= 1;
							anisChanged = true;
						}
						break;
					case 2:
						detailValue ++ ;
						if (detailValue>2) detailValue= 0;
						detailChanged = true;
						break;
					case 3:
						GLvar->bShadows = (GLvar->bShadows? false:true);
						sprintf(infos[3],"Shadows: %s", (GLvar->bShadows? "On":"Off"));
						shadowChanged = true;
						break;
					}
				}
				if (keys[SDLK_LEFT] && bKeyDown) {
					switch (menuSelected) {
					case 0:
						filterValue -- ;
						if (filterValue<0) filterValue= 2;
						filterChanged = true;
						break;
					case 1:
						if (GLvar->fMaxAnis!=0) {
							anisValue /=2 ;
							if (anisValue<1) anisValue= (int)(GLvar->fMaxAnis);
							anisChanged = true;
						}
						break;
					case 2:
						detailValue -- ;
						if (detailValue<0) detailValue= 2;
						detailChanged = true;
						break;
					case 3:
						GLvar->bShadows = (GLvar->bShadows? false:true);
						shadowChanged = true;
						sprintf(infos[3],"Shadows: %s", (GLvar->bShadows? "On":"Off"));
						break;

					}
				}
				
				if (filterChanged) {
					sprintf(infos[0], "Texture filtering: %s", filterChars[filterValue]);
					switch (filterValue) {
					case 0:
						changeAllTextures(GL_NEAREST, GL_NEAREST_MIPMAP_NEAREST);
						break;
					case 1:
						changeAllTextures(GL_LINEAR, GL_LINEAR_MIPMAP_NEAREST);
						break;
					case 2:
						changeAllTextures(GL_LINEAR, GL_LINEAR_MIPMAP_LINEAR);
						break;
					}
				}
				if (anisChanged) {
					sprintf(infos[1],"Anisotropic texturing: %d", anisValue);
					changeAllTexturesAnis(anisValue);
				}

				if (detailChanged) {
					sprintf(infos[2],"Details level: %s", detailChars[detailValue]);
					GLvar->details = detailValue;
				}
				if (detailChanged || anisChanged || filterChanged || shadowChanged) {
					FILE *fOptions = fopen(GLvar->getFullOptionsPath(), "w+");
					if( fOptions!=NULL) {
						fprintf(fOptions, "%d %d %d %d", filterValue, anisValue, detailValue, GLvar->bShadows?1:0);
						fclose(fOptions);
					}
				}
			}
			break;
		case 4:	
		{
			// SHOULD BE FINISHED BY MAIN
			break;
		}			
	}
}




