/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/glut.h>

#include "spirale.hpp"
#include "fire.hpp"



Spirale::Spirale(List *list, int speed, float x,Sprite *toShot)
: Sprite(list,TYPE_SPIRALE ,(random()%22)-11,(random()%10)+10,50), destX_(toShot->getX()), destZ_(toShot->getZ()), destY_(toShot->getY())
{
    
    float dz = destZ_+3 -z_, 
        dy = destY_-y_, 
        dx = destX_-x_;
    
    float tot = sqrt((float)sqrt(dx*dx+dy*dy)+dz*dz)*2;
    //  float tot2;
    
    
    dx_ = dx / (tot);
    dy_ =dy / (tot);
    dz_ =dz / (tot);
    
    
    state_=NORMAL;
    //  dzInit_ = dz_ = -(float)((float)(speed)/100);
    sizex_ = 1;
    sizey_ = 1;
    sizez_ = 1;
    tetay_=random()%90;
    dtetay_=0;
    
    
}

void Spirale::drawShadowable()
{
    glPushMatrix();
    glTranslatef(x_,y_,z_);
    glRotatef(tetay_,0,0,1);
    glBegin(GL_TRIANGLE_FAN);
    glVertex3f(0,0,-.5);
    glVertex3f(0,.5,.5);
    glVertex3f(.1,.1,.5);
    glVertex3f(.5,0,.5);
    glVertex3f(.1,-.1,.5);
    glVertex3f(0,-.5,.5);
    glVertex3f(-.1,-.1,.5);
    glVertex3f(-.5,0,.5);
    glVertex3f(-.1,.1,.5);
    glVertex3f(0,.5,.5);
    glEnd();
    glPopMatrix();
}

void Spirale::draw()
{
    
    glPushMatrix();
    
    glTranslatef(x_,y_,z_);
    
    glRotatef(tetay_,0,0,1);
    
    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->bleu_diffuse);
    glDisable(GL_TEXTURE_2D);
    glBegin(GL_TRIANGLE_FAN);
    
    glNormal3f(1,0,0);
    glVertex3f(0,0,-.5);
    
    glVertex3f(0,.5,.5);
    glVertex3f(.1,.1,.5);
    
    glNormal3f(0,1,0);
    
    glVertex3f(.5,0,.5);
    
    glNormal3f(0,-1,0);
    
    glVertex3f(.1,-.1,.5);
    
    glNormal3f(1,0,0);
    
    glVertex3f(0,-.5,.5);
    glNormal3f(-1,0,0);
    glVertex3f(-.1,-.1,.5);
    glNormal3f(-1,0,0);
    
    
    glVertex3f(-.5,0,.5);
    
    glNormal3f(0,1,0);
    
    glVertex3f(-.1,.1,.5);
    
    glNormal3f(0,-1,0);
    
    glVertex3f(0,.5,.5);
    glEnd();
    glEnable(GL_TEXTURE_2D);
    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->blanc_diffuse);
    glPopMatrix();
}



void Spirale::move()
{  
    tetay_ +=(10*GLvar->global_timeadjustment)>20?20:10*GLvar->global_timeadjustment;
    
    
    Sprite::move();
    
    if (y_<.5)
    {
        dy_=0;
        dx_=0;
        y_=.5;
    }
    
    if (z_ < -2)
    {
        dead_=1;
    }
}


void Spirale::collision(Sprite*contact)
{
    switch(contact->getType())
    {
    case TYPE_MY_FIRE1:
    case TYPE_MY_FIRE2:
    case TYPE_BANDIT2:
    case TYPE_SHIP1:
    case TYPE_MY_SPACE_SHIP:
    case TYPE_CUBE:
    case TYPE_TANK:
        contact->score(30);
        {
           if (dead_==0) {
            Explosion *explode;
            explode = new Explosion(this,2);
            mlist->Add(explode);
            dead_=1;
            break;
           }
        }
    }
}

