/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __SPRITE__
#define __SPRITE__

#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glu.h>
#include <GL/glut.h>

#ifndef WIN32
#include "conf.h"
#endif

#include "variables.hpp"
#include "elem.hpp"
#include "list.hpp"

#define MAX_LISTENING 5

enum enum_state {
    NOT_STARTED=1,
        NORMAL,
        UNTOUCHABLE,
        MOVING,
        TOUCHING,
        DEAD
} ;

class Sprite : public  Elem {
    friend class ListSprite;
public:
    
    enum type_sprites {
        TYPE_MY_SPACE_SHIP=1,
            TYPE_MY_FIRE1,
            TYPE_MY_FIRE2,
            TYPE_MY_FIRE4,
            TYPE_WALL,
            TYPE_ENEMY1,
            TYPE_CUBE,
            TYPE_EXPLOSION,
            TYPE_PIECEOFSHIP,
            TYPE_SHIP1,
            TYPE_FIRE_SHIP1,
            TYPE_SPIRALE,
            TYPE_PIEGE,
            TYPE_POTO,
            TYPE_TANK,
            TYPE_FIRE_TANK,
            TYPE_SCRATCHER,
            TYPE_TACHE,
            TYPE_BANDIT2,
            TYPE_FIRE_BANDIT2,
            TYPE_DIAMOND,
            TYPE_SMOKE,
            TYPE_UNDEF
    } ;
    // Constructor
    Sprite(List *list);
    Sprite(List *list, type_sprites type, float x, float y, float z);
    // Destructor
    virtual ~Sprite() {}
    // Methods
    virtual void draw()=0;
    virtual void collision(Sprite *)=0;
    virtual void move();
    virtual void drawShadowable() {}
    
    virtual float getX() { return x_; }
    virtual float getY() { return y_; }
    virtual float getZ() { return z_; }
    float getDx() { return dx_; }
    float getDy() { return dy_; }
    float getDz() { return dz_; }
    float getSizeX() { return sizex_; }
    float getSizeY() { return sizey_; }
    float getSizeZ() { return sizez_; }
    type_sprites getType() { return type_; }
    int isDead() {return dead_;}
    
    
    void PlaySample(type_samples sampleToPlay,int volume=128);
    void SpritePlaySample(type_samples sampleToPlay,int volume=128);
    
    bool addListeningSprite(Sprite*toAdd);
    void removeListeningSprite(Sprite*toRemove);
    virtual void score(int toAdd) {};
    virtual void iJustDied();
    virtual void receiveEvent(Sprite*sprite);
protected:
    Sprite *listeningSprite[MAX_LISTENING];
    int nListeningSprite;
    type_sprites type_;
    float x_;
    float y_;
    float z_;
    float dx_;
    float dy_;
    float dz_;
    float sizex_;
    float sizey_;
    float sizez_;
    int dead_;
    // The following one is true for the
    // the enemy which can be followed by a missile.
    bool bRealEnemy;
};

#endif






