/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <GL/glut.h>

#include "tache.hpp"
#include "scratcher.hpp"



Tache::Tache(List *list, float x, int power) 
: Sprite(list,TYPE_TACHE ,x,0,73)
{
    int i;
	power_= power;
    state_=NORMAL;
    dzInit_ = dz_ = -.1;
    sizex_ = 1;
    sizey_ = 1;
    sizez_ = 1;
    tetay_=random()%90;
    for (i=0;i<5;i++)
    {
        zDetails[i] = 0.1;
    }
}


void Tache::draw()
{
    
    glPushMatrix();
    
    glTranslatef(x_,y_,z_);
    if (tetay_)
       glRotatef(tetay_,0,1,0);
       
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA , GL_ONE_MINUS_SRC_ALPHA);
    
	glEnable(GL_ALPHA_TEST);
    glAlphaFunc(GL_GEQUAL, 0.3);    

	if (state_==NORMAL) {
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_tache);
	} else {
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_deadtache);
	}
    
    //  glMaterialfv(GL_FRONT,GL_DIFFUSE,blanc_diffuse);
    glMaterialfv(GL_FRONT,GL_EMISSION,GLvar->jaune_diffuse);
    
    glBegin(GL_TRIANGLE_FAN);
    
    glTexCoord2f(.5, .5);
    glVertex3f(0,.5+zDetails[0],0);
    
    glTexCoord2f(.4, .4);
    glVertex3f(-.25,.25+zDetails[1],-.25);
    glTexCoord2f(.4, .6);
    glVertex3f(-.25,.25+zDetails[2],+.25);
    glTexCoord2f(.6,.6);
    glVertex3f(.25,.25+zDetails[3],+.25);
    glTexCoord2f(.6,.4);
    glVertex3f(.25,.25+zDetails[4],-.25);
    glTexCoord2f(.4, .4);
    glVertex3f(-.25,.25+zDetails[1],-.25);
    
    glEnd();
    
    glBegin(GL_TRIANGLE_STRIP);
    
    glTexCoord2f(.6, .6);
    glVertex3f(.25,.25+zDetails[3],.25);
    glTexCoord2f(1, 1);
    glVertex3f(1.5,.02 , 1.5);
    
    glTexCoord2f(.6, .4);
    glVertex3f(.25,.25+zDetails[4],-.25);
    glTexCoord2f(1, 0);
    glVertex3f(1.5,.02 , -1.5);
    
    glTexCoord2f(.4, .4);
    glVertex3f(-.25,.25+zDetails[1],-.25);
    glTexCoord2f(0, 0);
    glVertex3f(-1.5,.02 , -1.5);
    
    glTexCoord2f(.4, .6);
    glVertex3f(-.25,.25+zDetails[2],.25);
    glTexCoord2f(0, 1);
    glVertex3f(-1.5,.02 , 1.5);
    
    glTexCoord2f(.6, .6);
    glVertex3f(.25,.25+zDetails[3],.25);
    glTexCoord2f(1, 1);
    glVertex3f(1.5,.02 , 1.5);
    
    glEnd();
    
    
    glMaterialfv(GL_FRONT,GL_EMISSION,GLvar->noir_diffuse);
    
    glDisable(GL_BLEND);
    glDisable(GL_ALPHA_TEST);
    
    glPopMatrix();
    
}



void Tache::move()
{
    
    int i;
    
	if (state_==NORMAL) {
		for (i=0;i<5;i++)
		{
			float zDD= (float) ((random()%16)/256.0) -.03125;
			zDetails[i] +=zDD;
			
			if (zDetails[i]<0.0)
			{
				zDetails[i]=0.0;
			}
			if (zDetails[i]>0.2)
			{
				zDetails[i]-=0.01;
			}
		}
		
		
		if (GLvar->myRandom(200))
		{
			SpritePlaySample((type_samples)(SAMPLE_TACHEFIRE ));
			Scratcher* newScratcher = new Scratcher(mlist,x_,z_);
			mlist->Add(newScratcher);
			//  dtetay_ = 3*GLvar->global_timeadjustment;
			zDetails[0]+=.5;
		}
		
	}
    dz_=-.1;   
    
    Sprite::move();
    
    if (z_<-3)
    {
        dead_=1;
    }
}





void Tache::collision(Sprite*contact)
{
    switch(contact->getType())
    {
    case TYPE_MY_FIRE2:
		power_=0;
    case TYPE_MY_FIRE4:
		power_-=2;
        if (power_<=0 && state_==NORMAL) {
			Explosion *explode;
			explode= new Explosion(this,4,0);
			mlist->Add(explode);
	        state_ = DEAD;
			zDetails[0] = -.2;
		    for (int i=1;i<5;i++)
			{
				zDetails[i] = -.1;
			}
            contact->score(100);
		}
        break;
	default:
		break;
    }
}


// ======== Benchmark ==========

TacheBench::TacheBench(List *list, float x, float p) 
: Tache(list, x,1)
{
    period_=p;
	timer_=0;
}

void TacheBench::move()
{
    
    int i;
    
    for (i=0;i<5;i++)
    {
        float zDD= (float) ((random()%16)/256.0) -.03125;
        zDetails[i] +=zDD;
        
        if (zDetails[i]<0.0)
        {
            zDetails[i]=0.0;
        }
        if (zDetails[i]>0.2)
        {
            zDetails[i]-=0.01;
        }
    }
    
	timer_ += GLvar->global_timeadjustment;

    if (timer_>period_)
    {
		timer_ -= period_;
        SpritePlaySample((type_samples)(SAMPLE_TACHEFIRE ));
        Scratcher* newScratcher = new Scratcher(mlist,x_,z_,1);
        mlist->Add(newScratcher);
        zDetails[0]+=.5;
    }
    
    
    dz_=-.1;
    
    
    Sprite::move();
    
    if (z_<-3)
    {
        dead_=1;
    }
}
