/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <GL/glut.h>

#include "diamond.hpp"

#include "modeles/capsule.c"


int Diamond::list_;


Diamond::Diamond(Sprite *sprite)
        : Sprite(sprite->getList(),TYPE_DIAMOND ,sprite->getX(),sprite->getY(),sprite->getZ())
    {
   		int type;
		if (GLvar->mySpaceShip!=NULL && GLvar->mySpaceShip->powerUp_>=7) 
			type = random()%3;
		else 
			type = random()%4;

        dz_ = -.1;
        tetay_=0 ;
        dtetay_=3.0;
		y_=.1;
		switch(type) {
		case 0:
			type_= BOMB;
			sizex_ = 1;
			sizey_ = 1;
			sizez_ = 1;
			break;
		case 1:
			type_= POWER;
			sizex_ = 1;
			sizey_ = 1;
			sizez_ = 1;
			break;
		case 2:
			type_= INVUL;
	        sizex_ = 1;
		    sizey_ = 1;
			sizez_ = 1;
			break;
		case 3:
			type_= POWERUP;
	        sizex_ = 1.6	;
            sizey_ = 1.6	;
            sizez_ = 1.6	;
			break;
		}
    }


void Diamond::initList()
{
     int i,j;
	 // average normal.....
	 int nbVertex = 120*3;
	 int *bTested = new int[nbVertex];
	 for (i=0;i<nbVertex;i++) {
		 bTested[i] = 0;
	 }
	 int nb;
	 GLfloat aNormal[3];
	 for (i=0;i<nbVertex;i++) {
		 if (bTested[i]==0) {
			 bTested[i] = 2;
			 nb=1;
			 aNormal[0] = capsule_meshes[i*8+3];
			 aNormal[1] = capsule_meshes[i*8+4];
			 aNormal[2] = capsule_meshes[i*8+5];
			 for (j=i+1;j<nbVertex;j++) {
				 if ((bTested[j]==0) && ((capsule_meshes[i*8+0]-capsule_meshes[j*8+0])<.01)  && ((capsule_meshes[i*8+1]-capsule_meshes[j*8+1])<.01) && ((capsule_meshes[i*8+2]-capsule_meshes[j*8+2])<.01) && ((capsule_meshes[i*8+0]-capsule_meshes[j*8+0])>-.01)  && ((capsule_meshes[i*8+1]-capsule_meshes[j*8+1])>-.01) && ((capsule_meshes[i*8+2]-capsule_meshes[j*8+2])>-.01) ) {
					 bTested[j]=2;
					 nb++;
					 aNormal[0]+= capsule_meshes[j*8+3];
					 aNormal[1]+= capsule_meshes[j*8+4];
					 aNormal[2]+= capsule_meshes[j*8+5];
				 }
			 }
			 aNormal[0] /= nb;
			 aNormal[1] /= nb;
			 aNormal[2] /= nb;
			 for (j=i;j<nbVertex;j++) {
				 if (bTested[j]==2)  {
					 capsule_meshes[j*8+3] = aNormal[0];
					 capsule_meshes[j*8+4] = aNormal[1];
					 capsule_meshes[j*8+5] = aNormal[2];
					 bTested[j]=1;
				 }
			 }	 
		 }
	 }
   
    
    for (i=0;i<120;i++) {
        capsule_meshes[i*24+7] = 1 - capsule_meshes[i*24+7];
        capsule_meshes[i*24+7+8] = 1 - capsule_meshes[i*24+7+8];
        capsule_meshes[i*24+7+16] = 1 - capsule_meshes[i*24+7+16];
        
    }

    list_ = glGenLists(1);
    
    glNewList(list_,GL_COMPILE);
    {
        glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_NORMAL_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        glVertexPointer(3,GL_FLOAT,32,capsule_meshes); 
        glNormalPointer(GL_FLOAT,32,capsule_meshes+3); 
        glTexCoordPointer(2,GL_FLOAT,32,capsule_meshes+6);
        
        glDrawArrays(GL_TRIANGLES,0,119*3+2);
        
        glDisableClientState(GL_VERTEX_ARRAY);
        glDisableClientState(GL_NORMAL_ARRAY);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
    }
    glEndList();
}

void Diamond::drawShadowable() {
    glPushMatrix();
    
    glTranslatef(x_,y_,z_);
    glRotatef(tetay_,0,1,0);

	if (type_==POWERUP)   {
        glScalef(sizex_,sizey_,sizez_);
    } else if (type_==INVUL) {
        glScalef(1.3,.7,1.3);
	}
    glCallList(list_);
    glPopMatrix();
}

void Diamond::draw()
{
    
    glPushMatrix();
    
    glTranslatef(x_,y_,z_);
    glRotatef(tetay_,0,1,0);

    glBindTexture(GL_TEXTURE_2D,  GLvar->texture_capsule[type_]);
	if (type_==POWERUP)   {
        glScalef(sizex_,sizey_,sizez_);
    } else if (type_==INVUL) {
        glScalef(1.2,.85,1.2);
	}
    glCallList(list_);
    glPopMatrix();
}



void Diamond::move()
{
    tetay_ +=dtetay_*GLvar->global_timeadjustment;
    
    //  printf("global_timeadjustment : %f\n", global_timeadjustment);
    Sprite::move();
    
    if (type_==POWERUP && z_<40) {
       sizex_ -= .007*GLvar->global_timeadjustment;
       sizey_ = sizez_ = sizex_;
       if (sizex_<=0) 
          dead_=1;
    }

    if (z_<-3)
    {
        dead_=1;
    }
}


void Diamond::collision(Sprite*contact)
{
    switch(contact->getType())
    {
    case TYPE_MY_SPACE_SHIP:
        {
            contact->score(500);
            dead_=1;
            break;
        }
    case TYPE_MY_FIRE1:
       {
          // Never go back to powerup...
          switch (type_) {
          case POWER:
             type_=BOMB;
             break;
          case BOMB:
             type_=POWER;
             break;
          }
          break;
       }
    }
}
