/*
  Copyright (C) 2000/2001 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifdef WIN32
#include <windows.h>
#endif


#include <signal.h>
#include <stdlib.h>
#include <GL/gl.h>       
#include <GL/glu.h>      
#include <GL/glut.h>
#include <stdio.h>
#include <string.h>

#include "SDL.h"


#include "variables.hpp"
#include "scene.hpp"
#include "myship.hpp"
#include "tank.hpp"

GlaxiumVariables* GLvar ;
Scene* scene;


int game=0;


/*
 * void reshape
 *
 * The screen size has been changed
 */

void reshape(int w, int h)
{
    GLvar->width = w;
    GLvar->height = h;

}


bool bKeyDown;    

int main( int argc, char *argv[] )
{
    SDL_Surface *screen;
    int done;
    SDL_Event event;
    Uint8 *keys;
    int fullscreen=0;
    int i;
    int width = 800, height = 600;
    int keyA=0;
    int keyZ=0;
	int cheatCode = 0;

#ifdef WIN32
	fullscreen=1;
#endif
	

    /*        for (i=0;i<30;i++) {
    printf("Random () %d \n", random());
    }
    */
    
	bool bExp2Fog=false;
	bool bShadows=true;
	bool bStars=true;
    for (i=1; i<argc;i++) {
        if (!strcmp(argv[i],"-f")) {
            fullscreen=1;
        } else if (!strcmp(argv[i],"-w")) {
            fullscreen=0;
        } else if (!strcmp(argv[i],"-e")) {
            bExp2Fog=true;
        } else if (!strcmp(argv[i],"-nsh")) {
            bShadows=false;
        } else if (!strcmp(argv[i],"-nst")) {
            bStars=false;
        } else if (!strcmp(argv[i],"-1")) {
            width=512;
            height=384;
        } else if (!strcmp(argv[i],"-2")) {
            width=640;
            height=480;
        } else if (!strcmp(argv[i],"-3")) {
            width=800;
            height=600;
        } else if (!strcmp(argv[i],"-4")) {
            width=1024;
            height=768;
        }
        else {
            
            printf("Glaxium ");
#ifdef GLAX_VERSION
            printf("%s",GLAX_VERSION);
#endif
            printf("\n");
            
            printf("Usage : glaxium <Options>\n");
            printf("Options   -f : fullscreen (default uder windows) \n");
            printf("          -w : window (default under Linux)\n"); 
            printf("          -1 : set to 512x384 pixels\n"); 
            printf("          -2 : set to 640x480 pixels\n"); 
            printf("          -3 : set to 800x600 pixels (default)\n"); 
            printf("          -4 : set to 1024x768 pixels\n"); 
            printf("          -e : use exp2 fog instead of linear (if fog does'nt work for you)\n"); 
            printf("          -nsh : force no shadow (speeds up)\n"); 
            printf("          -nst : no stars (speeds up)\n"); 
            exit(12);
        }
    }
    
    
    if (SDL_Init(SDL_INIT_JOYSTICK | SDL_INIT_VIDEO | SDL_INIT_AUDIO )) {
        printf("SDL initialisation ERROR\n");
    }
/*    
    atexit(CleanUp);
    signal(SIGINT, exit);
    signal(SIGTERM, exit);
  */  
//    glutInit(&argc, argv);
    
    SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE,8);

    if (fullscreen) {
        screen = SDL_SetVideoMode(width, height, 0, SDL_OPENGL|SDL_FULLSCREEN);
        if (screen==NULL) {
            printf("Cannot get full screen display\n");
            screen = SDL_SetVideoMode(width, height, 0, SDL_OPENGL|SDL_RESIZABLE);
        }
        SDL_ShowCursor(0);
    } else {
        screen = SDL_SetVideoMode(width, height, 0, SDL_OPENGL|SDL_RESIZABLE);
    }
    
    
    SDL_WM_SetCaption("Glaxium", "glaxium");
    if ( ! screen ) {
        fprintf(stderr, "Couldn't set %dx%d GL video mode: %s\n", width, height,SDL_GetError());
        SDL_Quit();
        exit(2);
    }
    
    int nDepth;
    SDL_GL_GetAttribute(SDL_GL_DEPTH_SIZE,&nDepth);
    printf("Depth buffer depth : %d\n",nDepth);
    if (nDepth>=24) {
       printf("Stencil buffer will be used for shadows.\n");
    }
    else {
       printf("No stencil buffer, no shadows. Try 32bits mode.\n");    
    }

    
    // Init GlaxiumVariables
    GLvar = GlaxiumVariables::getGlaxiumVariables();
	GLvar->initOptionsFile(nDepth>=24 && bShadows);
    scene = Scene::getScene();
    scene->initOpenGl();
	if (!bStars)
		scene->nStars=1;
    if (nDepth>=24 && bShadows) {
       GLvar->bShadows=true;    
    }
    else {
       GLvar->bShadows=false;
    }
    GLvar->initAllLists();
    GLvar->width=width;
    GLvar->height=height;
    // Init the scene
    if (bExp2Fog) 
		scene->toggleFog();
    reshape(screen->w, screen->h);
    done=0;
    while (!done) {
        
		switch(game) {
		case 1:
            scene->gameIdle();
			break;
        case 2:
            scene->benchIdle();
/*			if (scene->benchState==4) 
				game=0;

  */
			break;
		case 3:
            scene->menuIdle();
			break;
		default:
			scene->presentationIdle();
			break;
        }
        
        
        bKeyDown = false;
        while ( SDL_PollEvent(&event) ) {
            switch(event.type) {
            case SDL_KEYDOWN:
                bKeyDown = true;
                if (game==1 && GLvar->delay>100) {
                    game=0;
#ifdef HAVE_LIBSDL_MIXER
                    Mix_FreeMusic(GLvar->module1);
                    GLvar->module2 = Mix_LoadMUS(GLvar->getFullPath("samples/glax3.xm"));
                    Mix_PlayMusic(GLvar->module2,-1);
#endif
                } else if (game==0) {
                    glEnable(GL_BLEND);
                    glEnable(GL_TEXTURE_2D);
                    glEnable(GL_LIGHTING);
                    glEnable(GL_DEPTH_TEST);
			        keys = SDL_GetKeyState(NULL);
                    GLvar->delay=0;
                    delete scene->globalList;
                    scene->globalList = new ListSprite();
	
					if (keys[SDLK_F3]) {
						scene->benchState=0;
						scene->benchPeriod =0;
						game=2;
					} else if (keys[SDLK_F4]) {
						scene->benchState=0;
						scene->benchPeriod =0;
						game=3;
					} else if (keys[SDLK_ESCAPE]) {
						done=1;
					} else {              
						game=1;
	                    GLvar->mySpaceShip = new MyShip(scene->globalList,100);
		                scene->globalList->Add(GLvar->mySpaceShip);
						cheatCode=0;
	#ifdef HAVE_LIBSDL_MIXER
				        Mix_FreeMusic(GLvar->module2);
					    GLvar->module1 = Mix_LoadMUS(GLvar->getFullPath("samples/glax.xm"));
						Mix_PlayMusic(GLvar->module1,-1);
    #endif
					}
                }

                break;
            case SDL_VIDEORESIZE:
/*                screen = SDL_SetVideoMode(event.resize.w, event.resize.h, 16,
                    SDL_OPENGL|SDL_RESIZABLE);
                    */
                    reshape(event.resize.w, event.resize.h);
                break;
            case SDL_QUIT:
                done = 1;
                break;
            }
        }
        
        keys = SDL_GetKeyState(NULL);

        if (keys[SDLK_F1]) {
            GLvar->camera=1;
        }
        if (keys[SDLK_F2]) {
            GLvar->camera=2;
        }

        if (keys[SDLK_F5] && bKeyDown) {
            cheatCode +=100;
        }
        if (keys[SDLK_F6] && bKeyDown) {
            cheatCode +=10;
			if (cheatCode == 132) {
				printf("CHEATED !!! Bad boy !");
				GLvar->mySpaceShip->powerUp_=7;
			}
        }
        if (keys[SDLK_F7] && bKeyDown) {
            cheatCode +=1;
        }
        
        if ((keys[SDLK_p] || keys[SDLK_c])  && bKeyDown) {
            if (GLvar->global_pause) {
                GLvar->global_pause=0;
            } else {
                GLvar->global_pause=1;
            }
        }
        if (keys[SDLK_ESCAPE]  && bKeyDown) {
			switch(game) {
			case 0:
	            done = 1;
				break;
			case 1:
				if (GLvar->mySpaceShip!=NULL) {
					GLvar->mySpaceShip->setShield(-1);
				}
				break;
			default:
				//scene->benchState=4;
				game = 0;
				break;
			}
        }
        if (keys[SDLK_d] && bKeyDown) {
            scene->toggleDisplayFPS();
        }
        if (keys[SDLK_f] && bKeyDown) {
            scene->toggleFog();
        }
        if (keys[SDLK_g] && bKeyDown) {
            scene->toggleSpecular();
        }
        
        if (keys[SDLK_s] && bKeyDown) {
            if (GLvar->bShadows) {
                GLvar->bShadows=false;
            } else {
                GLvar->bShadows=true;
            }
        }
/*
		if (keys[SDLK_KP1]) {
            GLvar->mySpaceShip->powerUp_=1;
        }
        if (keys[SDLK_KP2]) {
            GLvar->mySpaceShip->powerUp_=2;
        }
        if (keys[SDLK_KP3]) {
            GLvar->mySpaceShip->powerUp_=3;
        }
        if (keys[SDLK_KP4]) {
            GLvar->mySpaceShip->powerUp_=4;
        }
        if (keys[SDLK_KP5]) {
            GLvar->mySpaceShip->powerUp_=5;
        }

        if (keys[SDLK_KP6]) {
            GLvar->mySpaceShip->powerUp_=6;
        }
        if (keys[SDLK_KP7]) {
            GLvar->mySpaceShip->powerUp_=7;
        }

        if (keys[SDLK_KP8]) {
            GLvar->mySpaceShip->powerUp_=8;
        }
*/
		switch(game) {
		case 1:
            scene->drawGame();
			break;
        case 2:
            scene->drawBench();
			break;
		case 3:
            scene->drawMenu();
			break;
		default:
            scene->drawPresentation();
			break;
        }

    }
    SDL_Quit();
    return 0;             /* ANSI C requires main to return int. */
}
