/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <GL/glut.h>

#include "scratcher.hpp"
#include "scene.hpp"

int Scratcher::m_nCubeList;

void createShadow(float size)
{
    float size2= size/2.0;
    float size21= size2*0.71;
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	//    glDepthMask(0);

    glBegin(GL_TRIANGLE_FAN);
    
    glColor4f(.8 , .8 , .3 , 1 - size/15); 
    glVertex3f(0,0,0);

    glColor4f(.3 , .3 , .3 , 0); 
    glVertex3f(size2,0,0);
    glVertex3f(size21,0,size21);
    glVertex3f(0,0,size2);
    glVertex3f(-size21,0,size21);
    glVertex3f(-size2,0,0);
    glVertex3f(-size21,0,-size21);
    glVertex3f(0,0,-size2);
    glVertex3f(size21,0,-size21);
    glVertex3f(size2,0,0);
   
    glEnd();

    glDisable(GL_BLEND);
    //glDepthMask(1);   
}





Scratcher:: Scratcher(List *list, float x, float z, int bench)
: Sprite(list,TYPE_SCRATCHER ,x,.3,z)
{
    float destX,destZ;
    Sprite* toShot=NULL;
    state_=NORMAL;
    sizex_ = .6;
    sizey_ = .6;
    sizez_ = .6;
    period_=0;
    
    if (mlist->First()) {
        do {
            if (((Sprite *)mlist->mcurrent)->getType()==TYPE_MY_SPACE_SHIP)
                toShot = (Sprite *)mlist->mcurrent;
            break;
        } while (mlist->Next());
    }
    
	if (bench==0) {
		if ((toShot==NULL)  || (!(random()%3)))
		{
			destX=(random()%48)/2.0-12;
			destZ=(random()%25)+2.0;
		}
		else
		{
			destX=toShot->getX();
			destZ=toShot->getZ();
		}
    } else {
        destX=x;
        destZ=25;
	}
    ddy_ = -0.005;
    dy_ = .3;
    
    float dz = destZ -z_;
    float dx = destX-x_;
    
    float dist = (float)sqrt(dx*dx+dz*dz);
    
    dx_ = dx /120;
    dz_ = dz /120;
    
}

void Scratcher::drawShadowable()
{
    glPushMatrix();
    glTranslatef(x_,y_,z_);
    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->rouge_diffuse);
    glCallList(m_nCubeList);
    glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,GLvar->blanc_diffuse);
    glPopMatrix();
}
void Scratcher::draw()
{
    drawShadowable();
    glPushMatrix();
    
	glBindTexture(GL_TEXTURE_2D, GLvar->texture_building);
    glTranslatef(x_+(random()/128000.0),0.05,z_+(random()/128000.0));
    createShadow(.7+y_/2);
    glPopMatrix();
}



void Scratcher::move()
{
    if (y_<0 && dy_<0)
    {
        dead_=1;
        y_=0.2;
        dy_=0;
        Explosion * explode;
        explode = new Explosion(this,5);
        mlist->Add(explode);
    }
    else
    {
        dy_+=ddy_*GLvar->global_timeadjustment;
        float toReach = (1 + (2-GLvar->details)*.7);
        if (period_>toReach) {
            ExplosionJustSmoke * explode;
            explode = new ExplosionJustSmoke(this, .75+(random()%128)/256.0f);
            mlist->Add(explode);   
            period_-=toReach;
        } else {
            period_+=GLvar->global_timeadjustment;
        }
    }
    
    Sprite::move();
    
}


void Scratcher::collision(Sprite*contact)
{
    static Explosion * explode;
    switch(contact->getType())
    {
    case TYPE_MY_FIRE1:
    case TYPE_MY_FIRE2:
        {
            explode = new Explosion(this,5);
            mlist->Add(explode);
            dead_=1;
            break;
        }
    }
    
}

void Scratcher::initList() {
    m_nCubeList = scene->createCube(.2);
}
