/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __SCRATCHER__
#define __SCRATCHER__


#include <stdlib.h>
#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"

class Scratcher : public Sprite {
public:
    enum enum_state {
        NORMAL,
            JUMPING,
            UNDEF
    } ;
    
    Scratcher:: Scratcher(List *list, float x, float z, int bench=0);
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);
    static void initList();
    float destx_,desty_,destz_;  
protected:
    int state_;
    float dzInit_;
    float period_;
    float ddy_;
    static int m_nCubeList;
};

#endif



