/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "sprite.hpp"

Sprite::Sprite(List *list) 
  : Elem(list)
{
  type_ = TYPE_UNDEF;
  sizex_ = sizez_ = dx_ = x_ = y_ = dy_ = z_ = dz_ = 0;
  dead_=0;
  bRealEnemy=false;
  for (int i=0; i<MAX_LISTENING; i++) {
    listeningSprite[i]=NULL;
  }
  nListeningSprite=0;
}
Sprite::Sprite(List *list, type_sprites type, float x, float y, float z)
  : Elem(list)
{ 
  type_= type;
  x_=x;
  y_=y;
  z_=z;
  sizex_ = sizez_ = dx_=dy_=dz_=0;
  dead_=0;
  bRealEnemy=false;
  for (int i=0; i<MAX_LISTENING; i++) {
    listeningSprite[i]=NULL;
  }
  nListeningSprite=0;
}

void Sprite::move()
{
  x_+=dx_*GLvar->global_timeadjustment;
  y_+=dy_*GLvar->global_timeadjustment;
  z_+=dz_*GLvar->global_timeadjustment;
}

    
#ifdef HAVE_LIBSDL_MIXER
void Sprite::SpritePlaySample(type_samples sampleToPlay,int volume) {
  if (z_<63) {
    int v=Mix_PlayChannel(-1,GLvar->samples[sampleToPlay], 0);
    Mix_Volume(v, (int)((63-z_)*2)*volume/128);
  }
}
void Sprite::PlaySample(type_samples sampleToPlay,int volume) {
  if (GLvar->samples[sampleToPlay])
    {
      int v=Mix_PlayChannel(-1,GLvar->samples[sampleToPlay], 0);
      Mix_Volume(v, volume);
    }
}
#else
  /* must exist because it has one or two parameters... 
     so no defined is possible. */
  void Sprite::SpritePlaySample(type_samples sampleToPlay,int volume) {
  }
  void Sprite::PlaySample(type_samples sampleToPlay,int volume) {
  }
#endif
    

bool Sprite::addListeningSprite(Sprite*toAdd) {
  bool ok=false;
  int i=0;
  do {
    if (listeningSprite[i]==NULL) {
      listeningSprite[i]=toAdd;
      ok=true;
      nListeningSprite++;
  //    printf("++ I'm 0x%x and i ADD 0x%x to my list position [%d]\n", this, toAdd,i);
    }
    i++;
  } while (i<MAX_LISTENING && !ok);
  return ok;
}

void Sprite::removeListeningSprite(Sprite*toRemove) {
  for (int i=0; i<MAX_LISTENING; i++) {
    if (listeningSprite[i]==toRemove) {
//      printf("-- I'm 0x%x and i REMOVE 0x%x from my list position [%d]\n", this, toRemove,i);
      listeningSprite[i]=NULL;
      nListeningSprite--;
      i=MAX_LISTENING;
    }
  }
}

void Sprite::iJustDied() {
  if (nListeningSprite==0) {
    return;
  }
  for (int i=0; i<MAX_LISTENING; i++) {
    if (listeningSprite[i]!=NULL) {
//      printf("#####   I'm 0x%x and i Tell 0x%x i'm dead\n", this,listeningSprite[i]);
      listeningSprite[i]->receiveEvent(this);
    }
  }
}

void Sprite::receiveEvent(Sprite*sprite) {
}






