/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __TACHE__
#define __TACHE__


#include <stdlib.h>
#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"

class Tache : public Sprite {
public:
    Tache(List *list, float x, int power);
    
    void draw();
    virtual void move();
    void collision(Sprite *);
    
protected:
    int state_;
	int power_;
    float dzInit_;
    float tetay_;
    float zDetails[5];
};

class TacheBench : public Tache {
public:
    TacheBench(List *list, float x, float p);
    void move();
protected :
	float period_;
	float timer_;
};


#endif



