/*
  Copyright (C) 2000/2002 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
	
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "sprite.hpp"
#include "listsprite.hpp"

#include "pngtex.hpp"
#include "myship.hpp"
#include "bandit2.hpp"
#include "fighter2.hpp"
#include "ship1.hpp"
#include "diamond.hpp"
#include "cube.hpp"
#include "scratcher.hpp"
#include "tank.hpp"
#include "fire.hpp"

GLfloat static_pos_space [] = { -35,0,-50,-15,90  ,  
45,-20,30,-35,60,
0,2,16,18, 90,
55,5,45,-5,90};

char  *static_fileSample[SAMPLE_UNDEF] = {
	"welcome.wav",
        "tir.wav",
        "explode1.wav",
        "explode2.wav",
        "tachefire.wav",
        "glups.wav",
        "powerup.wav",
        "detection.wav",
        "gameover.wav"
};

GLfloat slight_position[] = { 2, 5, -1, 0 };


GLfloat smat_ambient[] = { .5, .5, .5, 1.0 };
GLfloat smat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat slm_ambient[] = { 0.5, 0.5, 0.5, 1.0 };
GLfloat slm_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat slm_specular[] = { 1.0, 0, 0, 1.0 };
GLfloat sblanc_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat snothing[] = { 0, 0, 0, 0 };
GLfloat sjaune_diffuse[] = { 1.0, 1.0, 0.0, 1.0 };
GLfloat sjaune_diffuse_trans[] = { 1.0, 1.0, 0.0, 0.5 };
GLfloat sjaune_diffuse_tres_trans[] = { 1.0, 1.0, 0.0, 0.25 };
GLfloat sbleu_diffuse_trans[] = { 0.4, 0.4, 1.0, 0.5 };
GLfloat srouge_diffuse_trans[] = { 1.0, 0.2, 0.2, 0.7 };
GLfloat srouge_diffuse[] = { 1, 0, 0.0, 1 };
GLfloat sjaune_emission[] = { .5, .5, 0.1, 0.8 };
GLfloat svert_diffuse[] = { 0, 1.0, 0, 1.0 };
GLfloat sbleu_diffuse[] = { 0, 0.0, 1, 1.0 };
GLfloat sbleu_clair_diffuse[] = { .3, 0.7, .8, 1.0 };
GLfloat sgris_diffuse[] = { 0.5, 0.5, 0.3, 1.0 };
GLfloat sgris2_diffuse[] = { 0.6, 0.6, .6, 1.0 };
GLfloat smarron_diffuse[] = {.6,.3,0,1.0};
GLfloat snoir_diffuse[] = { 0.0, 0.0, 0.0, 1.0 };

void changeAllTexturesAnis(int anisValue);
void changeAllTextures(GLenum mag, GLenum min);

GlaxiumVariables*  GlaxiumVariables::getGlaxiumVariables() {
    if (GLvar==NULL) {
        GLvar = new GlaxiumVariables();
    }
    return GLvar;
}

GlaxiumVariables::GlaxiumVariables() {
    initInstallDir();
    initVariables();
    initTextures();
#ifdef HAVE_LIBSDL_MIXER
    initSound();
#endif
    initJoystick();
	//    printf("Variables initialized...\n");
}


void GlaxiumVariables::initOptionsFile(bool bShad) {
	FILE *fOptions = fopen(getFullOptionsPath(), "r");
	if (fOptions == NULL) {
		fOptions = fopen(getFullOptionsPath(), "w+");
//		printf("====> %s\n", getFullOptionsPath());
//		printf("%d %d %d %d\n", 2, (int)fMaxAnis, 2, bShadows?1:0);
		fprintf(fOptions, "%d %d %d %d", 2, (int)fMaxAnis, 2, bShad?1:0);
		details = 2;
		bShadows = bShad;
	} else {
		int filter, anis, nShad;
		fscanf(fOptions, "%d %d %d %d", &filter, &anis, &details, &nShad);
		bShadows = (nShad == 1);
		changeAllTexturesAnis(anis);
		switch (filter) {
		case 0:
			changeAllTextures(GL_NEAREST, GL_NEAREST_MIPMAP_NEAREST);
			break;
		case 1:
			changeAllTextures(GL_LINEAR, GL_LINEAR_MIPMAP_NEAREST);
			break;
		case 2:
			changeAllTextures(GL_LINEAR, GL_LINEAR_MIPMAP_LINEAR);
			break;
		}
	}

	fclose(fOptions);
}


void GlaxiumVariables::initVariables() {
	mySpaceShip = NULL;
    global_timeadjustment=1;
    global_pause=0;
    camera=1;
    mat_ambient=smat_ambient;
    mat_specular=smat_specular;
    light_position=slight_position;
    lm_ambient=slm_ambient;
    lm_diffuse=slm_diffuse;
    lm_specular=slm_specular;
    blanc_diffuse=sblanc_diffuse;
    nothing=snothing;
    jaune_diffuse=sjaune_diffuse;
    jaune_diffuse_trans=sjaune_diffuse_trans;
    jaune_diffuse_tres_trans=sjaune_diffuse_tres_trans;
    bleu_diffuse_trans=sbleu_diffuse_trans;
    rouge_diffuse_trans=srouge_diffuse_trans;
    rouge_diffuse=srouge_diffuse;
    jaune_emission=sjaune_emission;
    vert_diffuse=svert_diffuse;
    bleu_diffuse=sbleu_diffuse;
    bleu_clair_diffuse=sbleu_clair_diffuse;
    gris_diffuse=sgris_diffuse;
    gris2_diffuse=sgris2_diffuse;
    marron_diffuse=smarron_diffuse;
    noir_diffuse=snoir_diffuse;
	float shadowMatrixTmp[] = {  light_position[1]*10,0,0,0, -light_position[0]*10,0,-light_position[2]*10,-1,0,0,light_position[1]*10,0,0,0,0,light_position[1]*10};
	shadowMatrix = new float [16];
	for (int i=0;i<16;i++) {
		shadowMatrix[i]= shadowMatrixTmp[i];
	}
    
    space_name[0] =  "textures/space1.png";    
    space_name[1] =  "textures/space0.png"; 
    space_name[2] =  "textures/space3.png";
    space_name[3] =  "textures/space2.png";
	
    pos_space =  static_pos_space;
    fileSample = static_fileSample ;
	
    rotateMyShip=0.0f;
    delay =0;
    bShadows=true;
	bNVExtension = isExtensionSupported("GL_NV_register_combiners") && isExtensionSupported("GL_NV_vertex_program");
	bEXTEnvDot3 = isExtensionSupported("GL_EXT_texture_env_dot3")&& isExtensionSupported("GL_EXT_texture_env_combine");
	bARBCubeMap = isExtensionSupported("GL_ARB_texture_cube_map");
	details = 0;
	// Number of teture unit
	glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB,&m_nTextureUnits);
	printf("Number of texture units               : %d\n", m_nTextureUnits);
	
	if (bNVExtension) {
		// Number of register combiners
		glGetIntegerv(GL_MAX_GENERAL_COMBINERS_NV, &m_nRegisterCombiners);
		printf("Number of general combiners available : %d\n", m_nRegisterCombiners);
		if (m_nRegisterCombiners==2 && m_nTextureUnits==2) {
			printf("Nvidia NV1x video card found (geforce 256/2)\n");
		} else if (m_nRegisterCombiners==8 && m_nTextureUnits==4) {
			printf("Nvidia NV2x video card found (geforce 3/4)\n");
		}
	} else if (bEXTEnvDot3) {
		printf("Found GL_EXT_texture_env_dot3 extension, i'll use it.\n");
	} else {
		printf(" Cannot load dot3 extension neither NVidia neither ARB.\r\n");
		printf(" Fall back to basic openGL. The floor will be very simple.\r\n");
	}
	

    bSeparateSpecularColor = isExtensionSupported("GL_EXT_separate_specular_color");

	
	fMaxAnis = 0;
	
	if (isExtensionSupported("GL_EXT_texture_filter_anisotropic")) {
		glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT,  & fMaxAnis);
		if (fMaxAnis>0) {
			fMaxAnis = (fMaxAnis>8?8:fMaxAnis);
			printf("Glaxium will use anisotropy texture : %f\n", fMaxAnis);
		} 
	} else {
		printf("NO anisotropy texture...\n");
	}

}


void GlaxiumVariables::initTexture(GLuint &textureToBind, char* path) {
	//	 printf("Loading : %s\n", getFullPath(path));
    PngTex* tmpTexture = new PngTex(getFullPath(path));
    tmpTexture->bindToTexture(textureToBind);
    delete tmpTexture;
}


void GlaxiumVariables::initTextures() {
        int i,j,k,l;
        PngTex* texture,*texture2;
        int *tmpTexture;
        int *tmpTexture2;		
		
        initTexture(texture_floorMap[0], "textures/floormap.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floorMap[1], "textures/floormap1.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floorMap[2], "textures/floormap2.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floorMap[3], "textures/floormap3.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floorMap[4], "textures/floormap4.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
		
        initTexture(texture_mark, "textures/mark.png");
        initTexture(texture_building, "textures/cube.png");
        initTexture(texture_tache, "textures/tache.png");
        initTexture(texture_deadtache, "textures/deadtache.png");
        initTexture(texture_camouflage, "textures/camouflage.png");
		  initTexture(texture_thunder, "textures/thunder.png");
		  initTexture(texture_specialeffect1, "textures/effect1.png");

        initTexture(texture_chaine, "textures/chain.png");
        initTexture(texture_myship, "textures/myship.png");
        initTexture(texture_piege, "textures/piege.png");
        initTexture(texture_bandit1, "textures/bandit1.png");
        initTexture(texture_fire3, "textures/missile.png");
        initTexture(texture_fighter2, "textures/fighter2.png");
		
        initTexture(texture_bandit2, "textures/bandit2.png");
        initTexture(texture_sphere, "textures/sphere.png");
        
        initTexture(texture_fumee[0], "textures/fumee1.png");
        initTexture(texture_fumee[1], "textures/fumee2.png");
        initTexture(texture_fumee[2], "textures/fumee3.png");
		
        initTexture(texture_gameover, "textures/gameover.png");
        initTexture(texture_board, "textures/board.png");
        initTexture(texture_galaxy, "textures/galaxy.png");

        initTexture(texture_capsule[Diamond::POWER], "textures/capsule_shield.png");
        initTexture(texture_capsule[Diamond::POWERUP], "textures/capsule_power.png");
        initTexture(texture_capsule[Diamond::BOMB], "textures/capsule_bomb.png");
        initTexture(texture_capsule[Diamond::INVUL], "textures/capsule_invul.png");
        
        initTexture(texture_floor[0], "textures/floor.png");
        initTexture(texture_letters, "textures/chars.png");
		
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floor[1], "textures/floor1.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floor[2], "textures/floor2.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floor[3], "textures/floor3.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_floor[4], "textures/floor4.png");
        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);
        initTexture(texture_border, "textures/border2.png");

		// only for border :
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);

        if (fMaxAnis>0)
			glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAX_ANISOTROPY_EXT,  fMaxAnis);

        
        for (i=0; i< SPACE;i++) {
            initTexture(texture_space[i], space_name[i]);
        }
		
        
        texture = new PngTex(getFullPath("textures/glax2.png"));
        tmpTexture = (int*)texture->getTextureForOpenGl();
        for (j=0;j<2;j++) {
            for (i=0;i<3;i++) {
                tmpTexture2 = new int[256*256];
                for (k=0; k<256; k++) {
                    for (l=0; l<256; l++) {
                        if ((i*256+l<640) && +(j*256+k<480)) {
                            tmpTexture2[k*256+l] = tmpTexture[l+i*256+(j*256+k)*640];
                        }
                    }
                }
                texture2 = new PngTex();
                texture2->setAll(256,256,(char*)tmpTexture2);
                texture2->bindToTexture(texture_title[j*3+i]);
                delete texture2;
            }
        }

        // Letters        
	//    printf("Loading : %s\n", path);

}



#ifdef HAVE_LIBSDL_MIXER
void GlaxiumVariables::initSound()
{
    int audio_rate=MIX_DEFAULT_FREQUENCY;
    Uint16 audio_format=MIX_DEFAULT_FORMAT;
    int audio_channels=MIX_DEFAULT_CHANNELS;
#ifndef WIN32    
    int audio_buffers=1024;
#else
    int audio_buffers=1024;
#endif
   
 	//    printf("Init SDL_mixer\n");
    /* Open the audio device */
    if (Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) < 0) {
        fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
        exit(2);
    } else {
        Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);
        printf("Opened audio at %d Hz %d bit %s, %d bytes audio buffer\n", audio_rate,
            (audio_format&0xFF),
            (audio_channels > 1) ? "stereo" : "mono", 
            audio_buffers );
    }
    
	 int nTotalChannel = Mix_AllocateChannels(22);
	 printf("Number of mixing channels : %d\n", nTotalChannel);

    /* Load the requested module file */
    //  module1 = Mix_LoadMUS(getFullPath("samples/glax.xm"));
    module2 = Mix_LoadMUS(getFullPath("samples/glax3.xm"));
    Mix_PlayMusic(module2,-1);
    
    for (int i=SAMPLE_WELCOME;i<SAMPLE_UNDEF;i++) {
        char fileToLoad[256];
        strcpy(fileToLoad,"samples/");
        strcat(fileToLoad,fileSample[i]);
        //           printf("Loading %d : '%s'\n",i,fileToLoad);
        
        samples[i] = Mix_LoadWAV(getFullPath(fileToLoad));
        if (!samples[i]) {
            fprintf(stderr, "Could not load sound '%s' , reason: %s\n",
                fileSample[i],
                SDL_GetError());
        }
    }
}

#endif
void GlaxiumVariables::initInstallDir() {

	installDir= NULL;
#ifdef DATADIR
	FILE *fp = fopen("textures/space1.png", "rb");

	if (fp==NULL) {
		char path[1024];
		sprintf(path, "%s/textures/space1.png", DATADIR);
		fp = fopen(path, "rb");
		if (fp==NULL) {
			printf("Installation problem... cannot find textures...\n");
			printf("Neither in ./ nor in %s\n",DATADIR);
		} else {
			printf("Found textures in %s\n", DATADIR);
			installDir = DATADIR"/";
		}
	} else {
		printf("Found textures in ./\n", DATADIR);
	}
#endif
}


void GlaxiumVariables::initJoystick() {
    // test joystick
    joy=NULL;   
    if (SDL_NumJoysticks()>0) {
        printf("YES !!! I found a joystick...\n");
        joy=SDL_JoystickOpen(0);
        if (joy==NULL) {
            printf("AOUCH !!Joysick initialisation error !!!");
        }
        
    } else {
        printf("No SDL joystick found...\n");
    }
}



void GlaxiumVariables::initAllLists() {
	MyShip::initList();
    Ship1::initList();
    Bandit2::initList();
    Fighter2::initList();
    Cube::initList();
    Diamond::initList();
    Scratcher::initList();
    MyFire3::initList();
    Tank::initList();
}


char* GlaxiumVariables::getFullPath(char *name) {
    static char returnString[1024];

    if (installDir==NULL) {
        return name;
    } else {
        strcpy(returnString,installDir);
        strcat(returnString, name);
		  return returnString;
    }
}

char* GlaxiumVariables::getFullOptionsPath() {
#ifdef WIN32
	return "glaxiumrc";
#else
	static char strReturn[1024];
	strcpy(strReturn, getenv("HOME"));
	strcat(strReturn, "/.glaxiumrc");
#endif
}

bool GlaxiumVariables::myRandom(int i) {
    if (i==0) return false;
#ifndef WIN32
    if ((random()%(i<<4))<(int)(GLvar->global_timeadjustment*16.0)) {
        return true;
    }
#else
    if ((float)rand()*i/32000 <  GLvar->global_timeadjustment) {
        return true;
    }
#endif
    return false;
}


bool GlaxiumVariables::isExtensionSupported(const char *extension)
{
	const GLubyte *extensions = NULL;
	const GLubyte *start;
	GLubyte *where, *terminator;
	
	/* Extension names should not have spaces. */
	where = (GLubyte *) strchr(extension, ' ');
	if (where || *extension == '\0')
		return false;
	extensions = glGetString(GL_EXTENSIONS);
	/* It takes a bit of care to be fool-proof about parsing the
	OpenGL extensions string. Don't be fooled by sub-strings,
	etc. */
	start = extensions;
	for (;;) {
		where = (GLubyte *) strstr((const char *) start, extension);
		if (!where)
			break;
		terminator = where + strlen(extension);
		if (where == start || *(where - 1) == ' ')
			if (*terminator == ' ' || *terminator == '\0')
				return true;
			start = terminator;
	}
	return false;
}



