/*
  Copyright (C) 2000/2002 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <GL/glut.h>

#include "cube.hpp"
#include "diamond.hpp"
#include "fire.hpp"

#include "modeles/cube.c"

int Cube::list_;

Cube::Cube(List *list, int shield, int x)
   : Sprite(list,TYPE_CUBE ,x,.5,70)
{
   state_=NORMAL;
   dzInit_ = dz_ = -.1;
   sizex_ = 1;
   sizey_ = 1;
   sizez_ = 1;
   tetay_=random()%90;
   dtetay_=0;
   shield_=shield;
   bRealEnemy=true;
}

    void Cube::initList()
{
    
    int i,j;
	 // average normal.....
	 int nbVertex = 64*3;
	 int *bTested = new int[nbVertex];
	 for (i=0;i<nbVertex;i++) {
		 bTested[i] = 0;
	 }
	 int nb;
	 GLfloat aNormal[3];
	 for (i=0;i<nbVertex;i++) {
		 if (bTested[i]==0) {
			 bTested[i] = 2;
			 nb=1;
			 aNormal[0] = cube_meshes[i*8+3];
			 aNormal[1] = cube_meshes[i*8+4];
			 aNormal[2] = cube_meshes[i*8+5];
			 for (j=i+1;j<nbVertex;j++) {
				 if ((bTested[j]==0) && ((cube_meshes[i*8+0]-cube_meshes[j*8+0])<.01)  && ((cube_meshes[i*8+1]-cube_meshes[j*8+1])<.01) && ((cube_meshes[i*8+2]-cube_meshes[j*8+2])<.01) && ((cube_meshes[i*8+0]-cube_meshes[j*8+0])>-.01)  && ((cube_meshes[i*8+1]-cube_meshes[j*8+1])>-.01) && ((cube_meshes[i*8+2]-cube_meshes[j*8+2])>-.01) ) {
					 bTested[j]=2;
					 nb++;
					 aNormal[0]+= cube_meshes[j*8+3];
					 aNormal[1]+= cube_meshes[j*8+4];
					 aNormal[2]+= cube_meshes[j*8+5];
				 }
			 }
			 aNormal[0] /= nb;
			 aNormal[1] /= nb;
			 aNormal[2] /= nb;
			 for (j=i;j<nbVertex;j++) {
				 if (bTested[j]==2)  {
					 cube_meshes[j*8+3] = aNormal[0];
					 cube_meshes[j*8+4] = aNormal[1];
					 cube_meshes[j*8+5] = aNormal[2];
					 bTested[j]=1;
				 }
			 }	 
		 }
	 }
    
    for (i=0;i<64;i++) {
        cube_meshes[i*24]/=1.5;
        cube_meshes[i*24+1]/=1.5;
        cube_meshes[i*24+2]/=1.5;
        
        cube_meshes[i*24+8]/=1.5;
        cube_meshes[i*24+1+8]/=1.5;
        cube_meshes[i*24+2+8]/=1.5;
        
        cube_meshes[i*24+16]/=1.5;
        cube_meshes[i*24+1+16]/=1.5;
        cube_meshes[i*24+2+16]/=1.5;
    }
    
    list_ = glGenLists(1);
    
    glNewList(list_,GL_COMPILE);
    {
        //  glTranslatef(0,.2,0);
        
        
        glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_NORMAL_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        glVertexPointer(3,GL_FLOAT,32,cube_meshes); 
        glNormalPointer(GL_FLOAT,32,cube_meshes+3); 
        glTexCoordPointer(2,GL_FLOAT,32,cube_meshes+6);
        
        glDrawArrays(GL_TRIANGLES,0,64*3);
        
        glDisableClientState(GL_VERTEX_ARRAY);
        glDisableClientState(GL_NORMAL_ARRAY);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
        
    }
    glEndList();
	 delete []bTested ;
}


void Cube::drawShadowable()
{
    
    glPushMatrix();
    
    glTranslatef(x_,y_,z_);
    if (tetay_)
        glRotatef(tetay_,0,1,0);
    
    
    
    //  glEnable(GL_TEXTURE_2D);
    //  glBindTexture(GL_TEXTURE_2D, texture_building); 
    
    //  glMaterialfv(GL_FRONT,GL_DIFFUSE,blanc_diffuse);
    //  glBegin(GL_QUADS);
    
    glCallList(list_);

    glPopMatrix();

}

void Cube::draw()
{
    glBindTexture(GL_TEXTURE_2D, GLvar->texture_building);
    drawShadowable();
}

void Cube::move()
{
    
    
    if (y_==.5) {
        if (dtetay_>0.015)
        {
            //    printf("tetay_ = %f\n",tetay_);
            dtetay_-=.03;
        }
        else if (dtetay_<-0.015)
        {
            //    printf("tetay_ = %f\n",tetay_);
            dtetay_+=.03;
        }
        else if (dtetay_ != 0)
        {
            dtetay_=0;
        }
        
        tetay_ +=dtetay_*GLvar->global_timeadjustment;
        
        if (dx_>0.04*GLvar->global_timeadjustment)
        {
            dx_-=.03*GLvar->global_timeadjustment;
        }
        else if (dx_<-0.04*GLvar->global_timeadjustment)
        {
            dx_+=.03*GLvar->global_timeadjustment;
        }
        else 
        {
            dx_=0;
        }
        if (dz_>(-.1+(.02 * GLvar->global_timeadjustment)))
        {
            dz_-= (.08 * GLvar->global_timeadjustment);
        }
        else if (dz_ < (-.1-(.02 * GLvar->global_timeadjustment)))
        {
            dz_+=(.08 * GLvar->global_timeadjustment);
        }
        else 
        {
            dz_=-.1;
        }
        
    }
    
    if (x_<-12.1)
    {
        // dx_=-dx_;
        //x_=-23-x_;
        dy_-=0.006*GLvar->global_timeadjustment;
    }
    if (x_>12.1)
    {
        dy_-=0.006*GLvar->global_timeadjustment;
        //        dx_=-dx_;
        //    x_=23-x_;
    }
    
    
    Sprite::move();
    
    if (z_<-3)
    {
        dead_=1;
    }
    if (y_<-35) {
      dead_=1;
    }
}


void Cube::collision(Sprite*contact)
{
    static Explosion * explode;
    switch(contact->getType())
    {
    case TYPE_MY_FIRE2:
         shield_ = 0;
    case TYPE_MY_FIRE4:
         shield_ -=2;;
    case TYPE_MY_SPACE_SHIP:
    case TYPE_MY_FIRE1:
        {
            shield_--;
            if (shield_>0)
            {
              
                float tx = ((x_-contact->getX()) / ((sizex_ + contact->getSizeX())/2)) ;
                dx_ = tx/2;
                dtetay_ = tx*10;
                dz_=.5-dx_;
            }
            else if (dead_==0)
            {
                explode = new Explosion(this,8);
                mlist->Add(explode);
 			    if ((random()%5)==0) {
                    Diamond* diams = new Diamond(this);
                    mlist->Add(diams);
				}
                contact->score(100);
                dead_=1;
            }
            break;
        }   
    case TYPE_CUBE:
    case TYPE_SHIP1:
    case TYPE_TANK:
    case TYPE_SPIRALE:
        {
            static int i=0;
            float tx = ((x_-contact->getX()) / ((sizex_ + contact->getSizeX())/2)) ;
            float tz = ((z_-contact->getZ()) / ((sizez_ + contact->getSizeZ())/2)) ;
            dx_ = tx/3;
            dtetay_ = tx*7;
            dz_= tz/3;
            break;
            
        }
    }
}
