/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "list.hpp"

List:: List(void) {
    mfirst=NULL;
    mlast=NULL;
    mcurrent=NULL;
    mnumber = 0;
}

void List::Copy(List *list) {
    mfirst=list->get_mfirst();
    mlast=list->get_mlast();
    mcurrent=mfirst;
}

void List::Add(Elem * el) {
    if (!mfirst) {
        mcurrent=mfirst=el;
    } else {
        mlast->mnext=el;
        el->mprev=mlast;
    }
    mlast=el;
    mnumber++;
}



short List::Next(void) {
    mcurrent=mcurrent->mnext;
    if (!mcurrent) {
        mcurrent=mfirst;
        return 0;
    } else {
        return 1;
    }
}

short List::Prev(void) {
    mcurrent=mcurrent->mprev;
    if (!mcurrent) {
        mcurrent=mlast;
        return 0; 
    } else {
        return 1;
    }
}

short List::First(void) {
    if (mfirst) {
        mcurrent=mfirst;
        return 1;
    } else {
        return 0;
    }
}


