/*
  Copyright (C) 2000/2001 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <GL/glut.h>

#include "ship1.hpp"
#include "fire.hpp"
#include "modeles/ship1.c"


#define ABS(x) (x<0?-x:x)
#define SIGN(x) (x<0?-1:1)

int Ship1::list_;

Ship1::Ship1(List *list, float x,float z,float speed, int power)
: Sprite(list,TYPE_SHIP1 ,x,.5,70)
{
    int nb=random()%5;
    state_=ARRIVING;
    sizex_ = 1;
    sizey_ = 1;
    sizez_ = 1.8;
    rotate_=180.0;
    
    centerX_ = ((float)(random()%100)/10.0)-5.0;
    centerZ_=25;
    rayX_=((float)(random()%70)/10)+3;
    rayZ_=12;
    position_=0;
    power_=power;
    x_=centerX_-rayX_;
    bRealEnemy=true;
}

void Ship1::initList()
{
    
    int i,j;
    
	 // average normal.....
	 int nbVertex = 134*3;
	 int *bTested = new int[nbVertex];
	 for (i=0;i<nbVertex;i++) {
		 bTested[i] = 0;
	 }
	 int nb;
	 GLfloat aNormal[3];
	 
	 for (i=0;i<nbVertex;i++) {
		 if (bTested[i]==0) {
			 bTested[i] = 2;
			 nb=1;
			 aNormal[0] = bandit1_meshes[i*8+3];
			 aNormal[1] = bandit1_meshes[i*8+4];
			 aNormal[2] = bandit1_meshes[i*8+5];
			 for (j=i+1;j<nbVertex;j++) {
				 if ((bTested[j]==0) && ((bandit1_meshes[i*8+0]-bandit1_meshes[j*8+0])<.01)  && ((bandit1_meshes[i*8+1]-bandit1_meshes[j*8+1])<.01) && ((bandit1_meshes[i*8+2]-bandit1_meshes[j*8+2])<.01) && ((bandit1_meshes[i*8+0]-bandit1_meshes[j*8+0])>-.01)  && ((bandit1_meshes[i*8+1]-bandit1_meshes[j*8+1])>-.01) && ((bandit1_meshes[i*8+2]-bandit1_meshes[j*8+2])>-.01) ) {
					 bTested[j]=2;
					 nb++;
					 aNormal[0]+= bandit1_meshes[j*8+3];
					 aNormal[1]+= bandit1_meshes[j*8+4];
					 aNormal[2]+= bandit1_meshes[j*8+5];
				 }
			 }
			 aNormal[0] /= nb;
			 aNormal[1] /= nb;
			 aNormal[2] /= nb;
			 for (j=i;j<nbVertex;j++) {
				 if (bTested[j]==2)  {
					 bandit1_meshes[j*8+3] = aNormal[0];
					 bandit1_meshes[j*8+4] = aNormal[1];
					 bandit1_meshes[j*8+5] = aNormal[2];
					 bTested[j]=1;
				 }
			 }	 
		 }
	 }
   
    for (i=0;i<134;i++) {
        bandit1_meshes[i*24]/=100;
        bandit1_meshes[i*24+1]/=100;
        bandit1_meshes[i*24+2]/=100;
        
        bandit1_meshes[i*24+8]/=100;
        bandit1_meshes[i*24+1+8]/=100;
        bandit1_meshes[i*24+2+8]/=100;
        
        bandit1_meshes[i*24+16]/=100;
        bandit1_meshes[i*24+1+16]/=100;
        bandit1_meshes[i*24+2+16]/=100;
    }
    
    list_ = glGenLists(2);
    
    glNewList(list_,GL_COMPILE);
    {
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, GLvar->texture_bandit1);
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, GLvar->blanc_diffuse);
		glDisable(GL_BLEND);
		glEnable(GL_LIGHTING);

		glTranslatef(0,.2,0);
        glRotatef(90,1,0,0);
        glRotatef(190,0,1,0);
                
        glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_NORMAL_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        glVertexPointer(3,GL_FLOAT,32,bandit1_meshes); 
        glNormalPointer(GL_FLOAT,32,bandit1_meshes+3); 
        glTexCoordPointer(2,GL_FLOAT,32,bandit1_meshes+6);
        
        glDrawArrays(GL_TRIANGLES,0,134*3);
        
        glDisableClientState(GL_VERTEX_ARRAY);
        glDisableClientState(GL_NORMAL_ARRAY);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
        
    }
    glEndList();


    glNewList(list_+1,GL_COMPILE);
    {
        glRotatef(90,1,0,0);
        glRotatef(190,0,1,0);
		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(3,GL_FLOAT,32,bandit1_meshes); 

		glDrawArrays(GL_TRIANGLES,0,133*3+2);
        
		glDisableClientState(GL_VERTEX_ARRAY);
    }
    glEndList();

	delete []bTested;
}


void Ship1::drawShadowable() 
{

    glPushMatrix();
    glTranslatef(x_,y_,z_);
    if (state_==MOVING_2) {
        glRotatef(rotate_+90,1,0,0);
//        glRotatef(rotate_*4,0,0,-1);
    }
    
    glCallList(list_+1);
    glPopMatrix();

}


void Ship1::draw()
{

    glPushMatrix();
    glTranslatef(x_,y_,z_);
    if (state_==MOVING_2) {
        glRotatef(rotate_+90,1,0,0);
//        glRotatef(rotate_*4,0,0,-1);
    }
    
    glCallList(list_);
    glPopMatrix();
}


void Ship1::move()
{
    switch(state_) {
    case MOVING_1:
        {
            rotate_+=1.0*GLvar->global_timeadjustment;
            
            
            if (GLvar->mySpaceShip!=NULL) {
                if ((rotate_>360.0) && (position_==3))  { 
                    rotate_-=360.0;
                    position_=0;
                    if (GLvar->mySpaceShip->getZ()>z_) {
                        rayZ_ = ((centerZ_-GLvar->mySpaceShip->getZ()<0)?-centerZ_+GLvar->mySpaceShip->getZ():centerZ_-GLvar->mySpaceShip->getZ());
                    }
                    rayX_ = (x_-GLvar->mySpaceShip->getX())/2;
                    centerX_ = (GLvar->mySpaceShip->getX()+x_)/2;
                }
                if ((rotate_>90.0)&&(position_==0)) {
                    position_=1;
                    if (GLvar->mySpaceShip->getZ()<z_) {
                        rayZ_ = (z_-GLvar->mySpaceShip->getZ())/2;
                        centerZ_ = (GLvar->mySpaceShip->getZ()+z_)/2;
                    } else {
                        rayZ_ = (GLvar->mySpaceShip->getZ()-z_)/2;
                        centerZ_ = (GLvar->mySpaceShip->getZ()+z_)/2;
                        rayX_=-rayX_;
                        rotate_=270.0;
                        position_ = 3;
                        
                    }
                    
                }
                if ((rotate_>180.0) && (position_==1))  { 
                    if (((random()%20)==0) && (rayZ_>0))
                    {
                        state_=LEAVING;
                        break;
                    }
                    position_=2;
                    if (GLvar->mySpaceShip->getZ()<z_) {
                        rayZ_ = ((centerZ_-GLvar->mySpaceShip->getZ()<0)?-centerZ_+GLvar->mySpaceShip->getZ():centerZ_-GLvar->mySpaceShip->getZ());
                    }
                    rayX_ = (GLvar->mySpaceShip->getX()-x_)/2;
                    centerX_ = (GLvar->mySpaceShip->getX()+x_)/2;
                }
                
                if ((rotate_>270.0)&&(position_==2)) {
                    position_=3;
                    if (GLvar->mySpaceShip->getZ()>z_) {
                        centerZ_ = (GLvar->mySpaceShip->getZ()+z_)/2;
                        rayZ_ = (GLvar->mySpaceShip->getZ()-z_)/2;
                    } else {
                        rayZ_ = (z_-GLvar->mySpaceShip->getZ())/2;
                        centerZ_ = (GLvar->mySpaceShip->getZ()+z_)/2;
                        rayX_=-rayX_;
                        rotate_=90.0;
                        position_ = 1;
                    }
                }
            }
            
            
            x_=centerX_+cos(rotate_*PI/180.0)*rayX_;
            z_=centerZ_+sin(rotate_*PI/180.0)*rayZ_;
                       
            
            //  if (z_<-5) dead_=1;
            if (GLvar->myRandom(128))
            {
                Ship1Fire *newFire;
                newFire= new Ship1Fire(mlist,this);
                mlist->Add(newFire);
                
            }
            break;
        }
    case ARRIVING:
        {
            dz_=-.4;
            if (z_<centerZ_) {
                if (random()&1) {
                    state_=MOVING_1;
                    rotate_=180;
                    position_=2;
                } else {
                    rotate_=-90;
                    centerX_=4.5;
                    centerZ_ = z_;
                    state_=MOVING_2;
                }
            } else {
                Sprite::move();
            }
        }
        break;
    case LEAVING:
        {
            rotate_=180;      
            dz_=-.4;
            if (z_<-3) {
                dead_=1;
            }
            Sprite::move();
        }
        break;
    case MOVING_2:
        {
            rotate_+=4.0*GLvar->global_timeadjustment;
            
            z_=centerZ_-cos(rotate_*PI/180.0)*4.0;
            y_=centerX_+sin(rotate_*PI/180.0)*4.0;
    
	    if (GLvar->mySpaceShip!=NULL) {
	      x_=x_ + (x_>GLvar->mySpaceShip->getX()?-.05:.05) *GLvar->global_timeadjustment;

	      if (rotate_>270) {
                rayX_ = (GLvar->mySpaceShip->getX()-x_)/2;
                centerX_ = (GLvar->mySpaceShip->getX()+x_)/2;
                state_=MOVING_1;
                rotate_=180.0;
                position_=2;
                centerZ_=z_;
                rayZ_=0;
                y_=.5;
	      }
	    } else {
	      state_=LEAVING;
	    }
    
            break;
        }
        
    }
}


void Ship1::collision(Sprite*contact)
{
    
    switch(contact->getType())
    {
    case TYPE_CUBE:
        break;
    case TYPE_SHIP1:
        if ((z_<contact->getZ()) && (state_!=MOVING_2) && (((Ship1*)contact)->getState()!=MOVING_2)) {
            rotate_=-90;
            centerX_=4.5;
            centerZ_ = z_;
            state_=MOVING_2;
        }
        // x_=centerX_+cos(rotate_*PI/180.0)*rayX_;
        break;
    case TYPE_MY_SPACE_SHIP:
    case TYPE_MY_FIRE2:
         power_=0;
    case TYPE_MY_FIRE1:
    case TYPE_SPIRALE:
        {
            Explosion *explode;
            if ((--power_<=0) && (dead_==0)) {
                explode= new Explosion(this,7);
                mlist->Add(explode);
                dead_=1;
                contact->score(250);
                
            } 
            
            break;
        }
    }
    
}


/* +================================+
|           Ship1Fire            |
+================================+ 
*/
void Ship1Fire::drawShadowable()
{
    
    glPushMatrix();
    glTranslatef(x_ , y_ , z_);
    
    glBegin(GL_TRIANGLE_FAN); 
    
    glVertex3f(0 ,0,0);   
    glVertex3f(.1 , 0 ,.35); 
    glVertex3f(-.1 , 0 ,.35);
    glVertex3f(0 , .1 ,.35);
    glVertex3f(0,-.1 ,.35);
    
    glEnd();
    
    glPopMatrix();
}


void Ship1Fire::draw()
{
    
    glPushMatrix();
    glTranslatef(x_ , y_ , z_);
    glRotatef(tetay_   ,0,0,1);
    
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDepthMask(0);

    glBegin(GL_TRIANGLE_FAN); 
    
    glColor4f(1 , 1 , 1 , 1);

    glVertex3f(0 ,0,0);   
    
    glColor4f(1 , 1 ,0 , 0.0);
    glVertex3f(.1 , 0 ,.35); 
    glVertex3f(-.1 , 0 ,.35);
    glVertex3f(0 , .1 ,.35);
    glVertex3f(0,-.1 ,.35);
    
    glEnd();
    
    
    glDepthMask(1);
    glDisable(GL_BLEND);
    glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
    
	glColor4f(1,1,1,1);
    glPopMatrix();
}


void Ship1Fire::move()
{
    Sprite::move();
    
    tetay_ += (10*GLvar->global_timeadjustment)>20 ? 20:(10*GLvar->global_timeadjustment);
    
    if (tetay_>360)
        tetay_=tetay_-360;
    
    if (z_<0)
    {
        dead_=1;
    }
}


void Ship1Fire::collision(Sprite*contact)
{  
    switch(contact->getType())
    {
    case TYPE_MY_SPACE_SHIP:
    case TYPE_MY_FIRE2:
    case TYPE_MY_FIRE1:
        //  case TYPE_CUBE:
        {
            Sprite *explode;
            explode= new Explosion(this,2,1,0);
            mlist->Add(explode);
            
            dead_=1;
            break;
        }
    }
}
