/*
  Copyright (C) 2000 Xavier Hosxe <xhosxe@free.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __SHIP1__
#define __SHIP1__


#include <stdlib.h>
#include "sprite.hpp"
#include "list.hpp"
#include "explosion.hpp"

class Ship1Fire ;

class Ship1 : public Sprite {
    friend class Ship1Fire;
public:
    enum state {
        ARRIVING,
            MOVING_1,
            MOVING_2,
            ATTACK,
            LEAVING
    };
    Ship1(List *list, float x,float z,float speed, int power);
    void draw();
    void drawShadowable();
    void move();
    void collision(Sprite *);
    static void initList();
    int getState() { return state_; }
protected:
    int state_;
    int speed_,power_;
    float centerX_,centerZ_;
    float rayX_,rayZ_;
    int position_;
    Sprite* toFollo_;
    static int list_;
    float rotate_;
};




class Ship1Fire : public Sprite {
public:
    Ship1Fire(List *list, Ship1 *ship1)
        : Sprite(list,TYPE_FIRE_SHIP1 ,ship1->x_,ship1->y_,ship1->z_)
    {
        sizez_=.2;
        sizey_=.2;
        sizex_=.2;
        dz_=-.27;
    }
    void draw();
	void drawShadowable();
    void move();
    void collision(Sprite *);
    
protected:
    float tetay_;
};

#endif



