/* 
 * Audio 'LIB' defines
 */
#if defined(__cplusplus)
  #define EXTERN extern "C"
#else
  #define EXTERN extern
#endif

enum { AUDIO_OUT_HEADPHONES,AUDIO_OUT_INTERNAL_SPEAKER,AUDIO_OUT_LINE_OUT };
enum { DECODE_TEST, DECODE_AUDIO, DECODE_STDOUT, DECODE_BUFFER, DECODE_BEOS};

#define AUDIO_FORMAT_SIGNED_16    0x1
#define AUDIO_FORMAT_UNSIGNED_8   0x2
#define AUDIO_FORMAT_SIGNED_8     0x4
#define AUDIO_FORMAT_ULAW_8       0x8
#define AUDIO_FORMAT_ALAW_8       0x10

#if defined(HPUX) || defined(SUNOS) || defined(SOLARIS) || defined(VOXWARE)
#define AUDIO_USES_FD
#endif

#if defined(__BEOS__)
	#include <OS.h>
	
	struct frame;
	EXTERN sem_id	startsem;
	EXTERN sem_id	endsem;
	EXTERN void		beos_replay(struct frame *, int, int, bool, bool);
	EXTERN status_t	init_bapp(void *);
	EXTERN void		quit_bapp();
	EXTERN bool		need_locking;
#endif

struct audio_info_struct
{
#ifdef AUDIO_USES_FD
  int fn; /* filenumber */
#endif
#ifdef SGI
  ALconfig config;
  ALport port;
#endif
  long rate;
  int gain;
  int output;
  char *device;
  int channels;
  int format;
};

EXTERN int audio_play_samples(struct audio_info_struct *,unsigned char *,int);
EXTERN int audio_open(struct audio_info_struct *);
EXTERN int audio_reset_parameters(struct audio_info_struct *);
EXTERN int audio_rate_best_match(struct audio_info_struct *ai);
EXTERN int audio_set_rate(struct audio_info_struct *);
EXTERN int audio_set_format(struct audio_info_struct *);
EXTERN int audio_get_formats(struct audio_info_struct *);
EXTERN int audio_set_channels(struct audio_info_struct *);
EXTERN int audio_write_sample(struct audio_info_struct *,short *,int);
EXTERN int audio_close(struct audio_info_struct *);
EXTERN void audio_info_struct_init(struct audio_info_struct *);
#ifdef SOLARIS
extern void audio_queueflush(struct audio_info_struct *ai);
#endif
