/* 
	Audio for BeOS, implemented by Attila Lendvai, 101@inf.bme.hu

	Uses BStreamingGameSound
 */

#include "mpg123.h"
#include <Application.h>
#include <StreamingGameSound.h>
#include <MediaDefs.h>
#include <string.h>

extern "C" {

status_t init_bapp(void *) {
	be_app = new BApplication("application/x-vnd.101-mpg123");
	be_app -> Run();
	return B_OK;
}

void quit_bapp() {
	be_app -> Lock();
	be_app -> Quit();
}

void audio_info_struct_init(struct audio_info_struct *ai) {
	ai->rate = -1;
	ai->gain = -1;
	ai->output = -1;
	ai->device = NULL;
	ai->channels = -1;
	ai->format = -1;
}


int audio_open(struct audio_info_struct *ai) {
	if(!ai)
		return -1;

	return 0;
}

int audio_reset_parameters(struct audio_info_struct *ai) {
	audio_set_format(ai);
	audio_set_channels(ai);
	audio_set_rate(ai);
	return 0;
}

int audio_rate_best_match(struct audio_info_struct *ai) {
  return 0;
}

int audio_set_rate(struct audio_info_struct *ai) {
  return 0;
}

int audio_set_channels(struct audio_info_struct *ai) {
  return 0;
}

int audio_set_format(struct audio_info_struct *ai) {
//  int sample_size, fmts;

  if(ai->format == -1)
    return 0;

//  switch(ai->format) {
//    case AUDIO_FORMAT_SIGNED_16:
//    default:
//      fmts = AFMT_S16_LE;
//      sample_size = 16;
//      break;
//    case AUDIO_FORMAT_UNSIGNED_8:
//      fmts = AFMT_U8;
//      sample_size = 8;
//      break;
//    case AUDIO_FORMAT_SIGNED_8:
//      fmts = AFMT_S8;
//      sample_size = 8;
//      break;
//    case AUDIO_FORMAT_ULAW_8:
//      fmts = AFMT_MU_LAW;
//      sample_size = 8;
//      break;
//  }
	return 0;
}

int audio_get_formats(struct audio_info_struct *ai) {
	int ret = 0;
	ret |= AUDIO_FORMAT_SIGNED_16;
	return ret;
}

sem_id startsem, endsem;
bool need_locking;

void bufferproc(void *, void *buffer, size_t size, BStreamingGameSound *obj) {
//printf("buffproc: size: %ld\n", (int32)size);	// *!*!*!*

//	if (size != (unsigned)audiobufsize)
//		debugger("buffer size mismatch, should not happen !!!");
	
	audiobufsize = size;

//	if (format.format != media_raw_audio_format :: B_AUDIO_SHORT)
//		debugger("format mismatch, should not happen !!!");

//bigtime_t start = system_time();

//printf("buffproc: starting to fill buffer: %lx\n", (int32)buffer);	// *!*!*!*
	pcm_sample = (uint8 *)buffer;
	pcm_point = 0;
	need_locking = true;
//printf("buffproc: releasing startsem: %ld\n", (int32)startsem);	// *!*!*!*
	release_sem(startsem);
//printf("bufferproc: waiting for endsem: %ld\n", (int32)endsem);	// *!*!*!*
	acquire_sem(endsem);
//printf("bufferproc: returning...\n");	// *!*!*!*

//printf("%Ld\n", system_time() - start);
}


void beos_replay(struct frame *fr, int startFrame, int numframes, bool verbose, bool doublespeed) {
	int frameNum = 0;
	
	if ( (startsem = create_sem(0, "mpg123 startsem")) < 0  ||
		(endsem = create_sem(0, "mpg123 endsem")) < 0) {
			return;
	}
	


	audiobufsize = (usebuffer) ? usebuffer * 1024 : 4096;
//	if (audiobufsize < 4 * 1024)
//		audiobufsize = 4*1024;
	frameNum = 0;
	need_locking = false;
	
//printf("usebuffer: %ld, audiobufsize: %ld\n", (int32)usebuffer, (int32)audiobufsize);	// *!*!*!*

	gs_audio_format fmt = {
		44100.0,
		2,
		gs_audio_format :: B_GS_S16,
		B_MEDIA_LITTLE_ENDIAN,
		audiobufsize				// does not seem to count
	};
	BStreamingGameSound player(audiobufsize / 2, &fmt, 2);	// here either. the buf size is always 8k (R4.5.2)
	if (player.InitCheck() != B_OK) {
		fprintf(stderr, "FATAL: BStreamingGameSound init failed...\n");
		exit(1);
	}
	player.SetStreamHook(&bufferproc, 0);
	status_t rc;
	if ((rc = player.StartPlaying()) < 0) {
		fprintf(stderr, "BStreamingGameSound :: StartPlaying() returned 0x%lx (%s)\n", (int32)rc, strerror(rc));
		exit(1);
	}
	
	set_thread_priority(find_thread(0), 30);
	
//	printf("waiting for startsem before loop: %ld\n", (int32)startsem);	// *!*!*!*
	acquire_sem(startsem);
	need_locking = false;
	for (frameNum=0; read_frame(fr) && numframes && !intflag;  frameNum++) {
		if (frameNum < startFrame || (doublespeed && (frameNum % doublespeed))) {
			if (fr -> lay == 3)
				set_pointer(512);
			continue;
		}
		numframes--;
		
		if (fr -> error_protection) {
			getbits(16); /* crc */
		}
		
		(fr -> do_layer)(fr, outmode, (struct audio_info_struct *)0);
		
		if (verbose) {
			if (verbose > 1 || !(frameNum & 0xf))
			fprintf(stderr, "\r{%4lu} ", (int32)frameNum);
		}
	}
	
	player.StopPlaying();
	
	delete_sem(startsem);
	delete_sem(endsem);
}

int audio_play_samples(struct audio_info_struct *ai,unsigned char *buf,int inlen) {
	return 0;
}

int audio_close(struct audio_info_struct *ai) {
	return 0;
}

}

