#include "KButton.h"

#include <TextView.h>


KButton::KButton(BRect frame
				, const char* name
				, const char* label
				, BMessage* message
				, uint32 resizeMask
				, uint32 flags)
		:BButton(frame, name, label, message, resizeMask, flags)
{
	viewList.MakeEmpty();
}

void
KButton::MouseUp(BPoint point)
{
	int32 num = viewList.CountItems();
	
	for(int32 i = 0; i < num; i++){
		BTextView* textview = (BTextView*)viewList.ItemAt(i);
		if(textview->IsFocus()){
			if(/*textview->HasMikakutei()*/true){
				//textview->Kakutei();
			}
			break;
		}
	}
	this->BButton::MouseUp(point);
}

void
KButton::KeyDown(const char* bytes, int32 numBytes)
{
	int32 num = viewList.CountItems();
	
	if(numBytes == 1 && *bytes == B_RETURN){
		for(int32 i = 0; i < num; i++){
			BTextView* textview = (BTextView*)viewList.ItemAt(i);
			if(textview->IsFocus()){
				if(/*!textview->HasMikakutei()*/true){
					this->BButton::KeyDown(bytes, numBytes);
				}else{
					//textview->Kakutei();
				}
				break;
			}
		}
	}
}














