#ifndef __KButton_h__
#define __KButton_h__

#include <Button.h>
#include <List.h>

class KButton : public BButton
{
	public:
		KButton(BRect frame
				, const char* name
				, const char* label
				, BMessage* message
				, uint32 resizeMask = B_FOLLOW_LEFT | B_FOLLOW_TOP
				, uint32 flags = B_WILL_DRAW | B_NAVIGABLE);
		
		void	MouseUp(BPoint point);
		void	KeyDown(const char* bytes, int32 numBytes);
		
		void	AddView(BTextView* textview){ viewList.AddItem(textview); }
		void	RemoveView(BTextView* textview){ viewList.RemoveItem(textview); }
		
	private:
		BList	viewList;
};

#endif