#include "KMenuBar.h"

#include <stdio.h>
#include <string.h>
#include <MenuItem.h>
#include <Path.h>
#include <Directory.h>
#include <Entry.h>
#include <File.h>
#include <FindDirectory.h>
#include <SymLink.h>
#include <Application.h>
#include <string.h>
#include <Roster.h>


#include "KWindow.h"
#include "KTextView.h"
#include "KApp.h"

#include "KMenuUtils.h"
#include "KTextUtils.h"

KMenuBar::KMenuBar(BRect frame, const char* title)
	: BMenuBar(frame, title)
{
	fMessageList.MakeEmpty();
	
	
	this->SetUpMenus();
}


void
KMenuBar::AttachedToWindow()
{
	int32	count = fMessageList.CountItems();
	
	for(int32 i = 0; i < count; i++){
		((BMessage*)fMessageList.ItemAt(i))->AddPointer("window", this->Window());
	}
	this->BMenuBar::AttachedToWindow();
}


void
KMenuBar::UpdateMenus()
{
	KTextView*	textview = (KTextView*)this->Window()->FindView("textview");
	bool		status = true;
	BMenu*		aMenu;
	BMenu*		aSubMenu;
	BMenuItem*	aMenuItem;
	BMenuItem*	aSubMenuItem;
	BMenuItem*	aDeepMenuItem;
	
	
	//"File"
	aMenuItem = (BMenuItem*)this->FindItem(kFileMenuName);
	aMenu = (BMenu*)aMenuItem->Submenu();
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kSaveMenuItemName);
	
	status = ((KWindow*)this->Window())->GetDirty();
	if(aSubMenuItem->IsEnabled() != status)
		aSubMenuItem->SetEnabled(status);
		
	
	//"Font"
	aMenuItem = (BMenuItem*)this->FindItem(kFontMenuName);
	aMenu = (BMenu*)aMenuItem->Submenu();
	
	BFont	font(textview->BaseFont());
	
	float	size = font.Size();
	char	sizeMenu[16];
	sprintf(sizeMenu, "%d", (int)size);
	
	float	tabwidth = textview->TabWidth();
	char	tabMenu[16];
	sprintf(tabMenu, "%d", (int)tabwidth);
	
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kSizeMenuItemName);
	aSubMenu = (BMenu*)aSubMenuItem->Submenu();
	aDeepMenuItem = (BMenuItem*)aSubMenu->FindItem(sizeMenu);
	if(aDeepMenuItem != NULL)
		aDeepMenuItem->SetMarked(true);
	
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kTabWidthMenuItemName);
	aSubMenu = (BMenu*)aSubMenuItem->Submenu();
	aDeepMenuItem = (BMenuItem*)aSubMenu->FindItem(tabMenu);
	if(aDeepMenuItem != NULL)
		aDeepMenuItem->SetMarked(true);
	
	font_family	family;
	font_style	style;
	font.GetFamilyAndStyle(&family, &style);
	
	KMenuUtils	utils;
	utils.DeMarkAll(aMenu, 3);
	
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(family);
	if(aSubMenuItem != NULL){
		aSubMenuItem->SetMarked(true);
		aSubMenu = (BMenu*)aSubMenuItem->Submenu();
		aDeepMenuItem = (BMenuItem*)aSubMenu->FindItem(style);
		aDeepMenuItem->SetMarked(true);
	}
	
	
	//"Option"
	aMenuItem = (BMenuItem*)this->FindItem(kOptionMenuName);
	aMenu = (BMenu*)aMenuItem->Submenu();
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kWordWrapMenuItemName);
	
	status = textview->DoesWordWrap();
	if(aSubMenuItem->IsMarked() != status)
		aSubMenuItem->SetMarked(status);
	
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kAutoIndentMenuItemName);
	
	status = textview->DoesAutoindent();
	if(aSubMenuItem->IsMarked() != status)
		aSubMenuItem->SetMarked(status);
	
	aSubMenuItem = (BMenuItem*)aMenu->FindItem(kMemorizeMenuItemName);
	
	status = ((KWindow*)this->Window())->DoesMemorizeWindow();
	if(aSubMenuItem->IsMarked() != status)
		aSubMenuItem->SetMarked(status);
	
	aSubMenuItem = (BMenuItem*)(aMenu->FindItem(kHTMLMenuItemName)->Submenu())->FindItem(kUseHTMLMenuItemName);
	
	status = textview->DoesHTMLSyntax();
	if(aSubMenuItem->IsMarked() != status)
		aSubMenuItem->SetMarked(status);
	
	//"Window"
	aMenuItem = (BMenuItem*)this->FindItem(kWindowMenuName);
	const int32		aIndex = this->IndexOf(aMenuItem);
	const BList		aWindowList = ((KApp*)be_app)->GetWindowList();
	const int32		aWindowCount = aWindowList.CountItems();
	
	aMenu = this->SubmenuAt(aIndex);
	const int32	aMenuCount = aMenu->CountItems();
	for(int32 i = 0; i < aMenuCount; i++){
		delete	aMenu->RemoveItem(aMenuCount - i - 1);
	}
	
	char	str[2];
	for(int32 j = 0; j < aWindowCount; j++){
		KWindow*	aTarget = (KWindow*)aWindowList.ItemAt(j);
		BMessage*	aMessage = new BMessage(K_SWITCH_WINDOW);
		if(j < 9){
			::sprintf(str, "%d", (int8)j + 1);
		}else{
			*str = '\0';
		}
		aMenuItem = new BMenuItem(aTarget->Title(), aMessage, *str, 0);
		aMenuItem->SetTarget(be_app);
		aMenu->AddItem(aMenuItem);
		if(this->Window() == aTarget)
			aMenuItem->SetEnabled(false);
	}
	
	//"Add-ons"
	aMenuItem = (BMenuItem*)this->FindItem(kAddOnMenuName);
	if(aMenuItem != NULL){
		const int32 aIndex = this->IndexOf(aMenuItem);
		aMenu = this->SubmenuAt(aIndex);
		const int32 aMenuCount = aMenu->CountItems();
		for(int32 i = 0; i < aMenuCount; i++){
			delete aMenu->RemoveItem(aMenuCount - i - 1);
		} 
		this->MakeAddOnMenu(aMenu);
	}
	
	
}


void
KMenuBar::SetUpMenus()
{
	BMenu*		aMenu;
	BMenu*		aSubMenu;
	BMenuItem*	aMenuItem;
	BMessage*	aMessage;
	KMenuUtils	utils;
	
	//"File" menu.
	aMenu = new BMenu(kFileMenuName);
	
	utils.AddMenuItem(aMenu, "New", K_NEW, NULL, be_app, 'N', 0);
	utils.AddMenuItem(aMenu, "Open...", K_OPEN, NULL, be_app, 'O', 0);
	
	aSubMenu = new BMenu("Open Next / Prev. Entry");
	utils.AddMenuItem(aSubMenu, "Open Previous Entry", K_OPEN_PREV_ENTRY, this, NULL, '[', 0);
	utils.AddMenuItem(aSubMenu, "Open Next Entry", K_OPEN_NEXT_ENTRY, this, NULL, ']', 0);
	aMenu->AddItem(aSubMenu);
	
	utils.AddMenuItem(aMenu, "Close", B_QUIT_REQUESTED, this, NULL, 'W', 0);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, kSaveMenuItemName, K_SAVE, this, NULL, 'S', 0);
	utils.AddMenuItem(aMenu, "Save As...", K_SAVE_AS, this);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, "Text Info...", K_INFORMATION, this, NULL, 'I', 0);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, "About...", B_ABOUT_REQUESTED, NULL, be_app);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, "Quit", B_QUIT_REQUESTED, NULL, be_app, 'Q', 0);
	this->AddItem(aMenu);
	
	//"Edit" menu.
	aMenu = new BMenu("Edit");
	
	utils.AddMenuItem(aMenu, "Undo", B_UNDO, this, NULL, 'Z', 0);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, "Cut", B_CUT, this, NULL, 'X', 0);
	utils.AddMenuItem(aMenu, "Copy", B_COPY, this, NULL, 'C', 0);
	utils.AddMenuItem(aMenu, "Paste", B_PASTE, this, NULL, 'V', 0);
	utils.AddMenuItem(aMenu, "Select All", B_SELECT_ALL, this, NULL, 'A', 0);
	aMenu->AddSeparatorItem();
	
	aMessage = new BMessage(K_FIND);
	fMessageList.AddItem(aMessage);
	aMenuItem = new BMenuItem("Find...", aMessage, 'F', 0);
	aMenuItem->SetTarget(be_app);
	aMenu->AddItem(aMenuItem);
	
	aMessage = new BMessage(K_FIND_AGAIN);
	fMessageList.AddItem(aMessage);
	aMenuItem = new BMenuItem("Find Next", aMessage, 'G', 0);
	aMenuItem->SetTarget(be_app);
	aMenu->AddItem(aMenuItem);
	
	aMessage = new BMessage(K_REPLACE);
	fMessageList.AddItem(aMessage);
	aMenuItem = new BMenuItem("Replace", aMessage, 'R', 0);
	aMenuItem->SetTarget(be_app);
	aMenu->AddItem(aMenuItem);
	
	aMessage = new BMessage(K_REPLACE_AND_FIND_AGAIN);
	fMessageList.AddItem(aMessage);
	aMenuItem = new BMenuItem("Replace and Find Again", aMessage, 'H', 0);
	aMenuItem->SetTarget(be_app);
	aMenu->AddItem(aMenuItem);
	
	aMenu->AddSeparatorItem();
	
	aMessage = new BMessage(K_SHOW_GO_TO_LINE_WINDOW);
	fMessageList.AddItem(aMessage);
	aMenuItem = new BMenuItem("Go To Line...", aMessage, 'U', 0);
	aMenuItem->SetTarget(be_app);
	aMenu->AddItem(aMenuItem);
	
	this->AddItem(aMenu);
	
	//"Font" menu.
	
	aMenu = new BMenu(kFontMenuName);
	
	//->"Size" sub menu.
	BMenu*	sizeMenu = new BMenu(kSizeMenuItemName);
	char	fontSize[16];
	
	for(int32 i = 0; i < 9; i++){
		sprintf(fontSize, "%d", kFontSizeSet[i]);
		aMessage = new BMessage(K_SIZE);
		aMessage->AddFloat("font_size", (float)kFontSizeSet[i]);
		BMenuItem*	sizeItem = new BMenuItem(fontSize, aMessage);
		sizeItem->SetTarget(this->Window());
		sizeMenu->AddItem(sizeItem);
	}
	sizeMenu->SetRadioMode(true);
	aMenu->AddItem(sizeMenu);
	
	//->"Tab Width" sub menu.
	BMenu*	tabMenu = new BMenu(kTabWidthMenuItemName);
	char	tabWidth[16];
	
	for(int32 i = 1; i <= 15; i++){
		::sprintf(tabWidth, "%ld", 7 * i);
		aMessage = new BMessage(K_TAB_WIDTH);
		aMessage->AddFloat("tab_width", (float)7 * i);
		BMenuItem*	tabItem = new BMenuItem(tabWidth, aMessage);
		tabItem->SetTarget(this->Window());
		tabMenu->AddItem(tabItem);
	}
	tabMenu->SetRadioMode(true);
	aMenu->AddItem(tabMenu);
	
	aMenu->AddSeparatorItem();
	
	utils.AddFontMenu(aMenu, K_STYLE, NULL, this->Window());
	
	this->AddItem(aMenu);
	
	
	//"Text" menu.
	aMenu = new BMenu(kTextMenuName);
	utils.AddMenuItem(aMenu, "---Tags---", 0, NULL);
	aMenu->ItemAt(0)->SetEnabled(false);
	this->ConstructTagMenu(aMenu);
	
	aMenu->AddSeparatorItem();
	
	//"Text/Figuration" menu.
	
	aSubMenu = new BMenu("Figuration");
	utils.AddMenuItem(aSubMenu, "Shift - Right", K_TEXT_SHIFT_RIGHT, this, NULL, '.', 0);
	utils.AddMenuItem(aSubMenu, "Shift - Left", K_TEXT_SHIFT_LEFT, this, NULL, ',', 0);
	aSubMenu->AddSeparatorItem();
	utils.AddMenuItem(aSubMenu, "Shift with prefix - Right", K_TEXT_SHIFT_PREFIX_RIGHT, this, NULL, '\'', 0);
	utils.AddMenuItem(aSubMenu, "Shift with prefix - Left", K_TEXT_SHIFT_PREFIX_LEFT, this, NULL, ';', 0);
	aSubMenu->AddSeparatorItem();
	utils.AddMenuItem(aSubMenu, "Wrap with Return", K_TEXT_WRAP_LINE, this, NULL, 'K', 0);
	utils.AddMenuItem(aSubMenu, "Remove Returns", K_TEXT_REMOVE_RETURNS, this, NULL, 'K', B_OPTION_KEY);
	aMenu->AddItem(aSubMenu);
	
	aMenu->AddSeparatorItem();
	
	//"Text/Email&URL" menu.
	utils.AddEmailAddressMenu(aMenu, K_EMAIL_ADDRESS, NULL, this->Window());
	utils.AddURLMenu(aMenu, K_URL_STRING, NULL, this->Window());
	
	////Add Menu "Open UerTag file" to "Tag" menu.
	BEntry	aEntry;
	BFile	aFile;
	if(this->GetUserTagFileEntry(&aEntry) == B_NO_ERROR
			&& aFile.SetTo(&aEntry, B_READ_ONLY) == B_NO_ERROR)
	{	
		entry_ref	aRef;
		aEntry.GetRef(&aRef);
		BMessage*	aMessage = new BMessage(B_REFS_RECEIVED);
		aMessage->AddRef("refs", &aRef);
		BMenuItem*		aMenuItem = new BMenuItem(kOpenUserTagFileItemName, aMessage);
		aMenuItem->SetTarget(be_app);
		
		aMenu->AddSeparatorItem();
		aMenu->AddItem(aMenuItem);
	}
	
	this->AddItem(aMenu);
	
	//"Option" menu.
	aMenu = new BMenu(kOptionMenuName);
	
	utils.AddMenuItem(aMenu, "Preference...", K_SHOW_PREFS_WINDOW, NULL, be_app);
	aMenu->AddSeparatorItem();
	utils.AddMenuItem(aMenu, kWordWrapMenuItemName, K_WORD_WRAP, this, NULL, 'D', 0);
	utils.AddMenuItem(aMenu, kAutoIndentMenuItemName, K_AUTO_INDENT, this);
	utils.AddMenuItem(aMenu, kMemorizeMenuItemName, K_MEMORIZE_WINDOW, this);
	
	aMenu->AddSeparatorItem();
	
	//"Option/HTML" menu.
	aSubMenu = new BMenu(kHTMLMenuItemName);
	
	utils.AddMenuItem(aSubMenu, kUseHTMLMenuItemName, K_USE_HTML_SYNTAX, this, NULL, 'M', B_OPTION_KEY);
	utils.AddMenuItem(aSubMenu, "Open with a Web Browser", K_OPEN_WITH_BROWSER, this, NULL, 'O', B_OPTION_KEY);
	aMenu->AddItem(aSubMenu);
	
	//"Option/E-mail" menu.
	aSubMenu = new BMenu(kEmailMenuItemName);
	
	utils.AddMenuItem(aSubMenu, "Reply To", K_REPLY_TO_SENDER, this, NULL, 'T', 0);
	utils.AddMenuItem(aSubMenu, "Forward", K_MAIL_FORWORD, this, NULL, 'F', B_OPTION_KEY);
	
	aSubMenu->AddSeparatorItem();
	
	utils.AddMenuItem(aSubMenu, "Send Later", K_SEND_EMAIL_LATER, this, NULL, 'M', 0);
	utils.AddMenuItem(aSubMenu, "Send Now", K_SEND_EMAIL_NOW, this, NULL, 'M', B_SHIFT_KEY);
	aMenu->AddItem(aSubMenu);
	
	aSubMenu->AddSeparatorItem();
	
	utils.AddMenuItem(aSubMenu, "Show Headers", K_SHOW_HEADERS, this, NULL);
	
	aSubMenu->AddSeparatorItem();
	
	utils.AddMenuItem(aSubMenu, "Open With BeMail", K_OPEN_WITH_BEMAIL, this, NULL);
	
	this->AddItem(aMenu);
	
	//"Window" menu.
	aMenu = new BMenu(kWindowMenuName);
	
	this->AddItem(aMenu);
	
	//"Add-on" menu.
	aMenu = new BMenu(kAddOnMenuName);
	if(this->MakeAddOnMenu(aMenu) != B_NO_ERROR){
		delete	aMenu;
	}else{
		this->AddItem(aMenu);
	}
	
	
}


void
KMenuBar::ConstructTagMenu(BMenu* menu)
{
	if(!this->MakeUserTagMenu(menu)){
		this->MakeDefTagMenu(menu);
	}
}


bool
KMenuBar::MakeUserTagMenu(BMenu* menu)
{	
	KTextUtils	utils;
	
	BEntry	aEntry;
	BFile	aFile;
	
	if(this->GetUserTagFileEntry(&aEntry) != B_NO_ERROR){ return false; }
	if(aFile.SetTo(&aEntry, B_READ_ONLY) != B_NO_ERROR){ return false; }
	
	aFile.Lock();
	
	off_t	aFileSize;
	aFile.GetSize(&aFileSize);
	
	char*	aText = new char[aFileSize + 1];
	aFile.Read(aText, aFileSize);
	aText[aFileSize] = '\0';
	
	aFile.Unlock();
	
	//printf("%s\n", aText);
	
	BList	aLineList;
	
	int32	len = strlen(aText);
	int32	cur = 0;
	for(int32 i = 0; i <= len; i++){
		if(*(aText + i) == LF || i == len){
			int32	textLen = i - cur;
			char*	aNewText = new char[textLen + 1];
			aNewText[textLen] = '\0';
			strncpy(aNewText, aText + cur, textLen);
			aLineList.AddItem(aNewText);
			cur = i + 1;
		}
	}
	int32	aListLen = aLineList.CountItems();
	char*	aMenuName = NULL;
	char	aShortcut = 0;
	uint32	aModifiers = 0;
	char*	aPreString = NULL;
	char*	aPostString = NULL;
	BMenu*	aSubMenu = NULL;
	
	for(int32 i = 0; i < aListLen; i++){
		char*	aLine = (char*)aLineList.ItemAt(i);
		int32	aLen = strlen(aLine);
		if(strncmp("//", aLine, 2) == 0
			|| aLen == 0){
			continue;
		}
		char*	aCommand = new char[aLen + 1];
		char*	aData = new char[aLen + 1];
		aCommand[0] = aData[0] = '\0';
		
		for(int32 j = 0; j <= aLen; j++){
			if(!((*(aLine + j) >= 'a' && *(aLine + j) <= 'z')
						|| (*(aLine + j) >= 'A' && *(aLine + j) <= 'Z')
						|| (*(aLine + j) == '_'))
					|| (*(aLine + j) == '\0')){
				strncpy(aCommand, aLine, j);
				aCommand[j] = '\0';
				break;
			}
		}
		utils.ToUpperCase(aCommand);
		for(int32 j = 0; j <= aLen; j++){
			if(*(aLine + j) == '"'){
				strcpy(aData, aLine + j);
				utils.Decode_C_String(aData);
				break;
			}
		}
		if(strcmp(aCommand, "MAKE_NEW_SUBMENU") == 0){
			aSubMenu = new BMenu(aData);
			//delete?
		}else if(strcmp(aCommand, "ADD_SUBMENU") == 0){
			menu->AddItem(aSubMenu);
		}else if(strcmp(aCommand, "MAKE_NEW_ITEM") == 0){
			aMenuName = aData;
			aPreString = new char[1];
			aPostString = new char[1];
			aPreString[0] = aPostString[0] = '\0';
		}else if(strcmp(aCommand, "SET_PRE_STRING") == 0){
			delete[]	aPreString;
			aPreString = aData;
		}else if(strcmp(aCommand, "SET_POST_STRING") == 0){
			delete[]	aPostString;
			aPostString = aData;
		}else if(strcmp(aCommand, "SET_SHORTCUT") == 0){
			if(strcmp(aData, "RETURN") == 0){
				aShortcut = B_RETURN;
			}else if(strcmp(aData, "TAB") == 0){
				aShortcut = B_TAB;
			}else if(strcmp(aData, "SPACE") == 0){
				aShortcut = B_SPACE;
			}else{
				aShortcut = *aData;
			}
			delete[]	aData;
		}else if(strcmp(aCommand, "SET_MODIFIERS") == 0){
			if(strstr(aData, "opt") != NULL){
				aModifiers = aModifiers | B_OPTION_KEY;
			}
			if(strstr(aData, "ctrl") != NULL){
				aModifiers = aModifiers | B_CONTROL_KEY;
			}
			if(strstr(aData, "shift") != NULL){
				aModifiers = aModifiers | B_SHIFT_KEY;
			}
			delete[]	aData;
		}else if(strcmp(aCommand, "ADD_ITEM") == 0){
			if(aMenuName != NULL){
				if(aSubMenu == NULL){
					aSubMenu = new BMenu("At first, please make a submenu.");
				}
				aSubMenu->AddItem(MakeTagMenuItem(aMenuName, aPreString, aPostString, aShortcut, aModifiers));
				delete[]	aMenuName;
				delete[]	aPreString;
				delete[]	aPostString;
				aMenuName = aPreString = aPostString = NULL;
				aShortcut = aModifiers = 0;
			}
		}else{
			delete[]	aData;
		}
		
		
		delete[]	aLine;
		delete[]	aCommand;
	}
	
	delete[]	aText;
	
	return true;
}


void
KMenuBar::MakeDefTagMenu(BMenu* menu)
{
	BMenu*		aMenu;
	
	aMenu = new BMenu("Text");
	
	aMenu->AddItem(MakeTagMenuItem("STRONG", "<STRONG>", "</STRONG>", 'B', 0));
	aMenu->AddItem(MakeTagMenuItem("BR", "<BR>\n", "", B_RETURN, 0));
	aMenu->AddItem(MakeTagMenuItem("P", "\n<P>\n", "", B_RETURN, B_OPTION_KEY));
	aMenu->AddItem(MakeTagMenuItem("HR", "<HR>", "", 0, 0));
	aMenu->AddItem(MakeTagMenuItem("CENTER", "<CENTER>", "</CENTER>", 0, 0));
	aMenu->AddItem(MakeTagMenuItem("BLOCKQUOTE", "<BLOCKQUOTE>", "</BLOCKQUOTE>", B_TAB, 0));
	aMenu->AddItem(MakeTagMenuItem("PRE", "<PRE>", "</PRE>", 0, 0));
	
	menu->AddItem(aMenu);
	
	aMenu = new BMenu("Characters");
	
	aMenu->AddItem(MakeTagMenuItem("<", "&lt;", "", '[', B_OPTION_KEY));
	aMenu->AddItem(MakeTagMenuItem(">", "", "&gt;", ']', B_OPTION_KEY));
	aMenu->AddItem(MakeTagMenuItem("&", "&amp;", "", '7', B_OPTION_KEY));
	aMenu->AddItem(MakeTagMenuItem("\"", "&quot;", "", 'P', B_OPTION_KEY));
	
	menu->AddItem(aMenu);
	
	aMenu = new BMenu("Link");
	
	aMenu->AddItem(MakeTagMenuItem("A HREF", "<A HREF=\"\">", "</A>", 0, 0));
	aMenu->AddItem(MakeTagMenuItem("A NAME", "<A NAME>", "</A>", 0, 0));
	aMenu->AddItem(MakeTagMenuItem("IMG SRC", "<IMG SRC=\"\" WIDTH=\"\" HEIGHT=\"\" ALT=\"\">", "", 0, 0));
	
	menu->AddItem(aMenu);
	
	aMenu = new BMenu("Meta");
	
	aMenu->AddItem(MakeTagMenuItem("Content-Type", "<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n\0", "", 0, 0));
	
	menu->AddItem(aMenu);
}


BMenuItem*
KMenuBar::MakeTagMenuItem(const char* name
							, const char* pre, const char* post
							, char shortcut, uint32 modifiers)
{
	BMessage*	aMessage = new BMessage(K_HTML_TAG);
	aMessage->AddString("pretag", pre);
	aMessage->AddString("posttag", post);
	BMenuItem*	aMenuItem = new BMenuItem(name, aMessage, shortcut, modifiers);
	aMenuItem->SetTarget(this->Window());
	
	return aMenuItem;
}

status_t
KMenuBar::MakeAddOnMenu(BMenu* menu)
{
	app_info	info;
	be_app->GetAppInfo(&info);
	
	BEntry		aAppEntry(&info.ref);
	BPath		aPath;
	aAppEntry.GetPath(&aPath);
	aPath.GetParent(&aPath);
	aPath.Append(kAddOnDirNameInAppDir);
	
	BDirectory	aAddOnDir_App(aPath.Path());
	
	::find_directory(B_USER_ADDONS_DIRECTORY, &aPath, true);
	aPath.Append(kAddOnDirNameInConfigDir);
	
	BDirectory	aAddOnDir_User(aPath.Path());
	
	status_t	aExistApp, aExistUser;
	aExistApp = aAddOnDir_App.InitCheck();
	aExistUser = aAddOnDir_User.InitCheck();
	
	if(aExistUser == B_NO_ERROR)
		this->AddAddOnMenu(menu, aAddOnDir_User);
	if(aExistApp == B_NO_ERROR && aExistUser == B_NO_ERROR)
		menu->AddSeparatorItem();
	if(aExistApp == B_NO_ERROR)
		this->AddAddOnMenu(menu, aAddOnDir_App);
		
	if(aExistApp != B_NO_ERROR && aExistUser != B_NO_ERROR){ return B_ERROR; }
	
	
	
	return B_NO_ERROR;
}

void
KMenuBar::AddAddOnMenu(BMenu* menu, BDirectory aDir)
{
	BEntry	aEntry;
	while(aDir.GetNextEntry(&aEntry) == B_NO_ERROR){
		if(aEntry.InitCheck() != B_NO_ERROR){ continue; }
		char	aName[B_FILE_NAME_LENGTH];
		aEntry.GetName(aName);
		if(aEntry.IsSymLink()){
			BSymLink aLink(&aEntry);
			BPath aPath;
			aLink.MakeLinkedPath(&aDir, &aPath);
			aEntry.SetTo(aPath.Path());
		}
		
		if(aEntry.IsDirectory()){
			BMenu*	aMenu = new BMenu(aName);
			BDirectory	dir(&aEntry);
			this->AddAddOnMenu(aMenu, dir);
			menu->AddItem(aMenu);
			
		}else if(aEntry.IsFile()){
			entry_ref	aRef;
			if(aEntry.IsSymLink()){
				BDirectory	aDir;
				BPath		aPath;
				BSymLink	aSymLink(&aEntry);
				aSymLink.MakeLinkedPath(&aDir, &aPath);
				aEntry.SetTo(&aDir, aPath.Path());
			}
			aEntry.GetRef(&aRef);
			BMessage*	aMessage = new BMessage(K_EXEC_ADD_ON);
			
			char	aChar[] = "\0";
			int32	len = strlen(aName);
			if(len >= 2 && *(aName + len - 2) == '-'){
				*aChar = *(aName + len - 1);
				*(aName + len -2) = '\0';
			}
			
			aMessage->AddRef("refs", &aRef);
			BMenuItem*	aItem = new BMenuItem(aName, aMessage, *aChar, B_OPTION_KEY);
			menu->AddItem(aItem);
		}
		
	}
}


status_t
KMenuBar::GetUserTagFileEntry(BEntry* entry)
{
	BPath		aPath;
	BDirectory	aDir;
	BEntry		aEntry;
	BFile		aFile;
	
	find_directory(B_USER_SETTINGS_DIRECTORY, &aPath, true);
	if(aDir.SetTo(aPath.Path()) != B_NO_ERROR){ return B_ERROR; }
	if(aDir.FindEntry(kSettingDir, &aEntry) != B_NO_ERROR){ return B_ERROR; }
	if(aEntry.InitCheck() != B_NO_ERROR){ return B_ERROR; }
	if(aDir.SetTo(&aEntry) != B_NO_ERROR){ return B_ERROR; }
	if(aDir.FindEntry(kUserTagFileName, &aEntry) != B_NO_ERROR){ return B_ERROR; }
	if(aEntry.InitCheck() != B_NO_ERROR){ return B_ERROR; }
	
	*entry = aEntry;
	
	return B_OK;
}



















