#include "KMenuUtils.h"

#include <Font.h>
#include <Menu.h>
#include <MenuItem.h>
#include <VolumeRoster.h>
#include <Query.h>
#include <Path.h>
#include <Directory.h>
#include <FindDirectory.h>
#include <SymLink.h>
#include <fs_attr.h>
#include <stdio.h>


KMenuUtils::KMenuUtils()
{
	
}

void
KMenuUtils::AddFontMenu(BMenu* menu, uint32 what 
						,const BHandler* handler, const BLooper* looper)
{
	const int32	fontNum = count_font_families();
	font_family	fFamily;
	font_style	fStyle;
	BMenu*		styleMenu;
	BMenuItem*	styleItem;
	
	for(int32 i = 0; i < fontNum; i++){
		get_font_family(i,&fFamily);
		styleMenu = new BMenu(fFamily);
		int32 styleNum = count_font_styles(fFamily);
		for(int32 ii = 0; ii < styleNum; ii++){
			get_font_style(fFamily, ii, &fStyle);
			BMessage*	msg = new BMessage(what);
			msg->AddString("font_family", fFamily);
			msg->AddString("font_style", fStyle);
			styleItem = new BMenuItem(fStyle, msg);
			styleMenu->AddItem(styleItem);
			styleItem->SetTarget(handler, looper);
		}
		menu->AddItem(styleMenu);
	}
}


void
KMenuUtils::DeMarkAll(BMenu* menu, int32 fromIndex, int32 toIndex){
	const int32	itemNum = menu->CountItems();
	if(toIndex == 0 || toIndex > itemNum){
		toIndex = itemNum;
	}
	BMenu*	submenu;
	for(int32 i = fromIndex; i < toIndex; i++){
		menu->ItemAt(i)->SetMarked(false);
		submenu = menu->SubmenuAt(i);
		if(submenu != NULL){
			DeMarkAll(submenu);
		}
	}
}


void
KMenuUtils::AddMenuItem(BMenu* menu
							, const char* name
							, const uint32 what
							, const BHandler* handler
							, const BLooper* looper
							, char shortcut
							, uint32 modifiers)
{
	BMenuItem*	aMenuItem = new BMenuItem(name, new BMessage(what), shortcut, modifiers);
	aMenuItem->SetTarget(handler, looper);
	menu->AddItem(aMenuItem);
}


void
KMenuUtils::AddEmailAddressMenu(BMenu* menu
						, uint32 what
						, const BHandler*	handler
						, const BLooper* 	looper
						, bool use_query)
{
	BEntry			aEntry;
	//char	aFileName[B_FILE_NAME_LENGTH];
	BMenu*	aMenu = new BMenu("Email Address");
	
	if(use_query){
		BQuery			aQuery;
		BVolume			aVolume;
		BVolumeRoster	aVolumeRoster;
		char			aQueryString[256];
	
		aVolumeRoster.GetBootVolume(&aVolume);
		aQuery.SetVolume(&aVolume);
		::sprintf(aQueryString, "(%s == *) && (%s == %s)", kEmail, kType, kPerson);
		aQuery.SetPredicate(aQueryString);
		aQuery.Fetch();
		while(aQuery.GetNextEntry(&aEntry) == B_NO_ERROR){
			this->_ADD_PERSON_ITEM(aMenu, &aEntry, K_ADD_EMAIL, what, handler, looper);
		}
	}else{
		BPath		aPath;
		::find_directory(B_USER_DIRECTORY, &aPath, true);
		aPath.Append("people");
		BDirectory	aPeopleDir(aPath.Path());
		if(aPeopleDir.InitCheck() == B_NO_ERROR){
			while(aPeopleDir.GetNextEntry(&aEntry) == B_NO_ERROR){
				this->_ADD_PERSON_ITEM(aMenu, &aEntry, K_ADD_EMAIL, what, handler, looper);
			}
		}
		
	}
	
	menu->AddItem(aMenu);
}


void
KMenuUtils::AddURLMenu(BMenu* menu
						, uint32 what
						, const BHandler*	handler
						, const BLooper* 	looper
						, bool use_query)
{
	BPath		aPath;
	::find_directory(B_USER_SETTINGS_DIRECTORY, &aPath, true);
	aPath.Append("NetPositive");
	aPath.Append("Bookmarks");
	
	BDirectory	aBookmarksDir(aPath.Path());
	if(aBookmarksDir.InitCheck() != B_NO_ERROR){ return; }
	
	BMenu*	aMenu = new BMenu("URL");
	this->_ADD_URL_ITEM_PEOPLE(aMenu, what, handler, looper, use_query);
	aMenu->AddSeparatorItem();
	this->_ADD_URL_ITEM_BOOKMARK(aMenu, aBookmarksDir, what, handler, looper);
	
	menu->AddItem(aMenu);
}


void
KMenuUtils::_ADD_URL_ITEM_PEOPLE(BMenu* menu
							, uint32 what
							, const BHandler* handler
							, const BLooper* looper
							, bool use_query)
{
	BEntry			aEntry;
	//char	aFileName[B_FILE_NAME_LENGTH];
	BMenu*	aMenu = new BMenu("people");
	
	if(use_query){
		BQuery			aQuery;
		BVolume			aVolume;
		BVolumeRoster	aVolumeRoster;
		char			aQueryString[256];
	
		aVolumeRoster.GetBootVolume(&aVolume);
		aQuery.SetVolume(&aVolume);
		::sprintf(aQueryString, "(%s == *) && (%s == %s)", kURL, kType, kPerson);
		aQuery.SetPredicate(aQueryString);
		aQuery.Fetch();
		while(aQuery.GetNextEntry(&aEntry) == B_NO_ERROR){
			this->_ADD_PERSON_ITEM(aMenu, &aEntry, K_ADD_URL, what, handler, looper);
		}
	}else{
		BPath		aPath;
		::find_directory(B_USER_DIRECTORY, &aPath, true);
		aPath.Append("people");
		BDirectory	aPeopleDir(aPath.Path());
		if(aPeopleDir.InitCheck() == B_NO_ERROR){
			while(aPeopleDir.GetNextEntry(&aEntry) == B_NO_ERROR){
				this->_ADD_PERSON_ITEM(aMenu, &aEntry, K_ADD_URL, what, handler, looper);
			}
		}
		
	}
	
	menu->AddItem(aMenu);
}


void
KMenuUtils::_ADD_URL_ITEM_BOOKMARK(BMenu* menu, BDirectory dir, uint32 what
							,const BHandler* handler, const BLooper* looper)
{	
	BEntry	aEntry;
	while(dir.GetNextEntry(&aEntry) == B_NO_ERROR){
		char	aName[B_FILE_NAME_LENGTH];
		aEntry.GetName(aName);
		
		//Make SymLink to Real Path.
		if(aEntry.IsSymLink()){
			BDirectory	aDirectory;
			BPath		aPath;
			BSymLink	aSymLink(&aEntry);
			aSymLink.MakeLinkedPath(&aDirectory, &aPath);
			aEntry.SetTo(&aDirectory, aPath.Path());
			if(aEntry.InitCheck() != B_NO_ERROR){ continue; }
		}
		
		
		if(aEntry.IsDirectory()){
			BMenu*		aSubMenu = new BMenu(aName);
			BDirectory	aDirectory(&aEntry);
			this->_ADD_URL_ITEM_BOOKMARK(aSubMenu, aDirectory, what, handler, looper);
			menu->AddItem(aSubMenu);
			
		}else if(aEntry.IsFile()){
			aEntry.GetName(aName);
			BFile	aFile(&aEntry, O_RDONLY);
			
			attr_info	aTitleInfo, aURLInfo;
			
			if((aFile.InitCheck() == B_NO_ERROR)
					&& (aFile.GetAttrInfo(kTitle, &aTitleInfo) == B_NO_ERROR)
					&& (aTitleInfo.size > 1)
					&& (aFile.GetAttrInfo(kURL, &aURLInfo) == B_NO_ERROR)
					&& (aURLInfo.size > 1)){
				char*	aTitle = new char[aTitleInfo.size];
				char*	aURL = new char[aURLInfo.size];
			
				aFile.ReadAttr(kTitle, B_STRING_TYPE, 0, aTitle, aTitleInfo.size);
				aFile.ReadAttr(kURL, B_STRING_TYPE, 0, aURL, aURLInfo.size);
			
				BMessage*	aMessage = new BMessage(what);
				aMessage->AddString("page_title", aTitle);
				aMessage->AddString("url_string", aURL);
				BMenuItem*	aItem = new BMenuItem(aTitle, aMessage);
				aItem->SetTarget(handler, looper);
				menu->AddItem(aItem);
			
				delete[]	aTitle;
				delete[]	aURL;
			}
		}
	}
}


void
KMenuUtils::_ADD_PERSON_ITEM(BMenu* menu
						, BEntry* entry
						, item_type type
						, uint32 what
						, const BHandler*	handler
						, const BLooper*	looper)
{
	BFile	aFile;
	attr_info		aItemInfo, aNameInfo;
	
	/* if using query, 'entry' always points a file or a symlink. */
	if(entry->IsDirectory()){
		BDirectory	aDirectory(entry);
		BEntry		aSubEntry;
		char	aMenuName[B_FILE_NAME_LENGTH];
		entry->GetName(aMenuName);
		BMenu*	aSubMenu = new BMenu(aMenuName);
		while(aDirectory.GetNextEntry(&aSubEntry) == B_NO_ERROR){
			this->_ADD_PERSON_ITEM(aSubMenu, &aSubEntry, type, what, handler, looper);
		}
		menu->AddItem(aSubMenu);
	}else{
		aFile.SetTo(entry, O_RDONLY);
		char	aMetaText1[256];
		if(type == K_ADD_EMAIL){
			::strcpy(aMetaText1, kEmail);
		}else if(type == K_ADD_URL){
			::strcpy(aMetaText1, kURL);
		}
		
		if((aFile.InitCheck() == B_NO_ERROR)
				&& (aFile.GetAttrInfo(aMetaText1, &aItemInfo) == B_NO_ERROR)
				&& (aItemInfo.size > 1)
				&& (aFile.GetAttrInfo(kName, &aNameInfo) == B_NO_ERROR)
				&& (aNameInfo.size > 1)){
			char*	aItemText = new char[aItemInfo.size];
			char*	aName = new char[aNameInfo.size];
			char*	aMenuName = new char[aItemInfo.size + aNameInfo.size + 10];
			
			BMessage*	aMessage = new BMessage(what);
			BMenuItem*	aItem;
			
			if(type == K_ADD_EMAIL){
				aFile.ReadAttr(kEmail, B_STRING_TYPE, 0, aItemText, aItemInfo.size);
				aFile.ReadAttr(kName, B_STRING_TYPE, 0, aName, aNameInfo.size);
				::sprintf(aMenuName, "%s (%s)\n", aName, aItemText);
				aMessage->AddString("name", aName);
				aMessage->AddString("email_address", aItemText);
				aItem = new BMenuItem(aMenuName, aMessage);
			}else if(type == K_ADD_URL){
				aFile.ReadAttr(kURL, B_STRING_TYPE, 0, aItemText, aItemInfo.size);
				aFile.ReadAttr(kName, B_STRING_TYPE, 0, aName, aNameInfo.size);
				::sprintf(aMenuName, "%s", aName);
				aMessage->AddString("page_title", aName);
				aMessage->AddString("url_string", aItemText);
				aItem = new BMenuItem(aMenuName, aMessage);
			}
			
			aItem = new BMenuItem(aMenuName, aMessage);
			aItem->SetTarget(handler, looper);
			menu->AddItem(aItem);
		
			delete[]	aMenuName;
			delete[]	aItemText;
			delete[]	aName;
		}
	}
	
	
}






















