#ifndef __KMenuUtils_h__
#define __KMenuUtils_h__

#include <SupportDefs.h>

const char		kEmail[]	= "META:email";
const char		kURL[]		= "META:url";
const char		kName[]		= "META:name";
const char		kTitle[]	= "META:title";
const char		kType[]		= "BEOS:TYPE";
const char		kPerson[]	= "application/x-person";

class BMenu;
class BHandler;
class BLooper;

class KMenuUtils
{
	public:
		KMenuUtils(void);
	
		void	AddFontMenu(BMenu* menu
						, uint32 what 
						, const BHandler*	handler = NULL
						, const BLooper* 	looper = NULL);
		void	DeMarkAll(BMenu* menu
						, int32 fromIndex = 0
						, int32 toIndex = 0);
		
		void	AddMenuItem(BMenu* menu
						, const char* name
						, const uint32 what
						, const BHandler* handler
						, const BLooper* looper = NULL
						, char shortcut = 0
						, uint32 modifiers = 0);
		
		
		void	AddEmailAddressMenu(BMenu* menu
						, uint32 what
						, const BHandler*	handler = NULL
						, const BLooper* 	looper = NULL
						, bool use_query = false);
		
		void	AddURLMenu(BMenu* menu
						, uint32 what
						, const BHandler*	handler = NULL
						, const BLooper* 	looper = NULL
						, bool use_query = false);
	
	private:
		void	_ADD_URL_ITEM_PEOPLE(BMenu* menu
						, uint32 what
						, const BHandler*	handler
						, const BLooper*	looper
						, bool use_query = false);
		void	_ADD_URL_ITEM_BOOKMARK(BMenu* menu
						, BDirectory dir
						, uint32 what
						, const BHandler*	handler
						, const BLooper* 	looper);
						
		enum item_type {
			K_ADD_EMAIL = 0,
			K_ADD_URL
		};
		
		void	_ADD_PERSON_ITEM(BMenu* menu
						, BEntry* entry
						, item_type type 
						, uint32 what
						, const BHandler*	handler
						, const BLooper*	looper);
};

#endif


















