#include <Beep.h>
#include <string.h>
#include "KSearch.h"
#include "KTextUtils.h"

KSearch::KSearch(const char* target, bool ignore_case, bool use_regexp)
	: fTargetString(target)
		, fIgnoreCase(ignore_case)
		, fUseRegExp(use_regexp)
{

}

KSearch::~KSearch()
{
	
}

status_t
KSearch::SearchString(const char* find_string, int32* from, int32* to
						, int32 start_offset)
{
	int32	aTargetLen = ::strlen(fTargetString);
	char*	aReturnString = new char[aTargetLen + 1];
	::strcpy(aReturnString, fTargetString);
	
	int32	aFindLen = ::strlen(find_string);
	char*	aFindString = new char[aFindLen + 1];
	::strcpy(aFindString, find_string);
	
	KTextUtils	utils;
	if(fIgnoreCase){
		utils.ToLowerCase(aReturnString);
		utils.ToLowerCase(aFindString);
	}
	
	bool	aIsFoundOut = false;
	if(fUseRegExp){
		beep();
	}else{
		for(int32 i = 0; *(aReturnString + start_offset + i) != '\0'; i++){
			if(strncmp(aReturnString + start_offset + i, aFindString, aFindLen) == 0){
				*from = start_offset + i;
				*to = start_offset + i + aFindLen;
				aIsFoundOut = true;
				break;
			}
		}
	}
	delete[]	aReturnString;
	delete[]	aFindString;
	
	if(aIsFoundOut)
		return B_OK;
	else{
		*from = *to = 0;
		return B_ERROR;
	}
}


status_t
KSearch::ReplaceAll(const char* find_string, const char* replace_string
					, char** return_text, int32* count)
{
	int32	aCount = 0;
	
	int32	aTargetLen = ::strlen(fTargetString);
	int32	aFindLen = ::strlen(find_string);
	int32	aReplaceLen = ::strlen(replace_string);
	
	char*	aTargetCopy = new char[aTargetLen + 1];
	char*	aFindCopy = new char[aFindLen + 1];
	char*	aReturnString = NULL;
	
	::strcpy(aTargetCopy, fTargetString);
	::strcpy(aFindCopy, find_string);
	
	KTextUtils	utils;
	if(fIgnoreCase){
		utils.ToLowerCase(aTargetCopy);
		utils.ToLowerCase(aFindCopy);
	}
	
	if(fUseRegExp){
		//do nothing...
		//::printf("sorry, this version of KSearch does'nt support \"regexp\"\n");
	}else{
		for(int32 i = 0; i < aTargetLen; i++){
			if(::strncmp(aTargetCopy + i, aFindCopy, aFindLen) == 0){
				aCount++;
				i += aFindLen - 1;
			}
		}
		int32	aReturnLen = aTargetLen + aCount * (aReplaceLen - aFindLen);
		aReturnString = new char[aReturnLen + 1];
		*(aReturnString + aReturnLen) = '\0';
		for(int32 i = 0, j = 0; i < aTargetLen; i++, j++){
			if(::strncmp(aTargetCopy + i, aFindCopy, aFindLen) == 0){
				::strcpy(aReturnString + j, replace_string);
				i += aFindLen - 1;
				j += aReplaceLen - 1;
			}else{
				*(aReturnString + j) = *(fTargetString + i);
			}
		}
	}
	*count = aCount;
	*return_text = aReturnString;
	
	delete[]	aTargetCopy;
	delete[]	aFindCopy;
	
	
	return B_OK;
}














