#ifndef __KSearch_H__
#define __KSearch_H__

//KEdit : the class for "search" function
//first - construct KSearch class.
//last - delete KSearch class. The target string will not be deleted.

//Currently, 'use_regexp' flag is not functional.

#include <SupportDefs.h>

class KSearch
{
public:
	KSearch(const char* target
			, bool ignore_case = true
			, bool use_regexp = false);
	~KSearch();
	
	void		SetIgnoreCase(bool ignore_case){ fIgnoreCase = ignore_case; }
	bool		GetIgnoreCase() const { return fIgnoreCase; }
	
	void		SetUseRegExp(bool use_regexp){ fUseRegExp = use_regexp; }
	bool		GetUseRegExp() const { return fUseRegExp; }

	status_t	SearchString(const char* find_stirng, int32* from, int32* to
								, int32 start_offset = 0);
	status_t	ReplaceAll(const char* find_string, const char* replace_string
							, char** return_text, int32* count);
	
		
private:
	const char*	fTargetString;
	bool		fIgnoreCase;
	bool		fUseRegExp;
};

#endif

