#include "KWindow.h"

#include <string.h>
#include <unistd.h>
#include <time.h>
#include <Alert.h>
#include <Beep.h>
#include <FilePanel.h>
#include <NodeInfo.h>
#include <Rect.h>
#include <Entry.h>
#include <Path.h>
#include <be_apps/NetPositive/NetPositive.h>
#include <E-mail.h>
#include <UTF8.h>
#include <Roster.h>
#include <fs_attr.h>
#include <stdio.h>
#include <stdlib.h>


#include "KApp.h"
#include "KView.h"
#include "KMenuBar.h"
#include "KTextView.h"
#include "KBottomView.h"
#include "KPrefs.h"
#include "KAddon.h"
#include "KSearch.h"

#include "KTextUtils.h"
#include "KRectUtils.h"
#include "KTViewUtils.h"
#include "KString.h"
#include "KMailUtils.h"


KWindow::KWindow(BRect frame, const char* name, BEntry* entry)
	:BWindow(frame, name, B_DOCUMENT_WINDOW, 0)
	, fEntry(entry)
{
	fTrackerViewToken = NULL;
	fSavePanel = NULL;
	
	KPrefs*		prefs = ((KApp*)be_app)->GetPrefs();
	bool	flag;
	prefs->GetData("memorize_window_rect", &flag);
	fMemorizeWindow = flag;
	
	this->AddChildren();
	
	if(fEntry != NULL)
		this->Fusion();
	
	this->SetDirty(false);
	
	this->SetPulseRate(150000);
	
	this->SetupShortcut();
	
	//Window Size Limit
	float	min_h, max_h, min_v, max_v;
	this->GetSizeLimits(&min_h, &max_h, &min_v, &max_v);
	this->SetSizeLimits(kMinimumWidowHight, max_h, kMinimumWindowWidth, max_v);
}


KWindow::~KWindow()
{
	delete	fEntry;
	delete	fSavePanel;
	delete	fTrackerViewToken;
}


void
KWindow::AddChildren()
{
	const BRect	aRect(0, 0, 1, 1);
	KMenuBar*	menubar = new KMenuBar(aRect, "menubar");
	this->AddChild(menubar);
	
	BRect	rect(this->Bounds());
	rect.top += menubar->Bounds().Height() + 1;
	
	KView*	view = new KView(rect, "kview");
	this->AddChild(view);
	
	KTextView*	aTextView = (KTextView*)this->FindView("textview");
	
	BRect	aScrRect(0, 0, 20, 10);
	aScrRect.OffsetBy(menubar->Frame().right - 50.0, 3.0);
	
	aTextView->MakeFocus(true);
	
	//fix the scroll bars status...
	aTextView->Insert("\n");
	aTextView->Delete(0, 1);
}


void
KWindow::Fusion()
{
	this->Fusion_PreProcess();
	this->Fusion_Text();
	this->Fusion_PostProcess();
}


void
KWindow::Fusion_PreProcess()
{
	BFile		file(fEntry, B_READ_ONLY);
	KTextView*	textview = (KTextView*)FindView("textview");
	BFont*		font = new BFont(textview->BaseFont());
	
	file.Lock();
	
	//Read Attr.
	float		size;
	font_family	family;
	font_style	style;
	if(file.ReadAttr("size", B_RAW_TYPE, 0,  &size, sizeof(float)) > 0)
		font->SetSize(B_BENDIAN_TO_HOST_FLOAT(size));
	
	ssize_t		ssize1, ssize2;
	ssize1 = file.ReadAttr("fontfamily", B_RAW_TYPE, 0, &family, sizeof(font_family));
	ssize2 = file.ReadAttr("fontstyle", B_RAW_TYPE, 0, &style, sizeof(font_style));
	if(ssize1 > 0 && ssize2 > 0)
		font->SetFamilyAndStyle(family, style);
	
	textview->SetBaseFont(font);
	
	float	tabWidth;
	if(file.ReadAttr("tabwidth", B_RAW_TYPE, 0, &tabWidth, sizeof(float)) > 0)
		textview->SetTabWidth(B_BENDIAN_TO_HOST_FLOAT(tabWidth));
	
	bool	status;
	if(file.ReadAttr("wordwrap", B_RAW_TYPE, 0, &status, sizeof(bool)) > 0){
		if(!status){
			this->MessageReceived(new BMessage(K_WORD_WRAP));
		}
	}
		
	
	if(file.ReadAttr("autoindent", B_RAW_TYPE, 0, &status, sizeof(bool)) > 0)
		textview->SetAutoindent(status);
		
	if(file.ReadAttr("memorize_window_rect", B_RAW_TYPE, 0, &status, sizeof(bool)) > 0)
		this->SetMemorizeWindow(status);
		
	file.Unlock();
	
	//Set the Window Title...
	char	aFileName[B_FILE_NAME_LENGTH];
	fEntry->GetName(aFileName);
	this->SetTitle(aFileName);
}


void
KWindow::Fusion_Text()
{
	enum{
		K_TEXT,
		K_HTML,
		K_EMAIL
	};
	
	//KRectUtils	utils;
	BFile		file(fEntry, B_READ_ONLY);
	KPrefs*		prefs = ((KApp*)be_app)->GetPrefs();
	KTextView*	textview = (KTextView*)FindView("textview");
	KTViewUtils	aKTViewUtils(textview);
	int32		aType = K_TEXT;
	
	bool	aAutoDetection;
	prefs->GetData("auto_detect_filetype", &aAutoDetection);
	
	if(aAutoDetection){
		BNodeInfo	info(&file);
		char*		aFileType = new char[B_MIME_TYPE_LENGTH + 1];
		char*		aFileName = new char[B_FILE_NAME_LENGTH + 1];
		info.GetType(aFileType);
		fEntry->GetName(aFileName);
		int32		aNameLen = strlen(aFileName);
		if(strcmp(aFileType, kTextHTML) == 0
			|| (aNameLen > 5 && !strcmp(aFileName + aNameLen - 5, ".html"))){//HTML
			aType = K_HTML;
		}else if(strcmp(aFileType, kTextEmail) == 0){//E-mail
			aType = K_EMAIL;
		}
		delete[]	aFileType;
		delete[]	aFileName;
	}
	
	
	//Load text...
	file.Lock();
	off_t	fsize;
	file.GetSize(&fsize);
	
	char*	aText = new char[fsize + 1];
	
	file.Read(aText, fsize);
	aText[fsize] = '\0';
	
	file.Unlock();
	
	((KBottomView*)FindView("bottomview"))->ConvertToStandard(&aText);
	
	if(aType == K_EMAIL){
		KMailUtils	aUtils;
		char*	aWindowTitle;
		status_t	err = aUtils.LoadMail(fEntry, &aText, &aWindowTitle);
		if(err == B_NO_ERROR){
			this->SetTitle(aWindowTitle);
		}
	}
	
	textview->Insert(aText);
	aKTViewUtils.ShowTop();
	
	
	//post process...
	if(aType == K_HTML){
		textview->SetHTMLSyntax(true);
		textview->MakeEditable(true);
	}else if(aType == K_TEXT){
		textview->SetHTMLSyntax(false);
		textview->MakeEditable(true);
	}else if(aType == K_EMAIL){
		textview->MakeEditable(false);
		textview->SetHTMLSyntax(false);
	}
	
	
	delete[] aText;
}


void
KWindow::Fusion_PostProcess()
{
	KRectUtils	utils;
	BFile		file(fEntry, B_READ_ONLY);
	KTextView*	textview = (KTextView*)FindView("textview");
	
	
	file.Lock();
	
	if(this->DoesMemorizeWindow()){
		rect_st	rect;
		if(file.ReadAttr("window_frame", B_RAW_TYPE, 0, &rect, sizeof(rect_st)) > 0){
			BRect	aRect = utils.ConvertFromStruct(rect);
			aRect.left = B_BENDIAN_TO_HOST_FLOAT(aRect.left);
			aRect.top = B_BENDIAN_TO_HOST_FLOAT(aRect.top);
			aRect.right = B_BENDIAN_TO_HOST_FLOAT(aRect.right);
			aRect.bottom = B_BENDIAN_TO_HOST_FLOAT(aRect.bottom);
			BPoint	aLeftTop = aRect.LeftTop();
			
			this->MoveTo(aLeftTop);
			this->ResizeTo(aRect.Width(), aRect.Height());
		}
		
		if(file.ReadAttr("textview_bounds", B_RAW_TYPE, 0, &rect, sizeof(rect_st)) > 0 ){
			BRect	aRect = utils.ConvertFromStruct(rect);
			aRect.left = B_BENDIAN_TO_HOST_FLOAT(aRect.left);
			aRect.top = B_BENDIAN_TO_HOST_FLOAT(aRect.top);
			aRect.right = B_BENDIAN_TO_HOST_FLOAT(aRect.right);
			aRect.bottom = B_BENDIAN_TO_HOST_FLOAT(aRect.bottom);
			BPoint	aLeftTop = aRect.LeftTop();
			
			textview->ScrollTo(aLeftTop);
		}
		
		ssize_t	ssize1, ssize2;
		int32	fromOffset, toOffset;
		ssize1 = file.ReadAttr("textview_offset_from", B_RAW_TYPE, 0, &fromOffset, sizeof(int32));
		ssize2 = file.ReadAttr("textview_offset_to", B_RAW_TYPE, 0, &toOffset, sizeof(int32));
		if(ssize1 > 0 && ssize2 > 0){
			textview->Select(B_BENDIAN_TO_HOST_INT32(fromOffset), B_BENDIAN_TO_HOST_INT32(toOffset));
		}
	}
	
	
	
	
	file.Unlock();
}


bool
KWindow::QuitRequested()
{
	if(fDirty){
		::beep();
		
		char	alertText[NAME_MAX + 256];
		const char*	docTitle = Title();
		::strcpy(alertText, "The document named \"");
		::strcat(alertText, docTitle);
		::strcat(alertText, "\" has been changed.\n\nDo you want to save it?");
		BAlert*	alert = new BAlert(B_EMPTY_STRING
							, alertText
							, "Don't Save"
							, "Cancel"
							, "Save");
		alert->SetShortcut(0, 'd');
		alert->SetShortcut(1, B_ESCAPE);
		int32	result = alert->Go();
		
		if(result == 0){
			this->RemoveWindowPointer();
		}else if(result == 1){
			return false;
		}else if(result == 2){
			this->PostMessage(new BMessage(K_SAVE));
			return false;
		}
	}else{
		this->RemoveWindowPointer();
	}
	
	//for Email file...
	this->SetStatusNEW2READ(fEntry);
	
	return true;
}


void
KWindow::MessageReceived(BMessage* msg)
{
	entry_ref	ref;
	BFont*		font;
	KTextView*	textview = dynamic_cast<KTextView*>(this->FindView("textview"));
	KTViewUtils	utils(textview);
	KMailUtils	aMailUtils;
	
	switch(msg->what)
	{
		case K_SAVE:
			if(fEntry == NULL)
				this->ShowSavePanel();
			else
				this->Save();
			break;
		case K_SAVE_AS:
			this->ShowSavePanel();
			break;
		
		case B_SAVE_REQUESTED:
			const char* 	name;
			msg->FindString("name", 0, &name);
			msg->FindRef("directory", 0, &ref);
			this->MakeNewFile(name, &ref);
			this->Save();
			break;
			
		case K_OPEN_NEXT_ENTRY:
		case K_OPEN_PREV_ENTRY:
			{
				if(fEntry == NULL){ break; }
				
				BEntry	aEntry;
				aEntry = *fEntry;
			
			
				if(this->GetDirty()){
					BAlert*	aAlert = new BAlert(B_EMPTY_STRING
									, "This Document was modified.\n"
										"Do you want to save it?"
									, "Don't Save"
									, "Cancel"
									, "Save");
					aAlert->SetShortcut(0, 'd');
					aAlert->SetShortcut(1, B_ESCAPE);
					int32	aResult = aAlert->Go();
			
					if(aResult == 0){
						this->OpenEntriesBeside(msg);
					}else if(aResult == 1){
						;
					}else if(aResult == 2){
						this->PostMessage(new BMessage(K_SAVE));
					}
				}else{
					this->OpenEntriesBeside(msg);
				}
				//this->SetStatusNEW2READ(&aEntry);
			}
			
			break;
		
		case K_INFORMATION:
			this->ShowTextInformation();
			break;
			
		case K_STYLE:
			font = new BFont(textview->BaseFont());
			const char*	family;
			const char*	style;
			msg->FindString("font_family", &family);
			msg->FindString("font_style", &style);
			font->SetFamilyAndStyle(family, style);
			textview->SetBaseFont(font);
			break;
			
		case K_SIZE:
			font = new BFont(textview->BaseFont());
			float	size;
			msg->FindFloat("font_size", &size);
			font->SetSize(size);
			textview->SetBaseFont(font);
			break;
			
		case K_TAB_WIDTH:
			float	tabwidth;
			msg->FindFloat("tab_width", &tabwidth);
			textview->SetTabWidth(tabwidth);
			break;
			
		case K_HTML_TAG:
		case K_EMAIL_ADDRESS:
		case K_URL_STRING:
			this->PostMessage(msg, textview);
			break;
			
		case K_TEXT_SHIFT_RIGHT:
		case K_TEXT_SHIFT_LEFT:
		case K_TEXT_SHIFT_PREFIX_RIGHT:
		case K_TEXT_SHIFT_PREFIX_LEFT:
		case K_TEXT_WRAP_LINE:
		case K_TEXT_REMOVE_RETURNS:
			textview->MessageReceived(msg);
			break;
			
		case K_WORD_WRAP:
		{
			bool	status = textview->DoesWordWrap();
			textview->SetWordWrap(!status);
			BRect	textRect(textview->TextRect());
			if(status)
				textRect.right = kViewWidth;
			else
				textRect.right = textview->Frame().Width();
			
			textview->SetTextRect(textRect);
			break;
		}
		case K_AUTO_INDENT:
			textview->SetAutoindent(!textview->DoesAutoindent());
			break;
			
		case K_MEMORIZE_WINDOW:
			this->SetMemorizeWindow(!this->DoesMemorizeWindow());
			break;
			
		case K_USE_HTML_SYNTAX:
			textview->SetHTMLSyntax(!textview->DoesHTMLSyntax());
			break;
			
		case K_SEND_EMAIL_LATER:
			this->SendEmail(false);
			break;
		
		case K_SEND_EMAIL_NOW:
			this->SendEmail(true);
			break;
		
		case K_REPLY_TO_SENDER:
			if(fEntry != NULL && !textview->IsEditable()){
				aMailUtils.Reply(fEntry);
			}
			break;
		
		case K_MAIL_FORWORD:
			if(fEntry != NULL && !textview->IsEditable()){
				aMailUtils.Forward(fEntry);
			}
			break;
		
		case K_SHOW_HEADERS:
			this->ShowHeaders();
			break;
			
		case K_OPEN_WITH_BROWSER:
			this->OpenWithBrowser();
			break;
			
		case K_OPEN_WITH_BEMAIL:
			this->OpenWithBeMail();
			break;
			
		case K_EXEC_ADD_ON:
		{	
			this->ExecAddon(msg);
			break;
		}
		
		case K_ADDON_MSG: //obsolete...
		{
			KAddon*	aAddon;
			if(msg->FindPointer("add-on", (void**)&aAddon) == B_NO_ERROR){
				aAddon->Execute(msg, this);
			}else{ ::beep(); }
			
			break;
		}
			
		case M_SHORT_CUT_KEYS:
			int32	key;
			msg->FindInt32("key", &key);
			switch(key)
			{
				case B_RIGHT_ARROW:
					utils.ShowLineBottom();
					break;
				case B_LEFT_ARROW:
					utils.ShowLineTop();
					break;
				case B_UP_ARROW:
					utils.ShowTop();
					break;
				case B_DOWN_ARROW:
					utils.ShowBottom();
					break;
				case B_SPACE:
					//textview->SetJapaneseInputMode(!textview->IsJapaneseInputMode());
					break;
				case 'L':
					utils.SelectToLineTop();
					utils.SelectToLineBottom();
					break;
			}
			break;
			
		case B_CUT:
		case B_COPY:
		case B_PASTE:
		case B_SELECT_ALL:
		case B_UNDO:
			textview->MessageReceived(msg);
			break;
			
		default:
			this->BWindow::MessageReceived(msg);
	}
}


void
KWindow::ShowSavePanel()
{
	if(fSavePanel == NULL)
		fSavePanel = new BFilePanel(B_SAVE_PANEL, new BMessenger(this), NULL, 0, false);
	fSavePanel->SetSaveText(this->Title());
	fSavePanel->Show();
}


void
KWindow::Save()
{
	if(!fDirty)
		return;
	
		
	KTextView*	textview = (KTextView*)FindView("textview");
	int32		len = textview->TextLength();
	char*		text = new char[len + 1];
	KPrefs*		prefs = ((KApp*)be_app)->GetPrefs();
	bool		flag;
	
	prefs->GetData("reset_filetype_and_preferredapp", &flag);
	
	//if r/o document->save as... called, make editable false.
	textview->MakeEditable(true);
	
	::strcpy(text, textview->Text());
	((KBottomView*)FindView("bottomview"))->ConvertFromStandard(&text);
	len = strlen(text);
	
	BFile*	file = new BFile(fEntry, B_READ_WRITE);
	if(file->InitCheck() == B_NO_ERROR){
		BNodeInfo	info(file);
		if(flag){
			info.SetPreferredApp(kMySignature);
			if(textview->DoesHTMLSyntax())
				info.SetType(kTextHTML);
			else
				info.SetType(kTextPlain);
		}
		file->Lock();
		file->Write(text, len);
		file->SetSize(len);
		file->Unlock();
		delete file;
		
		this->WriteAttrs();
		this->SetDirty(false);
	}else{
		(new BAlert(B_EMPTY_STRING,
				"Error...\n"
				"File not found.",
				"OK"))->Go();
		delete file;
	}
	
	delete[] text;
}


void
KWindow::WriteAttrs()
{
	KRectUtils	utils;
	const KTextView*	textview = (KTextView*)FindView("textview");
	const BFont*		font = textview->BaseFont();
	BFile				file(fEntry, B_READ_WRITE);
	
	const float	size = B_HOST_TO_BENDIAN_FLOAT(font->Size());
	const bool	wordWrap = textview->DoesWordWrap();
	const bool	autoIndent = textview->DoesAutoindent();
	const float	tabWidth = B_HOST_TO_BENDIAN_FLOAT(textview->TabWidth());
	
	font_family	family;
	font_style	style;
	font->GetFamilyAndStyle(&family, &style);
	
	rect_st	aWindowFrame = utils.ConvertToStruct(this->Frame());
	rect_st	aTextViewBounds = utils.ConvertToStruct(textview->Bounds());
	
	int32	fromOffset, toOffset;
	textview->GetSelection(&fromOffset, &toOffset);
	
	if(file.InitCheck() == B_NO_ERROR){
		file.Lock();
		//size = B_HOST_TO_BENDIAN_FLOAT(size);
		file.WriteAttr("size", B_RAW_TYPE, 0, &size, sizeof(float));
		file.WriteAttr("fontfamily", B_RAW_TYPE, 0, &family, sizeof(font_family));
		file.WriteAttr("fontstyle", B_RAW_TYPE, 0, &style, sizeof(font_style));
		file.WriteAttr("wordwrap", B_RAW_TYPE, 0, &wordWrap, sizeof(bool));
		file.WriteAttr("autoindent", B_RAW_TYPE, 0, &autoIndent, sizeof(bool));
		//tabWidth = B_HOST_TO_BENDIAN_FLOAT(tabWidth);
		file.WriteAttr("tabwidth", B_RAW_TYPE, 0, &tabWidth, sizeof(float));

		aWindowFrame.left = B_HOST_TO_BENDIAN_FLOAT(aWindowFrame.left);
		aWindowFrame.top = B_HOST_TO_BENDIAN_FLOAT(aWindowFrame.top);
		aWindowFrame.right = B_HOST_TO_BENDIAN_FLOAT(aWindowFrame.right);
		aWindowFrame.bottom = B_HOST_TO_BENDIAN_FLOAT(aWindowFrame.bottom);
		file.WriteAttr("window_frame", B_RAW_TYPE, 0, &aWindowFrame, sizeof(rect_st));
		aTextViewBounds.left = B_HOST_TO_BENDIAN_FLOAT(aTextViewBounds.left);
		aTextViewBounds.top = B_HOST_TO_BENDIAN_FLOAT(aTextViewBounds.top);
		aTextViewBounds.right = B_HOST_TO_BENDIAN_FLOAT(aTextViewBounds.right);
		aTextViewBounds.bottom = B_HOST_TO_BENDIAN_FLOAT(aTextViewBounds.bottom);
		file.WriteAttr("textview_bounds", B_RAW_TYPE, 0, &aTextViewBounds, sizeof(rect_st));
		
		fromOffset = B_HOST_TO_BENDIAN_INT32(fromOffset);
		file.WriteAttr("textview_offset_from", B_RAW_TYPE, 0, &fromOffset, sizeof(int32));
		toOffset = B_HOST_TO_BENDIAN_INT32(toOffset);
		file.WriteAttr("textview_offset_to", B_RAW_TYPE, 0, &toOffset, sizeof(int32));
		file.WriteAttr("memorize_window_rect", B_RAW_TYPE, 0, &fMemorizeWindow, sizeof(bool));
		file.Unlock();
	}
	
}


void
KWindow::MakeNewFile(const char* name, const entry_ref* dir)
{
	BDirectory	directory(dir);
	BFile		file;
	
	if(!directory.CreateFile(name, &file, false)){
		BEntry*	entry = new BEntry();
		directory.FindEntry(name, entry);
		delete fEntry;
		fEntry = entry;
		this->SetTitle(name);
		this->SetDirty(true);
	}
	
	be_app->PostMessage(K_REFRESH_WINDOW_MENU);
}


void
KWindow::RemoveWindowPointer()
{
	BMessage*	message = new BMessage(K_REMOVE_WINDOW_POINTER);
	message->AddPointer("window", this);
	be_app->PostMessage(message);
}


void
KWindow::MenusBeginning()
{
	KMenuBar*	aMenuBar = (KMenuBar*)FindView("menubar");
	aMenuBar->UpdateMenus();
}


void
KWindow::OpenWithBrowser()
{	
	if(fEntry == NULL){
		beep();
		return;
	}
	
	KPrefs*		prefs = ((KApp*)be_app)->GetPrefs();
	bool		aAlwaysMakesNewWindow;
	prefs->GetData("browser_always_makes_new_window", &aAlwaysMakesNewWindow);
	
	this->Save();
	
	BMimeType	aMimeType(kTextHTML);
	if(aMimeType.InitCheck() != B_NO_ERROR)
		return;
	
	char*	sig = new char[B_MIME_TYPE_LENGTH + 1];
	aMimeType.GetPreferredApp(sig);

	if((::strcmp(sig, B_NETPOSITIVE_APP_SIGNATURE) == 0)
				&& aAlwaysMakesNewWindow == false){//for "NetPositive"
		if(!be_roster->IsRunning(B_NETPOSITIVE_APP_SIGNATURE)){
			be_roster->Launch(B_NETPOSITIVE_APP_SIGNATURE);
			while(!be_roster->IsRunning(B_NETPOSITIVE_APP_SIGNATURE)){ snooze(20000); }
		}
		//Get the messenger of the index 0 window of NetPositive.
		BMessage	aMessage, aReply;
		aMessage.what = B_GET_PROPERTY;
		aMessage.AddSpecifier("Messenger");
		aMessage.AddSpecifier("Window", (int32)0);
		BMessenger	aWindowMessenger;
		BMessenger	aNPosMessenger(B_NETPOSITIVE_APP_SIGNATURE);
		aNPosMessenger.SendMessage(&aMessage, &aReply);
		if(aReply.FindMessenger("result", &aWindowMessenger) != B_NO_ERROR){ return; }
		//Open the document which this window contains.
		aMessage.MakeEmpty();
		aMessage.what = B_NETPOSITIVE_OPEN_URL;
		BPath	aPath;
		char	aURL[B_PATH_NAME_LENGTH + 8];
		fEntry->GetPath(&aPath);
		::strcpy(aURL, "file://");
		::strcat(aURL, aPath.Path());
		aMessage.AddString("be:url", aURL);
		aWindowMessenger.SendMessage(&aMessage);
		be_roster->ActivateApp(be_roster->TeamFor(B_NETPOSITIVE_APP_SIGNATURE));
	}else{//for other Browsers
		team_id	id = be_roster->TeamFor(sig);
		if(id != 0){
			BMessage*	aMessage = new BMessage(B_REFS_RECEIVED);
			entry_ref	aRef;
			fEntry->GetRef(&aRef);
			aMessage->AddRef("refs", &aRef);
			be_roster->Launch(sig, aMessage);
		}
	}
	delete[] sig;
}


void
KWindow::OpenWithBeMail()
{
	const char	kBeMailSig[] = "application/x-vnd.Be-MAIL";
	
	if(fEntry == NULL || fEntry->InitCheck() != B_NO_ERROR){
		::beep();
		return;
	}
	
	team_id	id = be_roster->TeamFor(kBeMailSig);
	if(id != 0){
		BMessage*	aMessage = new BMessage(B_REFS_RECEIVED);
		entry_ref	aRef;
		fEntry->GetRef(&aRef);
		aMessage->AddRef("refs", &aRef);
		be_roster->Launch(kBeMailSig, aMessage);
	}
}


void
KWindow::ExecAddon(BMessage* msg)
{
	key_info aInfo;
	::get_key_info(&aInfo);
	
	if((aInfo.modifiers & B_SHIFT_KEY) != 0){
		msg->what = B_REFS_RECEIVED;
		be_app->PostMessage(msg, NULL);
		return;
	}
	
	entry_ref	aRef; // ref of the add-on file
	msg->FindRef("refs", &aRef);
	
	BTextView*	aTextView = dynamic_cast<BTextView*>(this->FindView("textview"));
	if(aTextView == NULL){ ::printf("err : no textview.\n"); return; }
	int32	aFrom, aTo;
	aTextView->GetSelection(&aFrom, &aTo);
	
	char*	aSelectedText; // selected text
	if(aTextView->TextLength() == 0){
		::beep();
		::printf("err : blank page.\n");
		return;
	}else{
		aSelectedText = new char[aTo - aFrom + 1];
		aSelectedText[aTo - aFrom] = '\0';
		::strncpy(aSelectedText, aTextView->Text() + aFrom, aTo - aFrom);
	}
	
	long long int aSystemTime = ::system_time();
	char	aFileName[B_FILE_NAME_LENGTH];
	char	aWholeFileName[B_FILE_NAME_LENGTH];
	char	aSettingFileName[B_FILE_NAME_LENGTH];
	::sprintf(aFileName, "kedit-addon-%Ld", aSystemTime);
	::sprintf(aWholeFileName, "kedit-addon-%Ld-w", aSystemTime);
	::sprintf(aSettingFileName, "kedit-addon-%Ld-s", aSystemTime);
	char*	aEnvText = new char[B_FILE_NAME_LENGTH + 256];
	::sprintf(aEnvText, "TMPFILE=/tmp/%s", aFileName); // TMPFILE
	::putenv(aEnvText);
	::sprintf(aEnvText, "TMPFILE_PARTIAL=/tmp/%s", aFileName); // TMPFILE_PARTIAL == TMPFILE
	::putenv(aEnvText);
	::sprintf(aEnvText, "TMPFILE_WHOLE=/tmp/%s", aWholeFileName); // TMPFILE_WHOLE
	::putenv(aEnvText);
	::sprintf(aEnvText, "TMPSETTING=/tmp/%s", aSettingFileName); // TMPSETTING
	::putenv(aEnvText);
	::putenv("K_FUNC=INSERT"); // K_FUNC=INSERT
	::sprintf(aEnvText, "K_SELECTED_FROM=%ld", aFrom); // K_SELECTED_FROM
	::putenv(aEnvText);
	::sprintf(aEnvText, "K_SELECTED_TO=%ld", aTo); // K_SELECTED_TO
	::putenv(aEnvText);
	delete[]	aEnvText;
	
	BFile*	aFile = new BFile(&aRef, B_READ_ONLY); // file of the add-on file
	BPath	aPath(&aRef); // path of add-on file
	
	if(aFile->InitCheck() != B_NO_ERROR){
		::printf("err : open file.\n");
		delete aFile;
		return ;
	}
	
	BDirectory	aDir("/tmp"); // '/tmp' directory.
	if(aDir.InitCheck() != B_NO_ERROR){ ::printf("err : open dir.\n"); return; }
	if(aDir.CreateFile(aFileName, aFile) != B_NO_ERROR){ ::printf("err : create partial.\n"); return; }
	
	BEntry	aTextFileEntry; // stored tmp text.
	aDir.FindEntry(aFileName, &aTextFileEntry);
	aFile->SetTo(&aTextFileEntry, B_READ_WRITE);
	aFile->Lock();
	aFile->Write(aSelectedText, ::strlen(aSelectedText));
	aFile->Unlock();
	
	if(aDir.CreateFile(aWholeFileName, aFile) != B_NO_ERROR){ ::printf("err : create full.\n"); return; }
	
	BEntry	aWholeTextFileEntry;
	aDir.FindEntry(aWholeFileName, &aWholeTextFileEntry);
	aFile->SetTo(&aWholeTextFileEntry, B_READ_WRITE);
	aFile->Lock();
	aFile->Write(aTextView->Text(), aTextView->TextLength());
	aFile->Unlock();
	
	if(aDir.CreateFile(aSettingFileName, aFile) != B_NO_ERROR){ ::printf("err : create setting.\n"); return; }

	BEntry	aSettingFileEntry;
	aDir.FindEntry(aSettingFileName, &aSettingFileEntry);
	aFile->SetTo(&aSettingFileEntry, B_READ_WRITE);
	aFile->Lock();
	char	aFunc[] = "FUNC=INSERT";
	aFile->Write(aFunc, ::strlen(aFunc));
	aFile->Unlock();
	
	delete[] aSelectedText;
	delete	aFile;
	
	char*	aPathText = new char[B_FILE_NAME_LENGTH + 2];
	::sprintf(aPathText, "'%s'", aPath.Path());
	
	FILE* aFP = ::popen(aPathText, "r");
	delete[] aPathText;
	if(aFP == NULL){
		::printf("err : open pipe.\n");
		return;
	}
	
	const long kBlockSize = 512;
	long aCurrentPos = 0;
	BList aList;
	int	aChar;
	char* aBuf = new char[kBlockSize];
	*(aBuf + kBlockSize - 1) = '\0';
	
	while(true){
		aChar = ::fgetc(aFP);
		if(aChar == EOF){
			*(aBuf + aCurrentPos) = '\0';
			aList.AddItem(aBuf);
			break;
		}
		*(aBuf + aCurrentPos) = aChar;
		aCurrentPos++;
		if(aCurrentPos == kBlockSize - 1){
			aList.AddItem(aBuf);
			aBuf = new char[kBlockSize];
			*(aBuf + kBlockSize - 1) = '\0';
			aCurrentPos = 0;
		}
	}

	char* aLoadedText = new char[kBlockSize * aList.CountItems() + 1];
	*aLoadedText = '\0';
	for(long i = 0; i < aList.CountItems(); i++){
		::strcat(aLoadedText, (char*)aList.ItemAt(i));
		delete[] aList.ItemAt(i);
	}
	
	aFile = new BFile(&aSettingFileEntry, B_READ_ONLY);
	off_t aSettingSize;
	aFile->GetSize(&aSettingSize);
	char* aSettingText = new char[aSettingSize + 1];
	aSettingText[aSettingSize] = '\0';
	aFile->Read(aSettingText, aSettingSize);
	delete aFile;
	KString aSettingString = aSettingText;
	
	if(aSettingString.StartsWith("FUNC=INSERT")){
		aTextView->Select(aFrom, aFrom);
		aTextView->Delete(aFrom, aTo);
		aTextView->Insert(aFrom, aLoadedText, ::strlen(aLoadedText));
		aTextView->Select(aFrom, aFrom + ::strlen(aLoadedText));
	}else if(aSettingString.StartsWith("FUNC=REPLACEALL")){
		aTextView->SetText(aLoadedText);
		aTextView->Select(0, aTextView->TextLength());
	}else if(aSettingString.StartsWith("FUNC=NOTOUCH")){
		// do nothing...
	}
	delete[]	aSettingText;
	
	aTextFileEntry.Remove();
	aWholeTextFileEntry.Remove();
	aSettingFileEntry.Remove();
	
	return;
	
	
	/*
	entry_ref	ref;
	msg->FindRef("refs", &ref);
	BEntry	aEntry(&ref);
	BPath	aPath(&aEntry);
	
	image_id	aId;
	KAddon*		aAddon = NULL;
	KAddon*		(*LoadAddon)(image_id);
	
	if((aId = load_add_on(aPath.Path())) < 0){ return; }
	if(get_image_symbol(aId, "LoadAddon", B_SYMBOL_TYPE_TEXT
						, (void **) &LoadAddon)){
		unload_add_on(aId);
		//printf("unload addon\n");
		return;
	}
	if((aAddon = (*LoadAddon)(aId)) == NULL){ return; }
	//aAddon->Execute(this);*/
	
	
}


void
KWindow::SetupShortcut()
{
	BMessage*	message;
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", B_RIGHT_ARROW);
	AddShortcut(B_RIGHT_ARROW, 0, message);
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", B_LEFT_ARROW);
	AddShortcut(B_LEFT_ARROW, 0, message);
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", B_UP_ARROW);
	AddShortcut(B_UP_ARROW, 0, message);
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", B_DOWN_ARROW);
	AddShortcut(B_DOWN_ARROW, 0, message);
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", B_SPACE);
	AddShortcut(B_SPACE, 0, message);
	
	message = new BMessage(M_SHORT_CUT_KEYS);
	message->AddInt32("key", 'L');//"L" shortcut.
	AddShortcut('L', 0, message);
}


void
KWindow::SendEmail(bool send_now)
{
	KMailUtils	aUtils;
	
	const BTextView*	aTextView = dynamic_cast<BTextView*>(this->FindView("textview"));
	
	
	if(aUtils.Send(aTextView->Text(), send_now) != B_NO_ERROR){
		(new BAlert(B_EMPTY_STRING,
				"ERROR.\n\n"
				"An error has occured while sending your e-mail.",
				"OK"))->Go();
	}else{
		BAlert*	aAlert = new BAlert(B_EMPTY_STRING,
								"OK.\n\n"
								"The mail has been sent.\n"
								"Do you want to close this window?",
								"NO",
								"OK");
		aAlert->SetShortcut(0, B_ESCAPE);
		int32	aResult = aAlert->Go();
		
		if(aResult == 1){
			this->SetDirty(false);
			this->PostMessage(B_QUIT_REQUESTED);
		}
	}
	
}


void
KWindow::ShowHeaders()
{
	if(fEntry == NULL || fEntry->InitCheck() != B_NO_ERROR){ ::beep(); return; }
	
	BFile			aFile(fEntry, B_READ_ONLY);
	BTextView*		aTextView = dynamic_cast<BTextView*>(this->FindView("textview"));
	KBottomView*	aBottomView = dynamic_cast<KBottomView*>(this->FindView("bottomview"));
	
	if(aTextView == NULL || aFile.InitCheck() != B_NO_ERROR
			|| aBottomView == NULL){ ::beep(); return; }
	
	aFile.Lock();
	
	off_t	aSize;
	aFile.GetSize(&aSize);
	
	char*	aBufferText = new char[aSize + 1];
	aBufferText[aSize] = '\0';
	
	aFile.Read(aBufferText, aSize);
	
	aBottomView->ConvertToStandard(&aBufferText);
	
	aTextView->MakeEditable(true);
	aTextView->SetText(aBufferText);
	this->SetDirty(false);
	aTextView->MakeEditable(false);
	
	KTViewUtils	aUtils(aTextView);
	aUtils.ShowTop();
	
	aFile.Unlock();
	
	delete[]	aBufferText;
}


void
KWindow::ShowTextInformation()
{
	KTextUtils	aTextUtils;
	BTextView*	aTextView = dynamic_cast<BTextView*>(this->FindView("textview"));
	int32		aWBytes, aWChars, aWParags;
	int32		aPBytes, aPChars, aPParags;
	int32		aFrom, aTo;
				
	aWBytes = aTextView->TextLength();
	aWChars = aTextUtils.CountChars(aTextView->Text());
	if(aWBytes == 0){
		aWParags = 0;
	}else{
		aWParags = 1;
		for(int32 i = 0; i < aWBytes; i++){
			if(*(aTextView->Text() + i) == LF){ aWParags++; }
		}
	}
				
				
	aTextView->GetSelection(&aFrom, &aTo);
	aPBytes = aTo - aFrom;
	aPChars = aTextUtils.CountChars(aTextView->Text() + aFrom, aPBytes);
	if(aPBytes == 0){
		aPParags = 0;
	}else{
		aPParags = 1;
		for(int32 i = aFrom; i < aTo; i++){
			if(*(aTextView->Text() + i) == LF){ aPParags++; }
		}
	}
				
				
	char	aString[256];
	::sprintf(aString, 
				"Text Information (UTF-8):\n"
				"\n"
				"    Whole : \n"
				"        %d bytes\n"
				"        %d characters\n"
				"        %d lines\n"
				"\n"
				"    Selection : \n"
				"        %d bytes\n"
				"        %d characters\n"
				"        %d lines"
				, (int)aWBytes, (int)aWChars, (int)aWParags
				, (int)aPBytes, (int)aPChars, (int)aPParags);
	(new BAlert(B_EMPTY_STRING, aString, "OK"))->Go();
}



void
KWindow::OpenEntriesBeside(BMessage* msg)
{
	if(fEntry == NULL || fTrackerViewToken == NULL){ return; }
	
	if(fTrackerViewToken->IsValid() == false){
		delete	fTrackerViewToken;
		fTrackerViewToken = NULL;
		::printf("invalid Token\n");
		return;
	}
		
	BMessage	aMessage, aReply;
	type_code	aType;
	entry_ref	aRef;
	BEntry		aEntry;
	int32		aCount;
	//KApp*		aApp = dynamic_cast<KApp*>(be_app);
	KTextView*	aTextView = dynamic_cast<KTextView*>(this->FindView("textview"));
	
	aMessage.what = B_GET_PROPERTY;
	aMessage.AddSpecifier("Entry");
	
	
	if(fTrackerViewToken->SendMessage(&aMessage, &aReply) != B_NO_ERROR){ return; }
	aReply.GetInfo("result", &aType, &aCount);
	if(aType != B_REF_TYPE){ return; }
	for(int32 i = 0; i < aCount; i++){
		aReply.FindRef("result", i, &aRef);
		aEntry.SetTo(&aRef);
		if(aEntry.InitCheck() != B_NO_ERROR){ continue; }
		if(aEntry == *fEntry){
			if(msg->what == K_OPEN_NEXT_ENTRY){ i++; }else{ i--; }
			while(aReply.FindRef("result", i, &aRef) == B_NO_ERROR){
				if(aEntry.SetTo(&aRef) != B_NO_ERROR){ return; }
				if(aEntry.InitCheck() != B_NO_ERROR){ return; }
				if(aEntry.IsFile()/* && aApp->IsTextFile(&aEntry)*/){
					aMessage.MakeEmpty();
					aMessage.what = B_SET_PROPERTY;
					aMessage.AddSpecifier("Selection");
					aMessage.AddRef("data", &aRef);
					fTrackerViewToken->SendMessage(&aMessage);
					
					this->SetStatusNEW2READ(fEntry);
					
					delete	fEntry;
					fEntry = new BEntry();
					*fEntry = aEntry;
					aTextView->MakeEditable(true);
					aTextView->SetText("");
					this->Fusion_PreProcess();
					this->Fusion_Text();
					this->SetDirty(false);
					
					break;
				}else{
					if(msg->what == K_OPEN_NEXT_ENTRY){ i++; }else{ i--; }
				}
			}
			
			
			break;
		}
	}
}



void
KWindow::SetStatusNEW2READ(BEntry* entry)
{
	if(entry != NULL){
		BFile		aFile(entry, B_READ_WRITE);
		char*		aAttr;
		attr_info	aInfo;
		
		aFile.Lock();
		if(aFile.GetAttrInfo(B_MAIL_ATTR_STATUS, &aInfo) == B_NO_ERROR
				&& aInfo.size > 1
				&& aInfo.type == B_STRING_TYPE){
			aAttr = new char[aInfo.size + 1];
			aFile.ReadAttr(B_MAIL_ATTR_STATUS, B_STRING_TYPE, 0, aAttr, aInfo.size);
			if(::strcmp(aAttr, "New") == 0){
				aFile.WriteAttr(B_MAIL_ATTR_STATUS, B_STRING_TYPE, 0, "Read\0", 5);
			}
			delete[]	aAttr;
		}
		aFile.Unlock();
	}
}





























