#include "KFindWindow.h"

#include <stdio.h>
#include <string.h>
#include <Alert.h>
#include <Application.h>
#include <Beep.h>
#include <CheckBox.h>

#include "KFindView.h"
#include "KTabTextView.h"
#include "KSearch.h"
#include "KDirView.h"
#include "KMenuBar.h"

#include "KTextUtils.h"

KFindWindow::KFindWindow(BRect frame)
	:BWindow(frame, "Find", B_TITLED_WINDOW
						, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_ASYNCHRONOUS_CONTROLS)
{
	fTargetWindow = NULL;
	fIgnoreCase = true;
	fUseRegExp = false;
	fFindString = new char[1];
	*fFindString = '\0';
	fReplaceString = new char[1];
	*fReplaceString = '\0';
	
	KFindView*	aFindView = new KFindView(this->Bounds());
	this->AddChild(aFindView);
	
	KTabTextView*	aTextView = dynamic_cast<KTabTextView*>(this->FindView("find_view"));
	
	if(aTextView != NULL)
		aTextView->MakeFocus(true);
	

	this->AddShortcut('W', 0, new BMessage(K_CANCEL_BUTTON_PRESSED));
	this->AddShortcut('I', 0, new BMessage(K_IGNORE_CASE_CHECKBOX));
	this->AddShortcut('E', 0, new BMessage(K_REG_EXP_CHECKBOX));
	this->AddShortcut('M', 0, new BMessage(K_MULTIFILE_SEARCH_CHECKBOX));
	this->AddShortcut('R', 0, new BMessage(K_REPLACE_ALL_PRESSED));
	this->AddShortcut('S', 0, new BMessage(K_SET_BUTTON_PRESSED));
	this->AddShortcut(B_RETURN, 0, new BMessage(K_INSERT_RETURN));
	this->AddShortcut(B_TAB, 0, new BMessage(K_INSERT_TAB));
	
	be_app->SetCursor(B_HAND_CURSOR);
	
	this->SetPulseRate(150000);
}

KFindWindow::~KFindWindow()
{
	
}

bool
KFindWindow::QuitRequested()
{
	if(dynamic_cast<BMessage*>(this->CurrentMessage())){
		this->Hide();
		return false;
	}
	return true;
}

void
KFindWindow::MessageReceived(BMessage* msg)
{
	BTextView*	aTextView = NULL;
	
	switch(msg->what)
	{		
		case K_OK_BUTTON_PRESSED:
			{
				this->SetSettings();
				this->Find(true);
				this->Hide();
			}
			break;
		
		case K_CANCEL_BUTTON_PRESSED:
			{
				this->Hide();
			}
			break;
			
		case K_SET_BUTTON_PRESSED:
			{
				this->SetSettings();
			}
			break;
			
		case K_REPLACE_ALL_PRESSED:
			{
				this->SetSettings();
				this->ReplaceAll();
				this->Hide();
			}
			break;
			
		case K_IGNORE_CASE_CHECKBOX:
			{
				BCheckBox*	aCheckBox = (BCheckBox*)this->FindView("ignore_case");
				aCheckBox->SetValue(!aCheckBox->Value());
			}
			break;
			
		case K_REG_EXP_CHECKBOX:
			{
				BCheckBox*	aCheckBox = (BCheckBox*)this->FindView("use_regexp");
				aCheckBox->SetValue(!aCheckBox->Value());
			}
			break;
			
		case K_MULTIFILE_SEARCH_CHECKBOX:
			{
				BCheckBox*	aCheckBox = (BCheckBox*)this->FindView("multi_file_search");
				aCheckBox->SetValue(!aCheckBox->Value());
			}
			break;
			
		case K_INSERT_RETURN:
			{
				aTextView = (BTextView*)this->CurrentFocus();
				aTextView->Insert("\n");
				aTextView->ScrollToSelection();
			}
			break;
			
		case K_INSERT_TAB:
			{
				aTextView = (BTextView*)this->CurrentFocus();
				aTextView->Insert("\t");
				aTextView->ScrollToSelection();
			}
			break;
			
		case K_FIND_AGAIN:
			{
				BWindow*	aWindow = NULL;
				if(msg->FindPointer("window", (void **) &aWindow) == B_OK){
					this->SetTargetWindow(aWindow);
					this->Find(false);
				}
				
			}
			break;
			
		default:
			this->BWindow::MessageReceived(msg);
	}
}


void
KFindWindow::SetSettings()
{
	BTextView*	aTextView = (BTextView*)this->FindView("find_view");
	
	const char*	aFindText = aTextView->Text();
	int32		aFindLen = aTextView->TextLength();
	delete[]	fFindString;
	fFindString = new char[aFindLen + 1];
	*fFindString = '\0';
	strcpy(fFindString, aFindText);
	
	
	aTextView = (BTextView*)this->FindView("replace_view");
	
	const char*	aReplaceText = aTextView->Text();
	int32		aReplaceLen = aTextView->TextLength();
	delete[]	fReplaceString;
	fReplaceString = new char[aReplaceLen + 1];
	*fReplaceString = '\0';
	strcpy(fReplaceString, aReplaceText);
	
	BCheckBox*	aCheckBox = (BCheckBox*)this->FindView("ignore_case");
	fIgnoreCase = aCheckBox->Value();
	/*aCheckBox = (BCheckBox*)this->FindView("use_regexp");
	fUseRegExp = aCheckBox->Value();
	aCheckBox = (BCheckBox*)this->FindView("multi_file_search");
	fMultiFileSearch = aCheckBox->Value();*/
}


bool
KFindWindow::Find(bool internal)
{
	if(!strcmp(fFindString, B_EMPTY_STRING)){
		beep();
		return false;
	}
	
	fTargetWindow->Lock();
	
	BTextView*	aTextView;
	if(!(aTextView = dynamic_cast<BTextView*>(fTargetWindow->FindView("textview")))){
		fTargetWindow->Unlock();
		return false;
	}
	KSearch	aSearch(aTextView->Text(), fIgnoreCase, fUseRegExp);
	int32	from, to;
	aTextView->GetSelection(&from, &to);
	if(aSearch.SearchString(fFindString, &from, &to, to) == B_ERROR){
		fTargetWindow->Unlock();
		::beep();
		return false;
	}
	aTextView->Select(from, to);
	aTextView->ScrollToSelection();
	fTargetWindow->Activate();
	
	fTargetWindow->Unlock();
	
	return true;
}


void
KFindWindow::Replace()
{
	int32	startOffset, endOffset;
	int32	replaceLength = strlen(fReplaceString);
	
	BTextView*	aTextView = (BTextView*)(fTargetWindow->FindView("textview"));
	fTargetWindow->Lock();
	aTextView->GetSelection(&startOffset, &endOffset);
	
	if( startOffset != endOffset ){
		aTextView->Delete(startOffset, endOffset);
		aTextView->Insert(fReplaceString);
		aTextView->Select(startOffset + replaceLength, startOffset + replaceLength);
	}else{
		beep();
	}
	fTargetWindow->Unlock();
}


void
KFindWindow::ReplaceAll()
{
	if(!strcmp(fFindString, B_EMPTY_STRING)){
		beep();
		return;
	}
	
	fTargetWindow->Lock();
	BTextView*	aTextView;
	if(!(aTextView = dynamic_cast<BTextView*>(fTargetWindow->FindView("textview")))){
		fTargetWindow->Unlock();
		return;
	}
	char*	aText = NULL;
	int32	aCount = 0;
	KSearch	aSearch(aTextView->Text(), fIgnoreCase, false);
	aSearch.ReplaceAll(fFindString, fReplaceString, &aText, &aCount);
	aTextView->SetText(aText);
	fTargetWindow->Unlock();
	
	::beep();
	
	char	aAlertText[200];
	::sprintf(aAlertText, "Replaced %ld words.", aCount);
	(new BAlert(B_EMPTY_STRING,
				aAlertText,
				"OK"))->Go();
}




































