#include "KGoToLineWindow.h"

#include <stdio.h>
#include <Alert.h>
#include <Application.h>
#include <Beep.h>
#include <TextControl.h>

#include "KGoToLineView.h"

KGoToLineWindow::KGoToLineWindow(BRect frame)
	:BWindow(frame, "Go to line...", B_TITLED_WINDOW
						, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_ASYNCHRONOUS_CONTROLS)
{
	fTargetWindow = NULL;
	
	KGoToLineView*	aGoToLineView = new KGoToLineView(this->Bounds());
	this->AddChild(aGoToLineView);
	
	BTextControl* aControl = (BTextControl*)(this->FindView("textcontrol"));
	aControl->TextView()->MakeFocus(true);
	//this->AddShortcut('W', 0, new BMessage(K_CANCEL_BUTTON_PRESSED));
	
	be_app->SetCursor(B_HAND_CURSOR);
	
	this->SetPulseRate(150000);
}

KGoToLineWindow::~KGoToLineWindow()
{
	
}

bool
KGoToLineWindow::QuitRequested()
{
	if(dynamic_cast<BMessage*>(this->CurrentMessage())){
		this->Hide();
		return false;
	}
	return true;
}

void
KGoToLineWindow::MessageReceived(BMessage* msg)
{	
	switch(msg->what)
	{		
		case K_OK_BUTTON_PRESSED:
			{
				BTextControl*	aTextControl;
				msg->FindPointer("source", (void**)&aTextControl);
				BTextView* aTextView = aTextControl->TextView();
				int32	aInt;
				if(::sscanf(aTextView->Text(), "%ld", &aInt) >= 1){
					BTextView* aTargetView = dynamic_cast<BTextView*>(fTargetWindow->FindView("textview"));
					if(aTargetView != NULL || aInt < 0){
						fTargetWindow->Lock();
						int32 aLen = aTargetView->TextLength();
						int32 aCurrentLine = 1;
						for(int32 i = 0; i < aLen; i++){
							if(aInt <= 1){
								aTargetView->Select(0, 0);
								aTargetView->ScrollToSelection();
								break;
							}
							if(*(aTargetView->Text() + i) == '\n'){ aCurrentLine++; }
							if(aCurrentLine >= aInt){
								aTargetView->Select(i+1, i+1);
								aTargetView->ScrollToSelection();
								break;
							}
							if(i == aLen - 1){ ::beep(); }
						}
						fTargetWindow->Unlock();
					}else{
						::beep();
					}
					this->Hide();
				}else{
					::beep();
				}
			}
			break;
		default:
			this->BWindow::MessageReceived(msg);
	}
}





































