#ifndef __KPrefs_h__
#define __KPrefs_h__

#include <Locker.h>
#include <GraphicsCard.h>


const char	K_PREFS_FILE_NAME[] = "K_DEFAULT_FILE";

class KPrefs:public BLocker
{
public:
			KPrefs(const char* name = K_PREFS_FILE_NAME
					, const char* dir_name = NULL);
	virtual		~KPrefs();
	
	void	LoadPrefs();
	void	StorePrefs();
	
	
	void	GetData(const char* name, BRect* rect);
	void	GetData(const char* name, BPoint* point);
	void	GetData(const char* name, const char** text);
	void	GetData(const char* name, int32* num);
	void	GetData(const char* name, bool* status);
	void	GetData(const char* name, float* num);
	void	GetData(const char* name, entry_ref* ref);
	void	GetData(const char* name, rgb_color* color);
	
	void	GetData(const char* name, const void** data);
	void	GetData(const char* name, const void** data, ssize_t* numBytes);
	
	
	void	SetData(const char* name, BRect rect);
	void	SetData(const char* name, BPoint point);
	void	SetData(const char* name, const char* text);
	void	SetData(const char* name, int32 num);
	void	SetData(const char* name, bool status);
	void	SetData(const char* name, float num);
	void	SetData(const char* name, entry_ref* ref);
	void	SetData(const char* name, rgb_color* color);
	
	void	SetData(const char* name, const void* data, ssize_t numBytes);
	
	
	void	PrintToStream();
	
protected:
	virtual void	MakeDefault();
	void			SetDefaultData(const char* name
									, const void* data
									, ssize_t numBytes);
	
private:
	BEntry*		fPrefsEntry;
	BMessage*	fSettingMessage;
	BMessage*	fDefaultMessage;
};

#endif







