#include "KPrefsFontView.h"

#include <stdio.h>
#include <MenuItem.h>
#include <PopUpMenu.h>
#include <Looper.h>

#include "KMenuBar.h"

#include "KMenuUtils.h"
#include "KRectUtils.h"


KPrefsFontView::KPrefsFontView(BRect frame, const char* name)
		:BStringView(frame, name, "dummy")
{
	this->SetFontSize(12);
	this->SetFont(be_bold_font);
}

KPrefsFontView::~KPrefsFontView()
{
	
}


void
KPrefsFontView::MouseDown(BPoint where)
{
	KMenuUtils	utils;
	BPopUpMenu* popup = new BPopUpMenu("popup");
	BMenuItem*	menuitem;
	
	popup->SetFont(be_bold_font);
	popup->SetFontSize(12);
	
	utils.AddFontMenu(popup, K_STYLE, this);
	
	BPoint	point(this->Bounds().LeftTop());
	this->ConvertToScreen(&point);
	menuitem = NULL;
	menuitem = popup->Go(point);
	
	if(menuitem != NULL){
		BMessage*	msg = menuitem->Message();
		if(msg != NULL){
			const char	*family, *style;
			char*	aFontString = new char[B_FONT_FAMILY_LENGTH + B_FONT_STYLE_LENGTH + 50];
			msg->FindString("font_family", &family);
			msg->FindString("font_style", &style);
			sprintf(aFontString, "%s ... %s", family, style);
			this->SetText(aFontString);
		
			delete[] aFontString;
	
			BLooper*	looper;
			BHandler*	target = menuitem->Target(&looper);
			looper->PostMessage(menuitem->Message(), target);
		}
	}
	
	delete popup;
}


void
KPrefsFontView::MessageReceived(BMessage* msg)
{
	switch(msg->what){
		
			
		default:
			this->BStringView::MessageReceived(msg);
	}
}































