#ifndef __KPrefsView_h__
#define __KPrefsView_h__

#include <View.h>

enum{
	K_OK_BUTTON_PRESSED		= 'okps',
	K_CANCEL_BUTTON_PRESSED	= 'clps',
	
	K_WORD_WRAP_CHECK_BOX	= 'wrcb',
	K_AUTO_INDENT_CHECK_BOX	= 'aicb',
	
	K_KEY_ASSIGN			= 'kasn'
};

const char kBackgroundImageName[]	= "prefs_background";

class KPrefsView:public BView
{
	public:
				KPrefsView(BRect frame);
				~KPrefsView();
				
		void	MessageReceived(BMessage* msg);
		void	AttachedToWindow(void);
		void	KeyDown(const char* bytes, int32 numBytes);
		void	Draw(BRect updateRect);
		
		void	LoadPrefs();
		void	StorePrefs();
		
	private:
		void	AddChildren();
		void	Initialize();
		
		//Prefs.
		bool	fWordWrap;
		bool	fAutoIndent;
		bool	fMemorizeWindow;
		char*	fFontFamily;
		char*	fFontStyle;
		float	fSize;
		float	fTabWidth;
		int32	fKeyAssign;
		int32	fMultiButton;
		bool	fAutoDetectFileType;
		bool	fResetFileType;
		bool	fBrowserAlwaysMakesNewWindow;
		
		//BackgroundBitmap
		BBitmap*	fBackgroundBitmap;
		
};

#endif







