#include "KTextUtils.h"

#include <stdio.h>
#include <string.h>
#include <TypeConstants.h>


KTextUtils::KTextUtils()
{
	
}

int32
KTextUtils::GetCodeLength(const char* text)
{
	//Now, for 3 bytes.
	if(IsTopOfChar(text)){
		if(IsASCII(text)){
			return 1;
		}else if((*text & 0xe0) == 0xc0){
			return 2;
		}else if((*text & 0xf0) == 0xe0){
			return 3;
		}else{
			return 0;
		}
	}else{
		return 0;
	}
}

void
KTextUtils::PrintCharCode(char* text)
{
	
	while(*(text++) != '\0'){
		printf("code = 0x%x,\t%d\n", (uint8)*text, (uint8)*text);
	}
}

int32
KTextUtils::CountChars(const char* text)
{
	int32	num = 0;
	while(*text != '\0'){
		if(IsTopOfChar(text))
			num++;
		text++;
	}
	return num;
}

int32
KTextUtils::CountChars(const char* text, int32 len)
{
	int32	num = 0;
	for(int32 i = 0; i < len; i++){
		if(*text == '\0')
			break;
		if(IsTopOfChar(text))
			num++;
		text++;
	}
	return num;
}

void
KTextUtils::ToLowerCase(char* text, bool only1byte)
{
	while(*text != '\0'){
		if(*text >=65 && *text <= 91 && IsTopOfChar(text)){
			*text += 32;
		}
		if(only1byte)
			break;
		text++;
	}
}

void
KTextUtils::ToLowerCase(char* text, int32 len)
{
	for(int32 i = 0; i < len; i++){
		if(*text == '\0')
			break;
		if(*text >=65 && *text <= 91 && IsTopOfChar(text)){
			*text += 32;
		}
		text++;
	}
}

void
KTextUtils::ToUpperCase(char* text, bool only1byte)
{
	while(*text != '\0'){
		if(*text >=97 && *text <= 123 && IsTopOfChar(text)){
			*text -= 32;
		}
		if(only1byte)
			break;
		text++;
	}
}

void
KTextUtils::ConvertReturnsToLF(char* text)
{	
	for(int32 i = 0, j = 0; true; i++, j++){
		if(*(text + i) == CR){
			*(text + j) = LF;
			if(*(text + i + 1) == LF)
				i++;
		}else{
			*(text + j) = *(text + i);
			if(*(text + j) == '\0')
				break;
		}
	}
}

int32
KTextUtils::DetectReturnCode(const char* text)
{
	while(*(text++) != '\0'){
		if(*text == LF){
			return K_LF;
		}else if(*text == CR){
			if(*(++text) == LF){
				return K_CRLF;
			}else{
				return K_CR;
			}
			break;
		}
	}
	return K_LF;//LF;
}


void
KTextUtils::ConvertReturnCode(char** text, int32 retcode)
{
	char* str = *text;
	const int32	len = strlen(str);
	
	if(retcode == K_CR){
		while(*str != '\0'){
			if(*str == LF)
				*str = CR;
			
			str++;
		}
	}else if(retcode == K_CRLF){
		int32	LFNum = 0;
		for(int32 i = 0; *(str + i) != '\0'; i++){
			if(*(str + i) == LF)
				LFNum++;
		}
		
		//printf("LFNum = %d\n", LFNum);
		
		char*	buf = new char[len + LFNum + 1];
		
		for(int32 i = 0, j = 0;; i++, j++){
			if(*(str + j) == LF){
				*(buf + i) = CR;
				*(buf + (++i)) = LF;
			}else{
				*(buf + i) = *(str + j);
			}
			
			if(*(str + j) == '\0')
				break;
		}
		
		delete[] *text;
		*text = buf;
	}
}


void
KTextUtils::ToUpperCase(char* text, int32 len)
{
	for(int32 i = 0; i < len; i++){
		if(*text == '\0')
			break;
		if(*text >=97 && *text <= 123 && IsTopOfChar(text)){
			*text -= 32;
		}
		text++;
	}
}

bool
KTextUtils::IsWordChar(const char* text)
{
	if((*text >= 'a' && *text <= 'z')
			|| (*text >= 'A' && *text <= 'Z')
			|| *text == '_'){
		return true;
	}
	return false;
}


int32
KTextUtils::DetectCodeType(const char* text)
{
	uint8	c = 1;
	int32	whatcode = ASCII;
	//int32	codelen = 0;
	int32	len = strlen(text);
	
	//for UTF-8 only. It's not a smart way.
	
	//uint8	bufc = 0;
	int32	codenum;
	bool	isASCII = true;
	for(int32 i = 0; i < len; i++){
		if((codenum = GetCodeLength(text + i)) > 1){
			if(GetCodeLength(text + i + 1) != 0
				|| (codenum == 3 && GetCodeLength(text + i + 2) != 0)){
				break;
			}
			isASCII = false;
		}
		if(i == len - 1 && !isASCII){
			//whatcode = UTF8;
			//break;
			return UTF8;
		}
	}
	

	while ((whatcode == EUCORSJIS || whatcode == ASCII) && c != '\0'){
		if((c = *text++) != '\0'){
			//printf("c = 0x%x, %d\n", c, c);
			if(c == ESC){
				c = *text++;
				if(c == '$'){
					c = *text++;
					if(c == 'B')
						whatcode = NEW;
					else if(c == '@')
						whatcode = OLD;
				}
				else if(c == 'K')
					whatcode = NEC;
			}
			else if((c >= 129 && c <= 141) || (c >= 143 && c <= 159)){
				whatcode = SJIS;
			}
			else if(c == SS2){
				c = *text++;
				if((c >= 64 && c <= 126) || (c >= 128 && c <= 160) || (c >= 224 && c <= 252))
					whatcode = SJIS;
				else if(c >= 161 && c <= 223)
					whatcode = EUCORSJIS;
			}
			else if(c >= 161 && c <= 223){
				c = *text++;
				if(c >= 240 && c <= 254)
					whatcode = EUC;
				else if(c >= 161 && c <= 223)
					whatcode = EUCORSJIS;
				else if(c >= 224 && c <= 239){
					whatcode = EUCORSJIS;
					while (c >= 64 && c != '\0' && whatcode == EUCORSJIS){
						if(c >= 129){
							if(c <= 141 || (c >= 143 && c <= 159))
								whatcode = SJIS;
							else if(c >= 253 && c <= 254)
								whatcode = EUC;
						}
						c = *text++;
					}
				}
				else if(c <= 159)
					whatcode = SJIS;
			}
			else if(c >= 240 && c <= 254)
				whatcode = EUC;
			else if(c >= 224 && c <= 239){
				c = *text++;
				if((c >= 64 && c <= 126) || (c >= 128 && c <= 160))
					whatcode = SJIS;
				else if(c >= 253 && c <= 254)
					whatcode = EUC;
				else if(c >= 161 && c <= 252)
					whatcode = EUCORSJIS;
			}
		}
	}
	
	
	
	return whatcode;
}


bool
KTextUtils::SkipESCSeq(const char* text, uint8 temp, bool *in2byte)
{
	bool	curdata = *in2byte;
	if(temp =='$' || temp == '(')
		text++;
	if(temp == 'K' || temp == '$')
		*in2byte = true;
	else
		*in2byte = false;
	if(curdata == *in2byte)
		return false;
	else
		return true;
}


void
KTextUtils::JIS2EUC(char** text)
{
	char*	str = *text;
	
	uint8	temp, p1, p2 = 0;
	bool	in2byte = false;
	const int32	len = strlen(str);
	char*	buf = new char[4 * len];
	
	int32	num = 0;
	while((p1 = *(str++)) != '\0'){
		if(p1 == ESC){
			temp = *(str++);
			if(temp =='$' || temp == '(')
				str++;
			if(temp == 'K' || temp == '$')
				in2byte = true;
			else
				in2byte = false;
		}else if(p1 == LF || p1 == CR){
			if(in2byte)
				in2byte = false;
			*(buf + (num++)) = p1;
		}else{
			if(in2byte){
				p2 = *(str++);
				/*Mr. Naito's code*/
				/*
				if(p2 == ESC || p2 == LF || p2 == CR){
					in2byte = false;
					str--;
				}else*/{
					p1 += 128;
					p2 += 128;
					*(buf + (num++)) = p1;
					*(buf + (num++)) = p2;
				}
			}else{
				*(buf + (num++)) = p1;
			}
		}
	}
	*(buf + num) = '\0';
	
	delete[] *text;
	*text = buf;
}


void
KTextUtils::ConvertCharCodeToUTF8(char** text)
{
	int32	aCode = this->DetectCodeType(*text);
	
	if(aCode == NEW){
		this->JIS2EUC(text);
		this->EUC2UTF8(text);
	}else if(aCode == SJIS){
		this->SJIS2UTF8(text);
	}else if(aCode == EUC){
		this->EUC2UTF8(text);
	}
}


void
KTextUtils::EUC2JIS(char** text)
{
	char*	str = *text;

	uint8	p1, p2 = 0;
	bool	in2byte = false;
	const char	ki[] = {0x24, 0x42};
	const char	ko[] = {0x28, 0x4a};
	const int32	len = strlen(str);
	char*	buf = new char[4 * len];
	
	int32 num = 0;
	while((p1 = *(str++)) != '\0'){
		if(p1 == LF || p1 == CR){
			if(in2byte){
				in2byte = false;
				*(buf + (num++)) = ESC;
				*(buf + (num++)) = *ko;
				*(buf + (num++)) = *(ko + 1);
			}
			*(buf + (num++)) = p1;
		}else{
			if(p1 >= 161 && p1 <= 254){//iseuc
				p2 = *(str++);
				if(p2 >= 161 && p2 <= 254){//iseuc
					p1 -= 128;
					p2 -= 128;
					if(!in2byte){
						in2byte = true;
						*(buf + (num++)) = ESC;
						*(buf + (num++)) = *ki;
						*(buf + (num++)) = *(ki + 1);
					}
				}
				*(buf + (num++)) = p1;
				*(buf + (num++)) = p2;
			}else if(p1 == SS2){
				p2 = *(str++);
			/*
			if(p2 >= 161 && p2 <= 223){//Hankata
				p1 = p2;
				
			}
			*(buf + (num++)) = p1;
			*(buf + (num++)) = p2;
			*/
			}else{
				if(in2byte){
					in2byte = false;
					*(buf + (num++)) = ESC;
					*(buf + (num++)) = *ko;
					*(buf + (num++)) = *(ko + 1);
				}
				*(buf + (num++)) = p1;
			}
		}
	}
	if(in2byte){
		*(buf + (num++)) = ESC;
		*(buf + (num++)) = *ko;
		*(buf + (num++)) = *(ko + 1);
	}
	*(buf + num) = '\0';
	
	delete[] *text;
	*text = buf;
}



void
KTextUtils::SJIS2UTF8(char** text)
{
	int32	sourceLen = ::strlen(*text);
	int32	destLen = 4 * sourceLen;
	
	char*	buf = new char[destLen];
	status_t	err = false;
	
	int32	state = 0;
	
	err = convert_to_utf8(B_SJIS_CONVERSION, *text, &sourceLen, buf, &destLen, &state, '?');
	
	
	buf[destLen] = '\0';
	
	//for illegal NULL, not radical.
	for(int32 i = 0; i < destLen; i++){
		if(*(buf + i) == '\0'){ *(buf + i) = '?'; } 
	}
	
	if(!err){
		delete[] *text;
		*text = buf;
	}
}


void
KTextUtils::UTF82SJIS(char** text)
{
	int32	sourceLen = strlen(*text);
	int32	destLen = 4 * sourceLen;
	
	char*	buf = new char[destLen];
	status_t	err = false;
	int32		state = 0;
	
	err = convert_from_utf8(B_SJIS_CONVERSION, *text, &sourceLen, buf, &destLen, &state, '?');
	
	buf[destLen] = '\0';
	if(!err){
		delete[] *text;
		*text = buf;
	}
}


void
KTextUtils::EUC2UTF8(char** text)
{
	int32	sourceLen = strlen(*text) + 1;
	int32	destLen = 4 * sourceLen;
	
	//add first character for BUG...
	char*	aCopyStr = new char[sourceLen + 1];
	::sprintf(aCopyStr, "x");
	::strcat(aCopyStr, *text);
	
	char*	aBuffer = new char[destLen];
	status_t	err = false;
	int32		state = 0;
	
	err = convert_to_utf8(B_EUC_CONVERSION, aCopyStr, &sourceLen, aBuffer, &destLen, &state, '?');
	
	delete[]	aCopyStr;
	
	//for illegal NULL, not radical. & remove first character...
	for(int32 i = 0; i < destLen; i++){
		if(*(aBuffer + i + 1) == '\0'){
			*(aBuffer + i) = '?';
		}else{
			*(aBuffer + i) = *(aBuffer + i + 1);
		}
	}
	*(aBuffer + destLen - 1)= '\0';
	
	if(!err){
		delete[] *text;
		*text = aBuffer;
	}
}


void
KTextUtils::UTF82EUC(char** text)
{
	int32	sourceLen = strlen(*text) + 1;
	int32	destLen = 4 * sourceLen;
	
	//add first character for BUG...
	char*	aCopyStr = new char[sourceLen + 1];
	::sprintf(aCopyStr, "x");
	::strcat(aCopyStr, *text);
	
	char*	buf = new char[destLen];
	status_t	err = false;
	int32		state = 0;
	
	err = convert_from_utf8(B_EUC_CONVERSION, aCopyStr, &sourceLen, buf, &destLen, &state, '?');
	
	buf[destLen] = '\0';
	delete[]	aCopyStr;
	
	//remove first chacater...
	for(int32 i = 0; i < destLen; i++){
		*(buf + i) = *(buf + i + 1);
	}
	
	if(!err){
		delete[] *text;
		*text = buf;
	}
}


void
KTextUtils::JIS2MIME(char** text)
{
	const char kISO2022JP[] = "=?ISO-2022-JP?B?";
	
	const uint8 kMimeEncodeTable[64] = {
		0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,
		0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,
		0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,
		0x59,0x5A,0x61,0x62,0x63,0x64,0x65,0x66,
		0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,
		0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,
		0x77,0x78,0x79,0x7A,0x30,0x31,0x32,0x33,
		0x34,0x35,0x36,0x37,0x38,0x39,0x2B,0x2F,
	};
	
	char	c1, c2, c3;
	int32	aSrcPos, aDstPos;
	int32	aSrcLen = ::strlen(*text);
	aSrcPos = 0;
	
	if(::strlen(*text) == 0){ return; }
	
	char*	aBufferText = new char[4 * aSrcLen + 256];
	::strcpy(aBufferText, kISO2022JP);
	aDstPos = ::strlen(kISO2022JP);
	
	for(; aSrcLen >= 3; aSrcLen -= 3){
		c1 = *(*text + aSrcPos++);
		c2 = *(*text + aSrcPos++);
		c3 = *(*text + aSrcPos++);
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ (c1 >> 2) & 0x3F ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ ((c1 << 4) & 0x30) + ((c2 >> 4) & 0x0F) ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ ((c2 << 2) & 0x3C) + ((c3 >> 6) & 0x03) ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ c3 & 0x3F ];
	}
	if(aSrcLen == 2){
		c1 = *(*text + aSrcPos++);
		c2 = *(*text + aSrcPos++);
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ (c1 >> 2) & 0x3F ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ ((c1 << 4) & 0x30) + ((c2 >> 4) & 0x0F) ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ ((c2 << 2) & 0x3C) ];
		*(aBufferText + aDstPos++) = '=';
		aSrcLen = 0;
	}
	if(aSrcLen == 1){
		c1 = *(*text + aSrcPos++);
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ (c1 >> 2) & 0x3F ];
		*(aBufferText + aDstPos++) = kMimeEncodeTable[ ((c1 << 4) & 0x30) ];
		*(aBufferText + aDstPos++) = '=';
		*(aBufferText + aDstPos++) = '=';
		aSrcLen = 0;
	}
	*(aBufferText + aDstPos++) = '?';
	*(aBufferText + aDstPos++) = '=';
	*(aBufferText + aDstPos++) = '\0';
	
	delete[]	*text;
	*text = aBufferText;
}

/*
void
KTextUtils::MIME2JIS(char** text)
{
	uint8 kMimeDecodeTable[256] = {
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0x3E,0xFF,0xFF,0xFF,0x3F,
		0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,
		0x3C,0x3D,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,
		0xFF,0x00,0x01,0x02,0x03,0x04,0x05,0x06,
		0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,
		0x0F,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
		0x17,0x18,0x19,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,
		0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
		0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,
		0x31,0x32,0x33,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	};
	
	char*	aBuffer = new char[::strlen(*text) + 1];
	::strcpy(aBuffer, *text + 16);
	delete[]	*text;
	*text = aBuffer;
	
	uint8	c1, c2, c3, c4;
	uint8	*s, *p;
	char*	dst = new char[256];
	int32	dstLen = 0;
	int32	len = ::strlen(*text);
	
	::printf("start. len = %d\n", len);
	
	for(s = (uint8*)*text, p = (uint8*)dst; len > 3; len -= 4, s += 4, dstLen += 3){
		if((c1 = kMimeDecodeTable[*s]) == 0xFE){
			len = 0;
			break;
		}
		if((c2 = kMimeDecodeTable[s[1]]) == 0xFE){
			len = 1;
			break;
		}
		if((c3 = kMimeDecodeTable[s[2]]) == 0xFE){
			len = 2;
			break;
		}
		if((c4 = kMimeDecodeTable[s[3]]) == 0xFE){
			len = 3;
			break;
		}
		if(c1 == 0xFF || c2 == 0xFF || c3 == 0xFF || c4 == 0xFF){
			::printf("error 1\n");
			return;
		}
		*p++ = (uint8)(((c1 << 2) & 0xFC) + ((c2 >> 4) & 0x03));
		*p++ = (uint8)(((c2 << 4) & 0xF0) + ((c3 >> 2) & 0x0F));
		*p++ = (uint8)(((c3 << 6) & 0xC0) + (c4 & 0x3F));
	}
	//if(len != 0)
	for(;;){
		if(len == 3){
			c1 = kMimeDecodeTable[*s];
			c2 = kMimeDecodeTable[s[1]];
			c3 = kMimeDecodeTable[s[2]];
			if(c1 == 0xFE){
				len = 0;
				break;
			}
			if(c2 == 0xFE){
				len = 1;
				break;
			}
			if(c3 == 0xFE){
				len = 2;
				break;
			}
			if(c1 == 0xFF || c2 == 0xFF || c3 == 0xFF){
				::printf("error 2\n");
				return;
			}
			*p++ = (uint8)(((c1 << 2) & 0xFC) + ((c2 >> 4) & 0x03));
			*p++ = (uint8)(((c2 << 4) & 0xF0) + ((c3 >> 2) & 0x0F));
			dstLen += 2;
		}
		break;
	}
	for(;;){
		if(len == 2){
			c1 = kMimeDecodeTable[*s];
			c2 = kMimeDecodeTable[s[1]];
			if(c1 == 0xFE){
				len = 0;
				break;
			}
			if(c2 == 0xFE){
				len = 1;
				break;
			}
			if(c1 == 0xFF || c2 == 0xFF){
				::printf("error 3\n");
				return;
			}
			*p++ = (uint8)(((c1 << 2) & 0xFC) + ((c2 >> 4) & 0x03));
			dstLen++;
		}
		break;
	}
	if(len == 1){
		if((c1 = kMimeDecodeTable[*s]) != 0xFE){
			if(c1 == 0xFF){ return; }
			*p++ = (uint8)(((c1 << 2) & 0xFC));
			dstLen++;
		}
	}
	// *(dst + dstLen) = '\0';
	::printf("ended. dstLen = %d\n", dstLen);
	delete[]	*text;
	*text = dst;
}
*/




char*
KTextUtils::GetRelPath(const char* source, const char* dest)
{
	//printf("%s\n%s\n", source, dest);
	int32	slen = strlen(source);
	int32	dlen = strlen(dest);
	int32	minlen = (slen < dlen) ? slen : dlen;
	
	char*	text = new char[2 * B_PATH_NAME_LENGTH + 1];
	*text = '\0';
	
	if(strcmp(source, dest) == 0){
		strcat(text, "Same path, I guess.");
		return text;
	}
	
	int32	offset = 0;
	for(int32 i = 0; i < minlen; i++){
		if(*(source + i) != *(dest + i)){
			offset = i;
			break;
		}
	}
	for(int32 i = offset; i >= 0; i--){
		if(*(source + i) == '/'){
			offset = i + 1;
			break;
		}
	}
	//printf("%s\n%s\n", source + offset, dest + offset);
	
	int32	depth = 0;
	while(*(++source + offset) != '\0'){
		if(*(source + offset) == '/'){
			depth++;
		}
	}
	for(int32 i = 0; i < depth; i++){
		strcat(text, "../");
	}
	strcat(text, dest + offset);
	//printf("%s\n", text);
	return text;
}


void
KTextUtils::Decode_C_String(char* text)
{
	int32	i = 0;
	int32	j = 0;
	while(true){
		if(*(text + i) != 0x5c){
			if(*(text + i) == '"'){
				i++;
				continue;
			}else{
				*(text + j) = *(text + i);
			}
		}else{
			if(*(text + i + 1) == 'n'){
				*(text + j) = B_RETURN;
				i++;
			}else if(*(text + i + 1) == 't'){
				*(text + j) = B_TAB;
				i++;
			}else if(*(text + i + 1) == '"'){
				*(text + j) = '"';
				i++;
			}else if(*(text + i + 1) == 0x5c){
				*(text + j) = 0x5c;
				i++;
			}
		}
		if(*(text + i) == '\0')
			break;
		i++;
		j++;
	}
}


//from msgPeeper...
char*
KTextUtils::DecodeTypeCode(uint32 code)
{
	static char s[255], ch[5];
	
	switch ( code ){
				case B_CHAR_TYPE: return("B_CHAR_TYPE"); break;
				case B_INT8_TYPE: return("B_INT8_TYPE"); break;
				case B_INT16_TYPE: return("B_INT16_TYPE"); break;
				case B_INT32_TYPE: return("B_INT32_TYPE"); break;
				case B_INT64_TYPE: return("B_INT64_TYPE"); break;
				case B_UINT8_TYPE: return("B_UINT8_TYPE"); break;
				case B_UINT16_TYPE: return("B_UINT16_TYPE"); break;
				case B_UINT32_TYPE: return("B_UINT32_TYPE"); break;
				case B_UINT64_TYPE: return("B_UINT64_TYPE"); break;
				case B_FLOAT_TYPE: return("B_FLOAT_TYPE"); break;
				case B_DOUBLE_TYPE: return("B_DOUBLE_TYPE"); break;
				case B_BOOL_TYPE: return("B_BOOL_TYPE"); break;
				case B_OFF_T_TYPE: return("B_OFF_T_TYPE"); break;
				case B_SIZE_T_TYPE: return("B_SIZE_T_TYPE"); break;
				case B_SSIZE_T_TYPE: return("B_SSIZE_T_TYPE"); break;
				case B_POINTER_TYPE: return("B_POINTER_TYPE"); break;
				case B_OBJECT_TYPE: return("B_OBJECT_TYPE"); break;
				case B_MESSAGE_TYPE: return("B_MESSAGE_TYPE"); break;
				case B_MESSENGER_TYPE: return("B_MESSENGER_TYPE"); break;
				case B_POINT_TYPE: return("B_POINT_TYPE"); break;
				case B_RECT_TYPE: return("B_RECT_TYPE"); break;
				/*case B_PATH_TYPE: return("B_PATH_TYPE"); break;*/
				case B_REF_TYPE: return("B_REF_TYPE"); break;
				case B_RGB_COLOR_TYPE: return("B_RGB_COLOR_TYPE"); break;
				case B_PATTERN_TYPE: return("B_PATTERN_TYPE"); break;
				case B_ASCII_TYPE: return("B_ASCII_TYPE"); break;
				case B_STRING_TYPE: return("B_STRING_TYPE"); break;
				case B_MONOCHROME_1_BIT_TYPE: return("B_MONOCHROME_1_BIT_TYPE"); break;
				case B_GRAYSCALE_8_BIT_TYPE: return("B_GRAYSCALE_8_BIT_TYPE"); break;
				case B_COLOR_8_BIT_TYPE: return("B_COLOR_8_BIT_TYPE"); break;
				case B_RGB_32_BIT_TYPE: return("B_RGB_32_BIT_TYPE"); break;
				case B_TIME_TYPE: return("B_TIME_TYPE"); break;
				case B_RAW_TYPE: return("B_RAW_TYPE"); break;
				case B_MIME_TYPE: return("B_MIME_TYPE"); break;
				case B_ANY_TYPE: return("B_ANY_TYPE"); break;
				default : 
					strncpy(ch, (char *)&code, 4);
					//sprintf( s, "Other_code('%4s':%08xh)", ch, code );
					return(s); 
					break;
	}
}













