#ifndef __KTextView_h__
#define __KTextView_h__

#include <TextView.h>

const float	kViewWidth = 4000.0;

enum{
	K_SHOW_POPUP = 0,
	K_COPY_PASTE,
};

enum prev_undo{
	K_UNDO_UNAVAILABLE = 0,
	
	K_UNDO_INSERT,
	K_UNDO_DELETE,
	K_UNDO_DELETE_AND_INSERT
};

enum{
	K_TEXT_MODIFIED = 'txmd',
	
	K_INSERT_COLOR	= 'insc',
	K_SET_BG_COLOR	= 'sbgc',
	K_SET_CHR_COLOR	= 'schc',
	K_SET_TAG_COLOR	= 'stgc',
	K_SET_COM_COLOR	= 'scmc'
};

const char	kBackgroundImageName[]	= "textview_background";

class KShortcut;
struct key_info;
struct entry_ref;

class KTextView : public BTextView
{
	public:
		KTextView(BRect frame, const char *name, BRect textRect
					, uint32 resizeMask, uint32 frags);
		~KTextView();
		
		void	FrameResized(float width, float height);
		void	AttachedToWindow();
		void	MessageReceived(BMessage* message);
		void	Cut(BClipboard* clipboard);
		void	Copy(BClipboard* clipboard);
		
		void	Select(int32 from, int32 to);
		void	MouseDown(BPoint where);
		void	MouseMoved(BPoint where, uint32 code
								, const BMessage* msg);
		
		void	KeyDown(const char* bytes, int32 numBytes);
		
		void	Undo(BClipboard* clipboard);
		
		void	SetBaseFont(BFont* font);
		BFont*	BaseFont()const{ return fBaseFont; }
		
		void	SetHTMLSyntax(bool use);
		bool	DoesHTMLSyntax()const{ return fUseHTMLSyntax; }
		
		void	SetMultiButtonFunction(int32 func){ fMultiButton = func; }
		int32	GetMultiButtonFunction()const{ return fMultiButton; }
		
		void	InsertTags(const char* pre, const char* post);
		
		KShortcut*	GetShortcut()const{ return fShortcut; }
		
	protected:
		void	InsertText(const char* inText
							, int32 inLength
							, int32 inOffset
							, const text_run_array* inRuns);
		void	DeleteText(int32 fromOffset, int32 toOffset);
		
	private:
		void		Initialize();
		void		WhenDropped(BMessage* msg);
		void		ModifyColorPrefs(BMessage* msg);
		BPopUpMenu*	MakePopupMenu();
		void		UpdateHTMLSyntax(int32 from, int32 to);
		
		void		FileDropped(BMessage* msg, entry_ref entry, int32 offset, key_info info);
		void		ColorDropped(BMessage* msg, rgb_color color, int32 offset, key_info info);
		void		URLDropped(BMessage* msg, const char* name, int32 offset, key_info info);
		
		
		BFont*		fBaseFont;
		rgb_color	fBackgroundColor;
		rgb_color	fCharColor;
		rgb_color	fTagColor;
		rgb_color	fCommentColor;
		
		bool		fUseHTMLSyntax;
		int32		fMultiButton;
		KShortcut*	fShortcut;
		BBitmap*	fBackgroundBitmap;
		
		prev_undo	fUndoStatus;
		char*		fUndoBuffer;
		bigtime_t	fUndoLastDeletedTime;
		
};

#endif
















