#define FAKESNUM 0 /* fake screen number */

#include <stdio.h>
#include <OS.h>

/*
 * Mesa includes.
 */
#include "../src/context.h"
#include "../src/buffers.h"

#include "riva_glh.h"
#include "riva_symbols.h"
#include "riva_tex.h"
#include "glh.h"
#include "nv_globals.h"
#include "nv_3da.h"

#define RIVA_MINMEMSIZE ( (1024 * 1024) + (128 * 1024) )

#define RIVA_PREFERREDMEMSIZE ( (4 * 1024 * 1024) + (128 * 1024) )

/* This is where we keep per-card information, like
 * cached info on where the mapped video ram is
 * This will be allocated as riva_sinfo[numscreens]
 */
RIVA_GLX_INFO *riva_sinfo=NULL;

/* allocate back, depth buffers, 
 * called from nvHookSymbols only for now.
 * required memory checking already done in nvMapPrivMem() */
static void nvAllocateBuffers(void)
{
   int snum = FAKESNUM;
   char *currfreeptr = (char *)(riva_sinfo[snum].privMemBase);
   int freebytesleft = riva_sinfo[snum].privMemSize;
	/* offset from vidram 0 */
   int freeoffset = riva_sinfo[snum].privMemOffset;
   int texturebufsize, backbufsize, depthbufsize;
   
   /* use videoareasize as back and depth buffer size for now */
	riva_sinfo[snum].videoareasize = si->dm.virtual_height * si->fbc.bytes_per_row;

   backbufsize = riva_sinfo[snum].videoareasize;
   depthbufsize = riva_sinfo[snum].videoareasize;   

   /* This is just assumed to always be 0, but it's a consistency thing
    * to have it defined */
   riva_sinfo[snum].frontbufferoffset = 0;
//rudolf: not for us: we might have an offset (hw cursor)!
	if (si->settings.hardcursor) riva_sinfo[snum].frontbufferoffset = 2048;

	LOG(2,("nvAllocateBuffers: initial free space is $%08x\n", freebytesleft));

   riva_sinfo[snum].depthbufferoffset = freeoffset;
   riva_sinfo[snum].depthbufmappedaddr = currfreeptr;
   freeoffset += depthbufsize; 
   currfreeptr += depthbufsize;
   freebytesleft -= depthbufsize;

	LOG(2,("nvAllocateBuffers: depthbuffer mapped to $%08x, offset $%08x, size $%08x, free bytes left now $%08x\n",
		riva_sinfo[snum].depthbufmappedaddr,
		riva_sinfo[snum].depthbufferoffset,
		depthbufsize, freebytesleft));

   riva_sinfo[snum].backbufferoffset = freeoffset;
   riva_sinfo[snum].backbufmappedaddr = currfreeptr;
   freeoffset += backbufsize;
   currfreeptr += backbufsize;
   freebytesleft -= backbufsize;

   fprintf(stderr,"nvglx: backbuffer mapped to %p, offset=%d, size=%d, free bytes=%d\n",
	   riva_sinfo[snum].backbufmappedaddr,
	   riva_sinfo[snum].backbufferoffset,
	   backbufsize, freebytesleft);

   /* without reserving some memory, random crashes occur.
    * taken from xfree nv driver (nv_driver.c) */
   freebytesleft -= (128 * 1024);
   
//   ErrorF("nvglx: %d bytes free in video memory\n", freebytesleft);
   
   riva_sinfo[snum].numtexblocks = freebytesleft / RIVA_TEX_BLOCK_SIZE;

   texturebufsize = riva_sinfo[snum].numtexblocks * RIVA_TEX_BLOCK_SIZE;
   freebytesleft -= texturebufsize;

   fprintf(stderr,"nvglx: will alloc %d texture blocks(0x%x/%d bytes) at %p\n",
	   riva_sinfo[snum].numtexblocks, texturebufsize, texturebufsize,
	   currfreeptr);

    riva_sinfo[snum].textureoffset = freeoffset;
    riva_sinfo[snum].texturebase = currfreeptr;
}

static void nvSetSurfaces2D(uint16 pitch0, uint16 pitch1, uint32 surf0, uint32 surf1)
{
//note:aquire/release in main code because 2D drv could kick in!!
	uint32 surf_depth;

	LOG(2,("nvSetSurfaces2D called\n"));

	/*** Set pixel width ***/
	switch(si->dm.space)
	{
	case B_CMAP8:
		surf_depth = 0x00000001;
		break;
	case B_RGB15_LITTLE:
	case B_RGB16_LITTLE:
		surf_depth = 0x00000004;
		break;
	case B_RGB32_LITTLE:
	case B_RGBA32_LITTLE:
		surf_depth = 0x00000006;
		break;
	}

	/* wait for room in fifo for surface setup cmd if needed */
	if (nv_acc_fifofree_dma(5) != B_OK) return;
	/* now setup 2D surface (writing 5 32bit words) */
	nv_acc_cmd_dma(NV4_SURFACE, NV4_SURFACE_FORMAT, 4);
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = surf_depth; /* Format */
	/* setup screen pitch */
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] =
		((pitch1 & 0x0000ffff) | (pitch0 << 16)); /* Pitch Source and Dest */
	/* setup screen location */
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = surf1; /* OffsetSource */
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = surf0; /* OffsetDest */
}

static void nvSetSurfaces3D(uint32 surf0, uint32 surf1)
{
	LOG(2,("nvSetSurfaces3D called\n"));
//return;
//rud: we have to keep the Z-buffer at 16bit pitch!!??? (fixme for 8-bit)
//rud fixme:checkout nv20 for granularity of 128 bytes!!!
//rudtst:
	uint16 zpitch = (uint16)(FrontBuffer.right - FrontBuffer.left + 1);

	//rud: HW granularity is 64 (looks like bytes)!!! (otherwise engine crash.)
	switch(si->dm.space)
	{
	case B_RGB32_LITTLE:
		//we only support 16bit depth, but we set depth gran for 32bit as space for
		//that was reserved anyway (colorbuffer _must_ be 32bit gran of course!)
		zpitch = ((zpitch * 4) + 0x3f) & ~0x3f;
		break;
	default:
		zpitch = ((zpitch * 2) + 0x3f) & ~0x3f;
		break;
	}
//	LOG(2,("zpitch is $%04x, pitch is $%04x\n", zpitch, si->fbc.bytes_per_row));

	AQUIRE_BEN(si->engine.lock)
	nv_acc_assert_fifo_dma();

	if (nv_acc_fifofree_dma(4) != B_OK) goto end;//was 8
	//setup pitch: this will greatly improve speed for windowed apps!!
	nv_acc_cmd_dma(NV4_CONTEXT_SURFACES_ARGB_ZS, NV4_CONTEXT_SURFACES_ARGB_ZS_PITCH, 3);
	/* Pitch */
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] =
//		si->fbc.bytes_per_row | (zpitch << 16);
		zpitch | (zpitch << 16);

//rudolf:
//should set actual width, adhering to suported granularity of HW
//		xsmesa->gl_ctx->Buffer->Width | ((xsmesa->gl_ctx->Buffer->Width) << 16);
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = surf0; /* SetOffsetColor */
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = surf1; /* SetOffsetZeta */

	nv_start_dma();

//	LOG(2,("nv10SetSurfaces3D FiFoFree after is $%04x\n", nv4_context_surfaces_argb_zs_ptr->FifoFree)); 
end:
	RELEASE_BEN(si->engine.lock)
}

/* 
 * Very important routine.
 * Not only is this routine responsible for "Hooking in XFree server symbols"
 * but also for a lot of large memory allocation:
 *    BACK BUFFER
 *    DEPTH BUFFER
 *    TEXTURE [memory, not exactly a "buffer"]
 * I would LIKE to do this in the more appropriately named nvInitGLX,
 * however, that routine depends on this stuff already being set up.
 *
 * return true (1) on okay, false (0) on fail
 */

//rudolf: well, we don't need those symbols, just the mem allocation: fixme! 
 
int nvHookServerSymbols( void *handle )
{
   int snum=FAKESNUM; /* XXX hardcode screennum. Bad Boy */
//rudolf: disabled for now, is 2D driver private info (shared_info for Haiku)
//   ScrnInfoPtr scrninfoP;
//rudolf: disabled by me:
//   ScreenPtr screenP;
//rudolf disabled this:
//   NVPtr nvptr;/* xfree4 nv driver private data */
   int bytesperpixel;

   fprintf(stderr,"DEBUG: in nvHookServerSymbols\n");

	driver_updated = true;
	si->engine.threeD.newmode &= ~clone_nr;
	DirectMode = false;
	menu_offset_done = false;
	menu_offset = 0;
	fNumClipRects = 0;
	/* reset the engine DMA stalls counter */
	err = 0;
	/* engine is idle for sure */
	hw_drawing = false;

   /* Hook into symbols that are in the XFree nv driver specifically */
	if(riva_sinfo !=NULL)
	{
		fprintf(stderr, "DEBUG: nvHookServerSymbols: riva_sinfo not NULL?\n");
		return 0;
	}
//rudolf disabled this all:
//   scrninfoP=glxsym.scrninfoList[snum];
//(rudolf: pointer to screen:)
//   screenP=screenInfo.screens[scrninfoP->scrnIndex];
//   nvptr=(NVPtr) scrninfoP->driverPrivate;

//rudolf: create 'shared_info': we do this differently, so not needed.
//   riva_sinfo=(RIVA_GLX_INFO*)xalloc(sizeof (RIVA_GLX_INFO) * screenInfo.numScreens);
//   if(!riva_sinfo){
//	ErrorF("nvHookServerSymbols: xalloc failed\n");
//	return 0;
//   }

//rudolf added:
	riva_sinfo = (RIVA_GLX_INFO*)malloc(sizeof (RIVA_GLX_INFO) * 1 /* #screens */);
	if(!riva_sinfo)
	{
		fprintf(stderr, "DEBUG: nvHookServerSymbols: malloc failed\n");
		return 0;
	}
    memset((void *)(riva_sinfo), 0, sizeof (RIVA_GLX_INFO) * 1 /* #screens */);

//rudolf: disabled by me: (clear 'shared_info' memory: not needed by us).
//rudolf: was 'bzero' which does this exactly:
//	memset(riva_sinfo, 0, sizeof (RIVA_GLX_INFO) * screenInfo.numScreens);
   
//rudolf: set to 32 for now.
	switch (si->dm.space)
	{
	case B_RGB15_LITTLE:
		riva_sinfo[snum].bitsperpixel = 15;
		bytesperpixel = 2;
		break;
	case B_RGB16_LITTLE:
		riva_sinfo[snum].bitsperpixel = 16;
		bytesperpixel = 2;
		break;
   case B_RGB32_LITTLE:
		riva_sinfo[snum].bitsperpixel = 32;
		bytesperpixel = 4;
		break;
	default:
//      fprintf (stderr, "nvglx: unusable depth %d bpp\n",
//         scrninfoP->bitsPerPixel);
		return 0;
	}
//   fprintf(stderr,"GLX: nvHookServerSym: using %d bytesperpixel(bits=%d)\n",
//	   bytesperpixel, scrninfoP->bitsPerPixel);
//   fprintf(stderr,"   Xserver rgb masks:%lx/%lx/%lx rgbbits:%x\n",
//	   scrninfoP->mask.red,
//	   scrninfoP->mask.green,
//	   scrninfoP->mask.blue,
//	   scrninfoP->rgbBits);

	riva_sinfo[snum].bytesperpixel = bytesperpixel;

//rudolf disabled this:
//   riva_sinfo[snum].xfree_nvrec= nvptr; /* make copy of xfree4 nv driver private data */
//rudolf disabled this: (struct from 2D driver for all kinds if driver info:
//                       kind of: 'shared_info' struct for Haiku)
//   riva_sinfo[snum].riva= &nvptr->riva;

	/* virtual screen size in bytes */
	riva_sinfo[snum].videoareasize = si->dm.virtual_height * si->fbc.bytes_per_row;

   /* map video memory */
	//rudolf: check enough space!!! orig:
	// first check we have really enough memory
	// a backbuffer, a depthbuffer, min required texture memory
/*
	minmemsize = (2 * riva_sinfo[screennum].videoareasize)
	    + RIVA_MINMEMSIZE;
	if (maxmemsize < minmemsize) {
	    fprintf (stderr, "nvglx: not enough memory, min %d bytes needed, %d available\n",
		minmemsize,maxmemsize);
	    fprintf (stderr, "  note: supposedly videoareasize=%ld bytes\n",
		     riva_sinfo[screennum].videoareasize);
*/

	riva_sinfo[snum].privMemSize =
		(si->engine.threeD.mem_high - si->engine.threeD.mem_low) + 1;
	riva_sinfo[snum].privMemOffset = si->engine.threeD.mem_low;
	/* start of visible screen */
	riva_sinfo[snum].privMemBase =
		(unsigned char *)si->framebuffer + si->engine.threeD.mem_low;

   /* allocate back and depth buffers. */
   nvAllocateBuffers();
   
	//rud: ok:
	riva_sinfo[snum].SetSurfaces2D = nvSetSurfaces2D;
	riva_sinfo[snum].SetSurfaces3D = nvSetSurfaces3D;

	LOG(2,("nvHookServerSymbols: depthoffset = $%08x, backoffset = $%08x\n",
		riva_sinfo[snum].depthbufferoffset,	riva_sinfo[snum].backbufferoffset));
	LOG(2,("nvHookServerSymbols: textureoffset = $%08lx\n",
		(riva_sinfo[snum].textureoffset)));

   fprintf(stderr,"DEBUG: nvHook wrapup: depthoffset=0x%x, backoffset=0x%x, textureoffset=0x%lx\n",
		riva_sinfo[snum].depthbufferoffset,
		riva_sinfo[snum].backbufferoffset,
		riva_sinfo[snum].textureoffset);

//rudfix:
    nvInitGLX(snum);
/*
{
//	XSMesaContext c;
//	XSMesaVisual v;

	c = RivaCreateContext(v, NULL); //rudolf assuming NULL!

	if (!RivaMakeCurrent(c))
	{
		LOG(2,("nvHookServerSymbols: RivaMakeCurrent failed!\n"));
	}
}
*/
   return 1;
}

/* called after a 2D modeswitch is completed */
void nvUpdateBuffers(bool mode_switching)
{
   int snum=FAKESNUM; /* XXX hardcode screennum. Bad Boy */
   int bytesperpixel;

	//fixme: just place NULL rendering functions in the driverinterface during mode-
	//switches, instead of letting them check for a modeswitch one-by-one!!!!!!!!!

	/* release all textures if applicable */
	if (riva_sinfo[FAKESNUM].rivaGLXEnabled) RivaReleaseTextures();

	/* we need to wait a bit after a mode-switch, to be sure the engine's 2D init
	 * is completely done */
	if (mode_switching) snooze(100000);

	switch (si->dm.space)
	{
	case B_RGB15_LITTLE:
		riva_sinfo[snum].bitsperpixel = 15;
		bytesperpixel = 2;
		break;
	case B_RGB16_LITTLE:
		riva_sinfo[snum].bitsperpixel = 16;
		bytesperpixel = 2;
		break;
   case B_RGB32_LITTLE:
		riva_sinfo[snum].bitsperpixel = 32;
		bytesperpixel = 4;
		break;
	default:
//      fprintf (stderr, "nvglx: unusable depth %d bpp\n",
//         scrninfoP->bitsPerPixel);
		return;
	}

	riva_sinfo[snum].bytesperpixel = bytesperpixel;

	/* virtual screen size in bytes */
	riva_sinfo[snum].videoareasize = si->dm.virtual_height * si->fbc.bytes_per_row;

	riva_sinfo[snum].privMemSize =
		(si->engine.threeD.mem_high - si->engine.threeD.mem_low) + 1;
	riva_sinfo[snum].privMemOffset = si->engine.threeD.mem_low;
	/* start of visible screen */
	riva_sinfo[snum].privMemBase =
		(unsigned char *)si->framebuffer + si->engine.threeD.mem_low;

   /* allocate back and depth buffers. */
   nvAllocateBuffers();

   fprintf(stderr,"DEBUG: nvHook wrapup: depthoffset=0x%x, backoffset=0x%x, textureoffset=0x%lx\n",
		riva_sinfo[snum].depthbufferoffset,
		riva_sinfo[snum].backbufferoffset,
		riva_sinfo[snum].textureoffset);

	/* now modify the visual's colorspace we will work in */
	GLcontext *ctx = gl_get_current_context();
	if (ctx)
	{
		/* note:
		 * BGL_RGB means that options bit 0 is zero; BGL_INDEX has bit 0 high!
		 * so these BGLview colorspace related bit-defines are a bit error prone... (!) */
	   const GLboolean rgbFlag = (ogl_options & BGL_INDEX) == BGL_RGB;
	   const GLboolean alphaFlag = (ogl_options & BGL_ALPHA) == BGL_ALPHA;
	   const GLint index = (ogl_options & BGL_INDEX) ? 32 : 0;

	   /* note:
    	* we should set the depth according to the really used depth for the colorbuffers.
	    * Although our colorbuffer accessroutines translate all calls between the
	    * current buffer's space and 32-bit depth for the caller, specifying the actually
	    * used space here sets up Mesa's internal value-rounding features: which is
	    * 'correct'.
	    *
	    * Faults here are 'easy' testable for instance with the GLteapot: grabbing it
	    * doesn't work probably if the space is set wrong (pixels are readback by the app:
	    * this (should) invoke(s) our 'ReadRGBASpanBack' function. */
   
		/* setup the info for the colorspace we will work in */
		GLint red = 0;
		GLint green = 0;
		GLint blue = 0;
		GLint alpha = 0;

		switch (si->dm.space)
		{
		case B_RGB32_LITTLE:
		case B_RGBA32_LITTLE:
			red = rgbFlag ? 8 : 0;
			green = rgbFlag ? 8 : 0;
			blue = rgbFlag ? 8 : 0;
			//fixme?
			alpha = alphaFlag ? 8 : 0;
			break;
		case B_RGB16_LITTLE:
			red = rgbFlag ? 5 : 0;
			green = rgbFlag ? 6 : 0;
			blue = rgbFlag ? 5 : 0;
			alpha = 0;
			break;
		case B_RGB15_LITTLE:
			red = rgbFlag ? 5 : 0;
			green = rgbFlag ? 5 : 0;
			blue = rgbFlag ? 5 : 0;
			//fixme?
			alpha = alphaFlag ? 1 : 0;
			break;
		default:
			//fixme: checkout indexed mode B_CMAP8
			break;
		}

		if (!rgbFlag)
			fprintf(stderr, "Mesa Warning: color index mode not supported\n");

		GLvisual *vis = ctx->Visual;
		if (vis)
		{
			vis->RedBits = red;
			vis->GreenBits = green;
			vis->BlueBits = blue;
			vis->AlphaBits = alpha;
		}
	}

	/* update Mesa settings */
	_mesa_ResizeBuffersMESA();

	/* reinit texture heap and reload default textures */
	riva_sinfo[snum].rivaGLXEnabled = RivaInitTextureHeap(snum);

	riva_sinfo[FAKESNUM].SetSurfaces3D(
		((rivaContext.bufRender == GL_FRONT) ?
			riva_sinfo[FAKESNUM].frontbufferoffset :
			riva_sinfo[FAKESNUM].backbufferoffset),
		riva_sinfo[FAKESNUM].depthbufferoffset);

	/* make sure 3D state will be reloaded */
	si->engine.threeD.reload |= clone_nr;

	/* re-register ourselves as a 3D clone accelerant */
	AQUIRE_BEN(si->engine.lock)
	if (get_clone_nr() == B_OK)
	{
		si->engine.threeD.clones |= clone_nr;
		LOG(2,("riva_symbols: Re-inited OK, 3D clone number is $%08x!\n", clone_nr));

		/* signal OK to start rendering again */
		si->engine.threeD.newmode &= ~clone_nr;
	}
	else
	{
		LOG(2,("riva_symbols: No more room for a 3D clone (shouldn't happen!)\n"));

		/* rendering remains forbidden. */
	}
	RELEASE_BEN(si->engine.lock)

	/* mode switch is processed. */
	driver_updated = true;
}

int nvUnhookServerSymbols(void)
{
	/* release all textures if applicable */
	if (riva_sinfo[FAKESNUM].rivaGLXEnabled) RivaReleaseTextures();

	free (riva_sinfo);
	riva_sinfo = NULL;
}
