 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1999 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/

#ifndef _NV_GLH_H
#define _NV_GLH_H

//rudolf:
#include "glh.h"
#include "DriverInterface.h"

/*
 * RIVA includes from X server.
 */
/* temp hack to maybe make things cleaner, and avoid including nv_local.h,
 * which then needs a WHOLE LOT MORE includes added
 */
//#define U032 CARD32
//#define U016 CARD16
//#define U008 CARD8

//rudolf: replace with Haiku 2D driver private includes
//#include "riva_hw.h"

/*
 * Buffer types for rivaBufferOffset[]
 */
#define RIVA_FRONT_BUFFER       0
#define RIVA_BACK_BUFFER        1
#define RIVA_DEPTH_BUFFER       2
#define RIVA_TEXTURE_BUFFER     3
#define RIVA_CACHE_BUFFER       4
/*
 * Current 3D state context.
 */
typedef struct riva_tri05_ctx
{
    unsigned                  texColorKey;
    unsigned                  texFormat;
    unsigned                  texFilter;
    unsigned                  triBlend;
    unsigned                  triControl;
    unsigned                  triFogColor;
} RIVA_TRI05_CTX;
typedef struct riva_3d_ctx
{
    struct gl_texture_object *texObj;
    unsigned                  texOffset;
    union
    {
        RIVA_TRI05_CTX        tri05;
    } triContext;
    unsigned                  modeMask;
    float                     sAdjust;
    float                     tAdjust;
    int                       bufRender;
    unsigned short            VCache[16];
    int                       NumCtxs;
    int                       SimpleClip;
    float                     xyAdjust;
    unsigned                  BugFix;
    float                     InvWScale;
} RIVA_3D_CTX;
extern RIVA_3D_CTX rivaContext;


#define RIVA_VCACHE_MASK        0x07
#define NV4_Z_ENABLE_BUG        0x00000001
#define NV4_ALPHATEST_BUG       0x00000002

/*
 * Some cool macros for use during texture swizzling.
 */
#define RIVA_U_INC(uu)          (((uu) + 0xAAAAAAAB) & 0x55555555)
#define RIVA_U_INC2(uu)         (((uu) + 0xAAAAAAAC) & 0x55555555)
#define RIVA_V_INC(vv)          (((vv) + 0x55555556) & 0xAAAAAAAA)
#define RIVA_UV_OFFSET(vv,uu)   ((vv)|(uu))
/*
 * More cool texture swizzling macros for non-square texture support.
 */
#define RIVA_U_INC_MASK(i, m, lh)                           \
{                                                           \
    m = ((1 << (2 * lh)) - 1);                              \
    i = (0xAAAAAAAA & m) + 1;                               \
    m = (0x55555555 & m) | (~m);                            \
}
#define RIVA_U_INC2_MASK(i1, i2, m, lh)                     \
{                                                           \
    m = ((1 << (2 * lh)) - 1);                              \
    i1 = (0xAAAAAAAA & m) + 1;                              \
    i2 = (0xAAAAAAAA & m) + 2;                              \
    m = (0x55555555 & m) | (~m);                            \
}
#define RIVA_V_INC_MASK(i, m, lw)                           \
{                                                           \
    m = ((1 << (2 * lw)) - 1);                              \
    i = (0x55555555 & m) + 1;                               \
    m = (0xAAAAAAAA & m) | (~m);                            \
}
#define RIVA_UV_INC(uv,i,m)     (((uv) + i) & m)
/*
 * HW macros.
 */
//rudolf: fixed set by 2D driver to 0,0,$8000,$8000. Enough for clear cmd??
#define RIVA_CLIP3D(scrnnum,xx1, yy1, xx2, yy2)                                             \
{ \
	si->engine.threeD.reload = 0xffffffff; /* 2D functions kill the 3D state */ \
	if (nv_acc_fifofree_dma(3) != B_OK) goto end; \
	nv_acc_cmd_dma(NV_IMAGE_BLACK_RECTANGLE, NV_IMAGE_BLACK_RECTANGLE_TOPLEFT, 2); \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = ((yy1) << 16) | (xx1); /* TopLeft */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = ((yy2-yy1) << 16) | (xx2-xx1); /* HeightWidth */ \
}
#define DEPTH_UNSCALE   (1.0F/(float)DEPTH_SCALE)
#define RIVA_STATE3D_05(scrnnum, ck, t0, t1, t2, bb, cc, fc)                                 \
{ \
	if (nv_acc_fifofree_dma(8) != B_OK) goto end; \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_COLORKEY, 7); \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = ck; /* Colorkey */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = t0; /* Offset */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = t1; /* Format */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = t2; /* Filter */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = bb; /* Blend */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = cc; /* Control */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = fc; /* FogColor */ \
}
#define RIVA_VERTEX3D_05(scrnnum,ii, xx, yy, zz, mm, argb, spec, ss, tt)                    \
{ \
	/*if (nv_acc_fifofree_dma(9) != B_OK) goto end;*/ \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_TLVERTEX(ii), 8); \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt; /* TV */ \
}
#define RIVA_3VERTEX3D_DRAW_05(xx1, yy1, zz1, mm1, argb1, spec1, ss1, tt1,  \
								xx2, yy2, zz2, mm2, argb2, spec2, ss2, tt2, \
								xx3, yy3, zz3, mm3, argb3, spec3, ss3, tt3) \
{ \
	/*if (nv_acc_fifofree_dma(26) != B_OK) goto end;*/ \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_TLVERTEX(0x0d), 25); \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx1; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy1; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz1)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm1; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb1; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec1; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss1; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt1; /* TV */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx2; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy2; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz2)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm2; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb2; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec2; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss2; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt2; /* TV */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx3; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy3; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz3)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm3; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb3; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec3; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss3; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt3; /* TV */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = (((0x0f)<<8)|((0x0e)<<4)|(0x0d)); /* TLVDrawPrim */ \
}
#define RIVA_4VERTEX3D_DRAW_05(xx1, yy1, zz1, mm1, argb1, spec1, ss1, tt1,  \
								xx2, yy2, zz2, mm2, argb2, spec2, ss2, tt2, \
								xx3, yy3, zz3, mm3, argb3, spec3, ss3, tt3, \
								xx4, yy4, zz4, mm4, argb4, spec4, ss4, tt4) \
{ \
	/*if (nv_acc_fifofree_dma(34) != B_OK) goto end;*/ \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_TLVERTEX(0x0c), 33); \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx1; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy1; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz1)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm1; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb1; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec1; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss1; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt1; /* TV */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx2; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy2; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz2)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm2; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb2; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec2; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss2; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt2; /* TV */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx3; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy3; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz3)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm3; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb3; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec3; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss3; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt3; /* TV */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = xx4; /* ScreenX */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = yy4; /* ScreenY */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = (zz4)*DEPTH_UNSCALE; /* ScreenZ */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = mm4; /* RWH */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = argb4; /* Color */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = spec4; /* Specular */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = ss4; /* TU */ \
	((float *)(si->dma_buffer))[si->engine.dma.current++] = tt4; /* TV */ \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = \
		(((0x0f)<<20)|((0x0e)<<16)|((0x0c)<<12)|((0x0e)<<8)|((0x0d)<<4)|(0x0c)); /* TLVDrawPrim */ \
}
#define RIVA_DRAWTRI3D_05(scrnnum,v0, v1, v2)                                               \
{ \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_TLVDRAWPRIM(0), 1); \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = (((v2)<<8)|((v1)<<4)|(v0)); /* TLVDrawPrim */ \
}
#define RIVA_DRAWQUAD3D_05(scrnnum,v0, v1, v2, v3)                                               \
{ \
	nv_acc_cmd_dma(NV4_DX5_TEXTURE_TRIANGLE, NV4_DX5_TEXTURE_TRIANGLE_TLVDRAWPRIM(0), 1); \
	((uint32*)(si->dma_buffer))[si->engine.dma.current++] = \
		(((v3)<<20)|((v2)<<16)|((v0)<<12)|((v2)<<8)|((v1)<<4)|(v0)); /* TLVDrawPrim */ \
}
/*
 * Get 1.0/W out of win coordinatea.
 */
#define INV_W(vv)   VB->Win.data[vv][3] * rivaContext.InvWScale
/*
 * Fast float->int conversions.
 */
#define RivaFloatToInt(intbits, fp)                                                 \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = (*(GLint *)&fpbits & 0x80000000)                                      \
            ? -(*(GLint *)&fpbits & 0x007FFFFF) : *(GLint *)&fpbits & 0x007FFFFF;   \
}
#define RivaFloatToUInt(intbits, fp)                                                \
{                                                                                   \
    GLfloat fpbits  = fp + 8388608.0F;                                              \
    intbits = *(GLint *)&fpbits & 0x007FFFFF;                                       \
}
/*
 * Link for hooking accelerated funcitons.
 */
void      RivaPointsNOP(GLcontext *, GLuint, GLuint);
void      RivaAAPoints3D03(GLcontext *, GLuint, GLuint);
void      RivaPoints3D05(GLcontext *, GLuint, GLuint);
void      RivaAAPoints3D05(GLcontext *, GLuint, GLuint);
void      RivaLineNOP(GLcontext *, GLuint, GLuint, GLuint);
void      RivaLine3D05(GLcontext *, GLuint, GLuint, GLuint);
void      RivaAALine3D05(GLcontext *, GLuint, GLuint, GLuint);
void      RivaTriangleNOP(GLcontext *, GLuint, GLuint, GLuint, GLuint);
void      RivaTriangle3D05(GLcontext *, GLuint, GLuint, GLuint, GLuint);
GLboolean RivaRenderVB(GLcontext *, GLboolean);
void      RivaUpdateState05(GLcontext *ctx);
//rudolf: modify for BeOS function instead (orig GLXProcs) 
void      RivaSwapBuffersDirect();//XSMesaBuffer);
void      RivaSwapBuffersIndirect();//XSMesaBuffer);
void      RivaWaitRetrace();
void      RivaSync(int snum);
void      RivaSyncRender(void);
//rudolf: modify for BeOS function instead (orig GLXProcs) 
//void      RivaPutPixel(GLXImage *,int x, int y, unsigned long pixel);

//rudolf:
GLboolean nvInitGLX(int);
//XSMesaContext RivaCreateContext(XSMesaVisual v, XSMesaContext share_list);
//GLboolean RivaMakeCurrent(XSMesaContext c);
GLdepth RivaGetDepth(GLcontext* ctx, int x, int y);
void RivaPutDepth(GLcontext* ctx, int x, int y, GLdepth depth);
void RivaCreateDepthBuffer(GLcontext *ctx);


//rudolf: beos version:
//GLboolean nvInitVisuals(VisualPtr *,/* DepthPtr *,*/ int *, int *, int *,/* VisualID *,*/ unsigned long, int);

#endif /* _NV_GLH_H */
